/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.FixedSizeCollection;
import com.google.api.gax.core.Page;
import com.google.api.gax.core.PagedListResponse;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FixedSizeCollectionImpl;
import com.google.api.gax.grpc.PageImpl;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.ValidationException;
import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;

public class PagedListResponseImpl<RequestT, ResponseT, ResourceT>
implements PagedListResponse<RequestT, ResponseT, ResourceT> {
    private RequestT request;
    private PagedListDescriptor<RequestT, ResponseT, ResourceT> pageDescriptor;
    private Page<RequestT, ResponseT, ResourceT> currentPage;

    public PagedListResponseImpl(UnaryCallable<RequestT, ResponseT> callable, PagedListDescriptor<RequestT, ResponseT, ResourceT> pageDescriptor, RequestT request, CallContext context) {
        this.pageDescriptor = pageDescriptor;
        this.request = request;
        this.currentPage = new PageImpl<RequestT, ResponseT, ResourceT>(callable, pageDescriptor, request, context);
    }

    @Override
    public Iterable<ResourceT> iterateAllElements() {
        return new Iterable<ResourceT>(){

            @Override
            public Iterator<ResourceT> iterator() {
                return new ResourceTIterator(PagedListResponseImpl.this.iteratePages());
            }
        };
    }

    @Override
    public Page<RequestT, ResponseT, ResourceT> getPage() {
        return this.currentPage;
    }

    @Override
    public Iterable<Page<RequestT, ResponseT, ResourceT>> iteratePages() {
        return this.currentPage.iteratePages();
    }

    @Override
    public Object getNextPageToken() {
        return this.currentPage.getNextPageToken();
    }

    @Override
    public FixedSizeCollection<ResourceT> expandToFixedSizeCollection(int collectionSize) {
        Integer requestPageSize = this.pageDescriptor.extractPageSize(this.request);
        if (requestPageSize == null) {
            throw new ValidationException("Error while expanding Page to FixedSizeCollection: No pageSize parameter found. The pageSize parameter must be set on the request object, and must be less than the collectionSize parameter, in order to create a FixedSizeCollection object.", new Object[0]);
        }
        if (requestPageSize > collectionSize) {
            throw new ValidationException("Error while expanding Page to FixedSizeCollection: collectionSize parameter is less than the pageSize optional argument specified on the request object. collectionSize: " + collectionSize + ", pageSize: " + requestPageSize, new Object[0]);
        }
        return FixedSizeCollectionImpl.expandPage(this.getPage(), collectionSize);
    }

    @Override
    public Iterable<FixedSizeCollection<ResourceT>> iterateFixedSizeCollections(int collectionSize) {
        return this.expandToFixedSizeCollection(collectionSize).iterateCollections();
    }

    static class ResourceTIterator<RequestT, ResponseT, ResourceT>
    extends AbstractIterator<ResourceT> {
        Iterator<Page<RequestT, ResponseT, ResourceT>> pageIterator;
        Iterator<ResourceT> currentIterator;

        public ResourceTIterator(Iterable<Page<RequestT, ResponseT, ResourceT>> pageIterable) {
            this.pageIterator = pageIterable.iterator();
            this.currentIterator = Collections.emptyIterator();
        }

        protected ResourceT computeNext() {
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            if (!this.pageIterator.hasNext()) {
                return (ResourceT)this.endOfData();
            }
            this.currentIterator = this.pageIterator.next().iterator();
            return this.computeNext();
        }
    }
}

