/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.FixedSizeCollection;
import com.google.api.gax.core.Page;
import com.google.api.gax.grpc.PagedListResponseImpl;
import com.google.api.gax.protobuf.ValidationException;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class FixedSizeCollectionImpl<RequestT, ResponseT, ResourceT>
implements FixedSizeCollection<ResourceT> {
    private List<Page<RequestT, ResponseT, ResourceT>> pageList;
    private int collectionSize;

    private FixedSizeCollectionImpl(List<Page<RequestT, ResponseT, ResourceT>> pageList, int collectionSize) {
        this.pageList = pageList;
        this.collectionSize = collectionSize;
    }

    public static <RequestT, ResponseT, ResourceT> FixedSizeCollection<ResourceT> expandPage(Page<RequestT, ResponseT, ResourceT> firstPage, int collectionSize) {
        if (firstPage.getPageElementCount() > collectionSize) {
            throw new ValidationException("Cannot construct a FixedSizeCollection with collectionSize less than the number of elements in the first page", new Object[0]);
        }
        return new FixedSizeCollectionImpl<RequestT, ResponseT, ResourceT>(FixedSizeCollectionImpl.createPageArray(firstPage, collectionSize), collectionSize);
    }

    @Override
    public Iterator<ResourceT> iterator() {
        return new PagedListResponseImpl.ResourceTIterator<RequestT, ResponseT, ResourceT>(this.pageList);
    }

    @Override
    public boolean hasNextCollection() {
        return this.getLastPage().hasNextPage();
    }

    @Override
    public Object getNextPageToken() {
        return this.getLastPage().getNextPageToken();
    }

    @Override
    public int getCollectionSize() {
        int size = 0;
        for (Page<RequestT, ResponseT, ResourceT> page : this.pageList) {
            size += page.getPageElementCount();
        }
        return size;
    }

    @Override
    public FixedSizeCollection<ResourceT> getNextCollection() {
        if (!this.hasNextCollection()) {
            throw new ValidationException("Could not complete getNextCollection operation: there are no more collections to retrieve.", new Object[0]);
        }
        return FixedSizeCollectionImpl.expandPage(this.getLastPage().getNextPage(this.collectionSize), this.collectionSize);
    }

    @Override
    public Iterable<FixedSizeCollection<ResourceT>> iterateCollections() {
        return new Iterable<FixedSizeCollection<ResourceT>>(){

            @Override
            public Iterator<FixedSizeCollection<ResourceT>> iterator() {
                return new FixedSizeCollectionIterator(FixedSizeCollectionImpl.this);
            }
        };
    }

    private Page<RequestT, ResponseT, ResourceT> getLastPage() {
        return this.pageList.get(this.pageList.size() - 1);
    }

    private static <RequestT, ResponseT, ResourceT> List<Page<RequestT, ResponseT, ResourceT>> createPageArray(Page<RequestT, ResponseT, ResourceT> initialPage, int collectionSize) {
        int rxElementCount;
        ArrayList<Page<RequestT, ResponseT, ResourceT>> pageList = new ArrayList<Page<RequestT, ResponseT, ResourceT>>();
        pageList.add(initialPage);
        Page<RequestT, ResponseT, ResourceT> currentPage = initialPage;
        for (int itemCount = currentPage.getPageElementCount(); itemCount < collectionSize && currentPage.hasNextPage(); itemCount += rxElementCount) {
            int remainingCount = collectionSize - itemCount;
            rxElementCount = (currentPage = currentPage.getNextPage(remainingCount)).getPageElementCount();
            if (rxElementCount > remainingCount) {
                throw new ValidationException("API returned a number of elements exceeding the specified page_size limit. page_size: " + collectionSize + ", elements received: " + rxElementCount, new Object[0]);
            }
            pageList.add(currentPage);
        }
        return pageList;
    }

    private static class FixedSizeCollectionIterator<ResourceT>
    extends AbstractIterator<FixedSizeCollection<ResourceT>> {
        private FixedSizeCollection<ResourceT> currentCollection;
        boolean currentCollectionHasBeenViewed;

        private FixedSizeCollectionIterator(FixedSizeCollection<ResourceT> firstCollection) {
            this.currentCollection = firstCollection;
            this.currentCollectionHasBeenViewed = false;
        }

        protected FixedSizeCollection<ResourceT> computeNext() {
            if (this.currentCollection == null) {
                this.endOfData();
            }
            if (!this.currentCollectionHasBeenViewed) {
                this.currentCollectionHasBeenViewed = true;
                return this.currentCollection;
            }
            FixedSizeCollection<ResourceT> oldPage = this.currentCollection;
            this.currentCollection = oldPage.hasNextCollection() ? oldPage.getNextCollection() : null;
            return oldPage;
        }
    }
}

