/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.ThresholdBundleHandle;
import com.google.api.gax.grpc.BlockingCallThreshold;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class BundlingFuture<ResponseT>
implements ListenableFuture<ResponseT> {
    private final Lock lock = new ReentrantLock();
    private final SettableFuture<ResponseT> settableFuture = SettableFuture.create();
    private ThresholdBundleHandle bundleHandle;

    public static <T> BundlingFuture<T> create() {
        return new BundlingFuture();
    }

    private BundlingFuture() {
    }

    public void addListener(Runnable runnable, Executor executor) {
        this.settableFuture.addListener(runnable, executor);
    }

    public ResponseT get() throws InterruptedException, ExecutionException {
        Lock lock = this.lock;
        lock.lock();
        ThresholdBundleHandle localBundleHandle = null;
        try {
            localBundleHandle = this.bundleHandle;
        }
        finally {
            lock.unlock();
        }
        if (localBundleHandle != null) {
            localBundleHandle.externalThresholdEvent(new BlockingCallThreshold.NewBlockingCall());
        }
        return (ResponseT)this.settableFuture.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseT get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Lock lock = this.lock;
        lock.lock();
        ThresholdBundleHandle localBundleHandle = null;
        try {
            localBundleHandle = this.bundleHandle;
        }
        finally {
            lock.unlock();
        }
        if (localBundleHandle != null) {
            localBundleHandle.externalThresholdEvent(new BlockingCallThreshold.NewBlockingCall());
        }
        return (ResponseT)this.settableFuture.get(timeout, unit);
    }

    public boolean set(ResponseT value) {
        return this.settableFuture.set(value);
    }

    public boolean setException(Throwable throwable) {
        return this.settableFuture.setException(throwable);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.settableFuture.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.settableFuture.isCancelled();
    }

    public boolean isDone() {
        return this.settableFuture.isDone();
    }

    public void setBundleHandle(ThresholdBundleHandle bundleHandle) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.bundleHandle = bundleHandle;
        }
        finally {
            lock.unlock();
        }
    }
}

