/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.base.Strings;
import com.google.rpc.Code;
import java.util.Objects;

@BetaApi
@InternalExtensionOnly
public class HttpJsonStatusCode
implements StatusCode {
    static final String FAILED_PRECONDITION = "FAILED_PRECONDITION";
    static final String OUT_OF_RANGE = "OUT_OF_RANGE";
    static final String ALREADY_EXISTS = "ALREADY_EXISTS";
    static final String DATA_LOSS = "DATA_LOSS";
    static final String UNKNOWN = "UNKNOWN";
    private final int httpStatus;
    private final StatusCode.Code statusCode;

    public static HttpJsonStatusCode of(int httpStatus, String errorMessage) {
        return new HttpJsonStatusCode(httpStatus, HttpJsonStatusCode.httpStatusToStatusCode(httpStatus, errorMessage));
    }

    public static HttpJsonStatusCode of(StatusCode.Code statusCode) {
        return new HttpJsonStatusCode(statusCode.getHttpStatusCode(), statusCode);
    }

    public static HttpJsonStatusCode of(Code rpcCode) {
        return new HttpJsonStatusCode(rpcCode.getNumber(), HttpJsonStatusCode.rpcCodeToStatusCode(rpcCode));
    }

    static StatusCode.Code rpcCodeToStatusCode(Code rpcCode) {
        switch (rpcCode) {
            case OK: {
                return StatusCode.Code.OK;
            }
            case CANCELLED: {
                return StatusCode.Code.CANCELLED;
            }
            case UNKNOWN: {
                return StatusCode.Code.UNKNOWN;
            }
            case INVALID_ARGUMENT: {
                return StatusCode.Code.INVALID_ARGUMENT;
            }
            case DEADLINE_EXCEEDED: {
                return StatusCode.Code.DEADLINE_EXCEEDED;
            }
            case NOT_FOUND: {
                return StatusCode.Code.DEADLINE_EXCEEDED;
            }
            case ALREADY_EXISTS: {
                return StatusCode.Code.ALREADY_EXISTS;
            }
            case PERMISSION_DENIED: {
                return StatusCode.Code.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return StatusCode.Code.RESOURCE_EXHAUSTED;
            }
            case FAILED_PRECONDITION: {
                return StatusCode.Code.FAILED_PRECONDITION;
            }
            case ABORTED: {
                return StatusCode.Code.ABORTED;
            }
            case OUT_OF_RANGE: {
                return StatusCode.Code.OUT_OF_RANGE;
            }
            case UNIMPLEMENTED: {
                return StatusCode.Code.UNIMPLEMENTED;
            }
            case INTERNAL: {
                return StatusCode.Code.INTERNAL;
            }
            case UNAVAILABLE: {
                return StatusCode.Code.UNAVAILABLE;
            }
            case DATA_LOSS: {
                return StatusCode.Code.DATA_LOSS;
            }
            case UNAUTHENTICATED: {
                return StatusCode.Code.UNAUTHENTICATED;
            }
        }
        throw new IllegalArgumentException("Unrecognized rpc code: " + rpcCode);
    }

    static StatusCode.Code httpStatusToStatusCode(int httpStatus, String errorMessage) {
        String causeMessage = Strings.nullToEmpty((String)errorMessage).toUpperCase();
        switch (httpStatus) {
            case 200: {
                return StatusCode.Code.OK;
            }
            case 400: {
                if (causeMessage.contains(OUT_OF_RANGE)) {
                    return StatusCode.Code.OUT_OF_RANGE;
                }
                if (causeMessage.contains(FAILED_PRECONDITION)) {
                    return StatusCode.Code.FAILED_PRECONDITION;
                }
                return StatusCode.Code.INVALID_ARGUMENT;
            }
            case 401: {
                return StatusCode.Code.UNAUTHENTICATED;
            }
            case 403: {
                return StatusCode.Code.PERMISSION_DENIED;
            }
            case 404: {
                return StatusCode.Code.NOT_FOUND;
            }
            case 409: {
                if (causeMessage.contains(ALREADY_EXISTS)) {
                    return StatusCode.Code.ALREADY_EXISTS;
                }
                return StatusCode.Code.ABORTED;
            }
            case 411: {
                throw new IllegalStateException("411 status code received (Content-Length header not given.) Please file a bug against https://github.com/googleapis/gax-java/\n" + httpStatus);
            }
            case 429: {
                return StatusCode.Code.RESOURCE_EXHAUSTED;
            }
            case 499: {
                return StatusCode.Code.CANCELLED;
            }
            case 500: {
                if (causeMessage.contains(DATA_LOSS)) {
                    return StatusCode.Code.DATA_LOSS;
                }
                if (causeMessage.contains(UNKNOWN)) {
                    return StatusCode.Code.UNKNOWN;
                }
                return StatusCode.Code.INTERNAL;
            }
            case 501: {
                return StatusCode.Code.UNIMPLEMENTED;
            }
            case 503: {
                return StatusCode.Code.UNAVAILABLE;
            }
            case 504: {
                return StatusCode.Code.DEADLINE_EXCEEDED;
            }
        }
        throw new IllegalArgumentException("Unrecognized http status code: " + httpStatus);
    }

    public StatusCode.Code getCode() {
        return this.statusCode;
    }

    public Integer getTransportCode() {
        return this.httpStatus;
    }

    private HttpJsonStatusCode(int code, StatusCode.Code statusCode) {
        this.httpStatus = code;
        this.statusCode = statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpJsonStatusCode that = (HttpJsonStatusCode)o;
        return Objects.equals(this.statusCode, that.statusCode);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode);
    }

    public String toString() {
        return "HttpJsonStatusCode{statusCode=" + this.statusCode + "}";
    }
}

