/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson.testing;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public final class MockHttpService
extends MockHttpTransport {
    private final Multimap<String, String> requestHeaders = LinkedListMultimap.create();
    private final List<String> requestPaths = new LinkedList<String>();
    private final Queue<HttpResponseFactory> responseHandlers = new LinkedList<HttpResponseFactory>();
    private List<ApiMethodDescriptor> serviceMethodDescriptors;
    private String endpoint;

    public MockHttpService(List<ApiMethodDescriptor> serviceMethodDescriptors, String pathPrefix) {
        this.serviceMethodDescriptors = ImmutableList.copyOf(serviceMethodDescriptors);
        this.endpoint = pathPrefix;
    }

    public LowLevelHttpRequest buildRequest(final String method, final String url) {
        this.requestPaths.add(url);
        return new MockLowLevelHttpRequest(){

            public void addHeader(String name, String value) {
                MockHttpService.this.requestHeaders.put((Object)name, (Object)value);
            }

            public LowLevelHttpResponse execute() {
                return MockHttpService.this.getHttpResponse(method, url);
            }
        };
    }

    public void addResponse(final Object response) {
        this.responseHandlers.add(new HttpResponseFactory(){

            @Override
            public MockLowLevelHttpResponse getHttpResponse(String httpMethod, String fullTargetUrl) {
                MockLowLevelHttpResponse httpResponse = new MockLowLevelHttpResponse();
                Preconditions.checkArgument((MockHttpService.this.serviceMethodDescriptors != null ? 1 : 0) != 0, (Object)"MockHttpService has null serviceMethodDescriptors.");
                String relativePath = MockHttpService.this.getRelativePath(fullTargetUrl);
                for (ApiMethodDescriptor methodDescriptor : MockHttpService.this.serviceMethodDescriptors) {
                    PathTemplate pathTemplate;
                    if (!httpMethod.equals(methodDescriptor.getHttpMethod()) || !(pathTemplate = methodDescriptor.getRequestFormatter().getPathTemplate()).matches(relativePath)) continue;
                    String httpContent = methodDescriptor.getResponseParser().serialize(response);
                    httpResponse.setContent(httpContent.getBytes());
                    httpResponse.setStatusCode(200);
                    return httpResponse;
                }
                httpResponse.setContent(String.format("Method not found for path '%s'", relativePath).getBytes());
                httpResponse.setStatusCode(404);
                return httpResponse;
            }
        });
    }

    public void addNullResponse() {
        this.responseHandlers.add(new HttpResponseFactory(){

            @Override
            public MockLowLevelHttpResponse getHttpResponse(String httpMethod, String targetUrl) {
                return new MockLowLevelHttpResponse().setStatusCode(200);
            }
        });
    }

    public void addException(final Exception exception) {
        this.responseHandlers.add(new HttpResponseFactory(){

            @Override
            public MockLowLevelHttpResponse getHttpResponse(String httpMethod, String targetUrl) {
                MockLowLevelHttpResponse httpResponse = new MockLowLevelHttpResponse();
                httpResponse.setStatusCode(400);
                httpResponse.setContent(exception.toString().getBytes());
                httpResponse.setContentEncoding("text/plain");
                return httpResponse;
            }
        });
    }

    public List<String> getRequestPaths() {
        return this.requestPaths;
    }

    public Multimap<String, String> getRequestHeaders() {
        return ImmutableListMultimap.copyOf(this.requestHeaders);
    }

    public void reset() {
        this.responseHandlers.clear();
        this.requestPaths.clear();
        this.requestHeaders.clear();
    }

    private String getRelativePath(String fullTargetUrl) {
        String relativePath = fullTargetUrl.replaceFirst(this.endpoint, "");
        int queryParamIndex = relativePath.indexOf("?");
        queryParamIndex = queryParamIndex < 0 ? relativePath.length() : queryParamIndex;
        relativePath = relativePath.substring(0, queryParamIndex);
        return relativePath;
    }

    private MockLowLevelHttpResponse getHttpResponse(String httpMethod, String targetUrl) {
        Preconditions.checkArgument((!this.responseHandlers.isEmpty() ? 1 : 0) != 0);
        return this.responseHandlers.poll().getHttpResponse(httpMethod, targetUrl);
    }

    private static interface HttpResponseFactory {
        public MockLowLevelHttpResponse getHttpResponse(String var1, String var2);
    }
}

