/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.httpjson.HttpJsonHeaderEnhancers;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.ManagedHttpJsonChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public final class InstantiatingHttpJsonChannelProvider
implements TransportChannelProvider {
    private final ExecutorProvider executorProvider;
    private final HeaderProvider headerProvider;
    private final String endpoint;

    private InstantiatingHttpJsonChannelProvider(ExecutorProvider executorProvider, HeaderProvider headerProvider, String endpoint) {
        this.executorProvider = executorProvider;
        this.headerProvider = headerProvider;
        this.endpoint = endpoint;
    }

    public boolean needsExecutor() {
        return this.executorProvider == null;
    }

    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.toBuilder().setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)executor)).build();
    }

    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers)).build();
    }

    public String getTransportName() {
        return HttpJsonTransportChannel.getHttpJsonTransportName();
    }

    public TransportChannel getTransportChannel() throws IOException {
        if (this.needsExecutor()) {
            throw new IllegalStateException("getTransportChannel() called when needsExecutor() is true");
        }
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        return this.createChannel();
    }

    private TransportChannel createChannel() throws IOException {
        ScheduledExecutorService executor = this.executorProvider.getExecutor();
        Map headers = this.headerProvider.getHeaders();
        ArrayList headerEnhancers = Lists.newArrayList();
        for (Map.Entry header : headers.entrySet()) {
            headerEnhancers.add(HttpJsonHeaderEnhancers.create((String)header.getKey(), (String)header.getValue()));
        }
        ManagedHttpJsonChannel channel = ManagedHttpJsonChannel.newBuilder().setEndpoint(this.endpoint).setHeaderEnhancers(headerEnhancers).setExecutor(executor).build();
        return HttpJsonTransportChannel.newBuilder().setManagedChannel(channel).build();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ExecutorProvider executorProvider;
        private HeaderProvider headerProvider;
        private String endpoint;

        private Builder() {
        }

        private Builder(InstantiatingHttpJsonChannelProvider provider) {
            this.executorProvider = provider.executorProvider;
            this.headerProvider = provider.headerProvider;
            this.endpoint = provider.endpoint;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public InstantiatingHttpJsonChannelProvider build() {
            return new InstantiatingHttpJsonChannelProvider(this.executorProvider, this.headerProvider, this.endpoint);
        }
    }
}

