/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ReturnExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class ReturnExpr
implements Expr {
    public abstract Expr expr();

    @Override
    public TypeNode type() {
        return TypeNode.VOID;
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static ReturnExpr withExpr(Expr expr) {
        return ReturnExpr.builder().setExpr(expr).build();
    }

    static Builder builder() {
        return new AutoValue_ReturnExpr.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract Builder setExpr(Expr var1);

        abstract Expr expr();

        abstract ReturnExpr autoBuild();

        public ReturnExpr build() {
            Preconditions.checkState(!(this.expr() instanceof ReturnExpr), "ReturnExpr can only return non-ReturnExpr expressions");
            return this.autoBuild();
        }
    }
}

