/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_PackageInfoDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class PackageInfoDefinition
implements AstNode {
    public abstract String pakkage();

    public abstract ImmutableList<CommentStatement> fileHeader();

    public abstract ImmutableList<CommentStatement> headerCommentStatements();

    public abstract ImmutableList<AnnotationNode> annotations();

    public abstract Builder toBuilder();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_PackageInfoDefinition.Builder().setFileHeader(Collections.emptyList()).setHeaderCommentStatements(Collections.emptyList()).setAnnotations(Collections.emptyList());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setPakkage(String var1);

        public Builder setFileHeader(CommentStatement ... headerComments) {
            return this.setFileHeader(Arrays.asList(headerComments));
        }

        public abstract Builder setFileHeader(List<CommentStatement> var1);

        public Builder setHeaderCommentStatements(CommentStatement ... comments) {
            return this.setHeaderCommentStatements(Arrays.asList(comments));
        }

        public abstract Builder setHeaderCommentStatements(List<CommentStatement> var1);

        public Builder setAnnotations(AnnotationNode ... annotations) {
            return this.setAnnotations(Arrays.asList(annotations));
        }

        public abstract Builder setAnnotations(List<AnnotationNode> var1);

        abstract PackageInfoDefinition autoBuild();

        public PackageInfoDefinition build() {
            PackageInfoDefinition packageInfo = this.autoBuild();
            String contextInfo = String.format("package info for %s", packageInfo.pakkage());
            NodeValidator.checkNoNullElements(packageInfo.fileHeader(), "file header", contextInfo);
            NodeValidator.checkNoNullElements(packageInfo.headerCommentStatements(), "header comments", contextInfo);
            NodeValidator.checkNoNullElements(packageInfo.annotations(), "annotations", contextInfo);
            return packageInfo;
        }
    }
}

