/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.ArrayExpr;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_AnnotationNode;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class AnnotationNode
implements AstNode {
    public static AnnotationNode OVERRIDE = AnnotationNode.builder().setType(AnnotationNode.annotationType(Override.class)).build();
    public static AnnotationNode DEPRECATED = AnnotationNode.builder().setType(AnnotationNode.annotationType(Deprecated.class)).build();

    private static TypeNode annotationType(Class<?> clazz) {
        return TypeNode.withReference(ConcreteReference.withClazz(clazz));
    }

    public abstract TypeNode type();

    @Nullable
    public abstract List<Expr> descriptionExprs();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static AnnotationNode withTypeAndDescription(TypeNode type, String description) {
        return AnnotationNode.builder().setType(type).setDescription(description).build();
    }

    public static AnnotationNode withTypeAndDescription(TypeNode type, List<Expr> exprList) {
        return AnnotationNode.builder().setType(type).setDescriptions(exprList).build();
    }

    public static AnnotationNode withSuppressWarnings(String description) {
        return AnnotationNode.withTypeAndDescription(AnnotationNode.annotationType(SuppressWarnings.class), description);
    }

    public static AnnotationNode withType(TypeNode type) {
        return AnnotationNode.builder().setType(type).build();
    }

    public static Builder builder() {
        return new AutoValue_AnnotationNode.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private static final String REPEAT_SINGLE_EXCEPTION_MESSAGE = "Single parameter with no name cannot be set multiple times";
        private static final String MULTIPLE_AFTER_SINGLE_EXCEPTION_MESSAGE = "Multiple parameters must have names";

        abstract List<Expr> descriptionExprs();

        public abstract Builder setType(TypeNode var1);

        public Builder setDescription(String description) {
            Preconditions.checkState(this.descriptionExprs() == null, REPEAT_SINGLE_EXCEPTION_MESSAGE);
            return this.setDescriptionExprs(Arrays.asList(ValueExpr.withValue(StringObjectValue.withValue(description))));
        }

        public Builder setDescription(ValueExpr valueExpr) {
            Preconditions.checkState(this.descriptionExprs() == null, REPEAT_SINGLE_EXCEPTION_MESSAGE);
            return this.setDescriptionExprs(Arrays.asList(valueExpr));
        }

        public Builder setDescription(VariableExpr variableExpr) {
            Preconditions.checkState(this.descriptionExprs() == null, REPEAT_SINGLE_EXCEPTION_MESSAGE);
            return this.setDescriptionExprs(Arrays.asList(variableExpr));
        }

        public Builder setDescription(ArrayExpr arrayExpr) {
            Preconditions.checkState(this.descriptionExprs() == null, REPEAT_SINGLE_EXCEPTION_MESSAGE);
            return this.setDescriptionExprs(Arrays.asList(arrayExpr));
        }

        public Builder addDescription(AssignmentExpr assignmentExpr) {
            return this.addDescriptionToList(assignmentExpr);
        }

        private Builder setDescriptions(List<Expr> exprList) {
            return this.setDescriptionExprs(exprList);
        }

        private Builder addDescriptionToList(Expr expr) {
            List<Expr> exprList = this.descriptionExprs();
            Preconditions.checkState(exprList == null || exprList instanceof ArrayList, MULTIPLE_AFTER_SINGLE_EXCEPTION_MESSAGE);
            if (exprList == null) {
                exprList = new ArrayList<Expr>();
            }
            exprList.add(expr);
            return this.setDescriptions(exprList);
        }

        abstract Builder setDescriptionExprs(List<Expr> var1);

        abstract AnnotationNode autoBuild();

        public AnnotationNode build() {
            AnnotationNode annotation = this.autoBuild();
            Reference ref = annotation.type().reference();
            Preconditions.checkNotNull(ref, "Annotations must be an Object type");
            return annotation;
        }
    }
}

