/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer;

import com.google.api.client.util.Preconditions;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.ReflectConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ClientLibraryReflectConfigComposer {
    private ClientLibraryReflectConfigComposer() {
    }

    public static List<ReflectConfig> generateReflectConfig(GapicContext context) {
        ArrayList<String> allConfigs = new ArrayList<String>();
        context.messages().forEach((fullyQualifiedClassName, msg) -> allConfigs.addAll(ClientLibraryReflectConfigComposer.calculateReflectConfigList(fullyQualifiedClassName, msg)));
        List<String> duplicates = ClientLibraryReflectConfigComposer.calculateDuplicates(allConfigs);
        Preconditions.checkState(duplicates.isEmpty(), "Duplicate binary name entries found: %s", duplicates);
        return allConfigs.stream().sorted().map(ReflectConfig::new).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    static List<String> calculateReflectConfigList(String fullyQualifiedClassName, Message message) {
        String binaryName = ClientLibraryReflectConfigComposer.convertToBinaryName(fullyQualifiedClassName);
        ArrayList<String> list = new ArrayList<String>();
        list.add(binaryName);
        for (String nestedEnum : message.nestedEnums()) {
            list.add(binaryName + "$" + nestedEnum);
        }
        if (!message.isEnum()) {
            list.add(binaryName + "$Builder");
        }
        return list;
    }

    @VisibleForTesting
    static String convertToBinaryName(String fullyQualifiedClassName) {
        StringBuilder result = new StringBuilder();
        boolean isNested = false;
        for (String s : fullyQualifiedClassName.split("\\.")) {
            if (result.length() != 0) {
                result.append(isNested ? "$" : ".");
            }
            result.append(s);
            if (!Character.isUpperCase(s.charAt(0))) continue;
            isNested = true;
        }
        return result.toString();
    }

    @VisibleForTesting
    static List<String> calculateDuplicates(List<String> allConfigs) {
        ArrayList<String> duplicates = new ArrayList<String>(allConfigs);
        new HashSet<String>(allConfigs).forEach(duplicates::remove);
        return duplicates;
    }
}

