/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.InternalServerInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.MetricRecorder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.SynchronizationContext;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.xds.AutoValue_XdsServerWrapper_ServerRoutingConfig;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.Filter;
import io.grpc.xds.FilterChainMatchingProtocolNegotiators;
import io.grpc.xds.FilterChainSelectorManager;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.RoutingUtils;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClientPoolFactory;
import io.grpc.xds.XdsListenerResource;
import io.grpc.xds.XdsRouteConfigureResource;
import io.grpc.xds.XdsServerBuilder;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.internal.security.SslContextProviderSupplier;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class XdsServerWrapper
extends Server {
    private static final Logger logger = Logger.getLogger(XdsServerWrapper.class.getName());
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            logger.log(Level.SEVERE, "Exception!" + e);
        }
    });
    public static final Attributes.Key<AtomicReference<ServerRoutingConfig>> ATTR_SERVER_ROUTING_CONFIG = Attributes.Key.create("io.grpc.xds.ServerWrapper.serverRoutingConfig");
    @VisibleForTesting
    static final long RETRY_DELAY_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private final String listenerAddress;
    private final ServerBuilder<?> delegateBuilder;
    private boolean sharedTimeService;
    private final ScheduledExecutorService timeService;
    private final FilterRegistry filterRegistry;
    private final ThreadSafeRandom random = ThreadSafeRandom.ThreadSafeRandomImpl.instance;
    private final XdsClientPoolFactory xdsClientPoolFactory;
    private final XdsServerBuilder.XdsServingStatusListener listener;
    private final FilterChainSelectorManager filterChainSelectorManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean isServing;
    private final CountDownLatch internalTerminationLatch = new CountDownLatch(1);
    private final SettableFuture<Exception> initialStartFuture = SettableFuture.create();
    private boolean initialStarted;
    private SynchronizationContext.ScheduledHandle restartTimer;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private DiscoveryState discoveryState;
    private volatile Server delegate;
    private final HashMap<String, HashMap<String, Filter>> activeFilters = new HashMap();
    private final HashMap<String, Filter> activeFiltersDefaultChain = new HashMap();

    XdsServerWrapper(String listenerAddress, ServerBuilder<?> delegateBuilder, XdsServerBuilder.XdsServingStatusListener listener, FilterChainSelectorManager filterChainSelectorManager, XdsClientPoolFactory xdsClientPoolFactory, FilterRegistry filterRegistry) {
        this(listenerAddress, delegateBuilder, listener, filterChainSelectorManager, xdsClientPoolFactory, filterRegistry, SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE));
        this.sharedTimeService = true;
    }

    @VisibleForTesting
    XdsServerWrapper(String listenerAddress, ServerBuilder<?> delegateBuilder, XdsServerBuilder.XdsServingStatusListener listener, FilterChainSelectorManager filterChainSelectorManager, XdsClientPoolFactory xdsClientPoolFactory, FilterRegistry filterRegistry, ScheduledExecutorService timeService) {
        this.listenerAddress = Preconditions.checkNotNull(listenerAddress, "listenerAddress");
        this.delegateBuilder = Preconditions.checkNotNull(delegateBuilder, "delegateBuilder");
        this.delegateBuilder.intercept(new ConfigApplyingInterceptor());
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.filterChainSelectorManager = Preconditions.checkNotNull(filterChainSelectorManager, "filterChainSelectorManager");
        this.xdsClientPoolFactory = Preconditions.checkNotNull(xdsClientPoolFactory, "xdsClientPoolFactory");
        this.timeService = Preconditions.checkNotNull(timeService, "timeService");
        this.filterRegistry = Preconditions.checkNotNull(filterRegistry, "filterRegistry");
        this.delegate = delegateBuilder.build();
    }

    @Override
    public Server start() throws IOException {
        Exception exception;
        Preconditions.checkState(this.started.compareAndSet(false, true), "Already started");
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                XdsServerWrapper.this.internalStart();
            }
        });
        try {
            exception = (Exception)this.initialStartFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (exception != null) {
            throw exception instanceof IOException ? (IOException)exception : new IOException(exception);
        }
        return this;
    }

    private void internalStart() {
        try {
            this.xdsClientPool = this.xdsClientPoolFactory.getOrCreate("#server", new MetricRecorder(){});
        }
        catch (Exception e) {
            StatusException statusException = Status.UNAVAILABLE.withDescription("Failed to initialize xDS").withCause(e).asException();
            this.listener.onNotServing(statusException);
            this.initialStartFuture.set(statusException);
            return;
        }
        this.xdsClient = this.xdsClientPool.getObject();
        String listenerTemplate = this.xdsClient.getBootstrapInfo().serverListenerResourceNameTemplate();
        if (listenerTemplate == null) {
            StatusException statusException = Status.UNAVAILABLE.withDescription("Can only support xDS v3 with listener resource name template").asException();
            this.listener.onNotServing(statusException);
            this.initialStartFuture.set(statusException);
            this.xdsClient = this.xdsClientPool.returnObject(this.xdsClient);
            return;
        }
        String replacement = this.listenerAddress;
        if (listenerTemplate.startsWith("xdstp:")) {
            replacement = XdsClient.percentEncodePath(replacement);
        }
        this.discoveryState = new DiscoveryState(listenerTemplate.replaceAll("%s", replacement));
    }

    @Override
    public Server shutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!XdsServerWrapper.this.delegate.isShutdown()) {
                    XdsServerWrapper.this.delegate.shutdown();
                }
                XdsServerWrapper.this.internalShutdown();
            }
        });
        return this;
    }

    @Override
    public Server shutdownNow() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!XdsServerWrapper.this.delegate.isShutdown()) {
                    XdsServerWrapper.this.delegate.shutdownNow();
                }
                XdsServerWrapper.this.internalShutdown();
                XdsServerWrapper.this.initialStartFuture.set(new IOException("server is forcefully shut down"));
            }
        });
        return this;
    }

    private void internalShutdown() {
        logger.log(Level.FINER, "Shutting down XdsServerWrapper");
        if (this.discoveryState != null) {
            this.discoveryState.shutdown();
        }
        if (this.xdsClient != null) {
            this.xdsClient = this.xdsClientPool.returnObject(this.xdsClient);
        }
        if (this.restartTimer != null) {
            this.restartTimer.cancel();
        }
        if (this.sharedTimeService) {
            SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timeService);
        }
        this.isServing = false;
        this.internalTerminationLatch.countDown();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.internalTerminationLatch.getCount() == 0L && this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        if (!this.internalTerminationLatch.await(timeout, unit)) {
            return false;
        }
        long remainingTime = unit.toNanos(timeout) - (System.nanoTime() - startTime);
        return this.delegate.awaitTermination(remainingTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        this.internalTerminationLatch.await();
        this.delegate.awaitTermination();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public List<? extends SocketAddress> getListenSockets() {
        return this.delegate.getListenSockets();
    }

    @Override
    public List<ServerServiceDefinition> getServices() {
        return this.delegate.getServices();
    }

    @Override
    public List<ServerServiceDefinition> getImmutableServices() {
        return this.delegate.getImmutableServices();
    }

    @Override
    public List<ServerServiceDefinition> getMutableServices() {
        return this.delegate.getMutableServices();
    }

    private void startDelegateServer() {
        if (this.restartTimer != null && this.restartTimer.isPending()) {
            return;
        }
        if (this.isServing) {
            return;
        }
        if (this.delegate.isShutdown()) {
            this.delegate = this.delegateBuilder.build();
        }
        try {
            this.delegate.start();
            this.listener.onServing();
            this.isServing = true;
            if (!this.initialStarted) {
                this.initialStarted = true;
                this.initialStartFuture.set(null);
            }
            logger.log(Level.FINER, "Delegate server started.");
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Fail to start delegate server: {0}", e);
            if (!this.initialStarted) {
                this.initialStarted = true;
                this.initialStartFuture.set(e);
            } else {
                this.listener.onNotServing(e);
            }
            this.restartTimer = this.syncContext.schedule(new RestartTask(), RETRY_DELAY_NANOS, TimeUnit.NANOSECONDS, this.timeService);
        }
    }

    @AutoValue
    static abstract class ServerRoutingConfig {
        @VisibleForTesting
        static final ServerRoutingConfig FAILING_ROUTING_CONFIG = ServerRoutingConfig.create(ImmutableList.of(), ImmutableMap.of());

        ServerRoutingConfig() {
        }

        abstract ImmutableList<VirtualHost> virtualHosts();

        abstract ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors();

        public static ServerRoutingConfig create(ImmutableList<VirtualHost> virtualHosts, ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors) {
            Preconditions.checkNotNull(virtualHosts, "virtualHosts");
            Preconditions.checkNotNull(interceptors, "interceptors");
            return new AutoValue_XdsServerWrapper_ServerRoutingConfig(virtualHosts, interceptors);
        }
    }

    @VisibleForTesting
    final class ConfigApplyingInterceptor
    implements ServerInterceptor {
        private final ServerInterceptor noopInterceptor = new ServerInterceptor(){

            @Override
            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall(call, headers);
            }
        };

        ConfigApplyingInterceptor() {
        }

        @Override
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            ServerRoutingConfig routingConfig;
            AtomicReference<ServerRoutingConfig> routingConfigRef = call.getAttributes().get(ATTR_SERVER_ROUTING_CONFIG);
            ServerRoutingConfig serverRoutingConfig = routingConfig = routingConfigRef == null ? null : routingConfigRef.get();
            if (routingConfig == null || routingConfig == ServerRoutingConfig.FAILING_ROUTING_CONFIG) {
                String errorMsg = "Missing or broken xDS routing config: RDS config unavailable.";
                call.close(Status.UNAVAILABLE.withDescription(errorMsg), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            ImmutableList<VirtualHost> virtualHosts = routingConfig.virtualHosts();
            VirtualHost virtualHost = RoutingUtils.findVirtualHostForHostName(virtualHosts, call.getAuthority());
            if (virtualHost == null) {
                call.close(Status.UNAVAILABLE.withDescription("Could not find xDS virtual host matching RPC"), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            VirtualHost.Route selectedRoute = null;
            MethodDescriptor<ReqT, RespT> method = call.getMethodDescriptor();
            for (VirtualHost.Route route : virtualHost.routes()) {
                if (!RoutingUtils.matchRoute(route.routeMatch(), "/" + method.getFullMethodName(), headers, XdsServerWrapper.this.random)) continue;
                selectedRoute = route;
                break;
            }
            if (selectedRoute == null) {
                call.close(Status.UNAVAILABLE.withDescription("Could not find xDS route matching RPC"), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            if (selectedRoute.routeAction() != null) {
                call.close(Status.UNAVAILABLE.withDescription("Invalid xDS route action for matching route: only Route.non_forwarding_action should be allowed."), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            ServerInterceptor routeInterceptor = this.noopInterceptor;
            ImmutableMap<VirtualHost.Route, ServerInterceptor> perRouteInterceptors = routingConfig.interceptors();
            if (perRouteInterceptors != null && perRouteInterceptors.get(selectedRoute) != null) {
                routeInterceptor = (ServerInterceptor)perRouteInterceptors.get(selectedRoute);
            }
            return routeInterceptor.interceptCall(call, headers, next);
        }
    }

    private final class DiscoveryState
    implements XdsClient.ResourceWatcher<XdsListenerResource.LdsUpdate> {
        private final String resourceName;
        private final Map<String, RouteDiscoveryState> routeDiscoveryStates = new HashMap<String, RouteDiscoveryState>();
        private final Set<String> pendingRds = new HashSet<String>();
        private List<EnvoyServerProtoData.FilterChain> filterChains = new ArrayList<EnvoyServerProtoData.FilterChain>();
        @Nullable
        private EnvoyServerProtoData.FilterChain defaultFilterChain;
        private boolean stopped;
        private final Map<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>> savedRdsRoutingConfigRef = new HashMap<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>>();
        private final ServerInterceptor noopInterceptor = new ServerInterceptor(){

            @Override
            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall(call, headers);
            }
        };

        private DiscoveryState(String resourceName) {
            this.resourceName = Preconditions.checkNotNull(resourceName, "resourceName");
            XdsServerWrapper.this.xdsClient.watchXdsResource(XdsListenerResource.getInstance(), resourceName, this, XdsServerWrapper.this.syncContext);
        }

        @Override
        public void onChanged(XdsListenerResource.LdsUpdate update) {
            if (this.stopped) {
                return;
            }
            logger.log(Level.FINEST, "Received Lds update {0}", update);
            if (update.listener() == null) {
                this.onResourceDoesNotExist("Non-API");
                return;
            }
            String ldsAddress = update.listener().address();
            if (ldsAddress == null || update.listener().protocol() != SocketAddress.Protocol.TCP || !this.ipAddressesMatch(ldsAddress)) {
                this.handleConfigNotFoundOrMismatch(Status.UNKNOWN.withDescription(String.format("Listener address mismatch: expected %s, but got %s.", XdsServerWrapper.this.listenerAddress, ldsAddress)).asException());
                return;
            }
            if (!this.pendingRds.isEmpty()) {
                this.releaseSuppliersInFlight();
                this.pendingRds.clear();
            }
            this.filterChains = update.listener().filterChains();
            this.defaultFilterChain = update.listener().defaultFilterChain();
            this.updateActiveFilters();
            List<EnvoyServerProtoData.FilterChain> allFilterChains = this.filterChains;
            if (this.defaultFilterChain != null) {
                allFilterChains = new ArrayList<EnvoyServerProtoData.FilterChain>(this.filterChains);
                allFilterChains.add(this.defaultFilterChain);
            }
            HashSet<String> allRds = new HashSet<String>();
            for (EnvoyServerProtoData.FilterChain filterChain : allFilterChains) {
                HttpConnectionManager hcm = filterChain.httpConnectionManager();
                if (hcm.virtualHosts() != null) continue;
                RouteDiscoveryState rdsState = this.routeDiscoveryStates.get(hcm.rdsName());
                if (rdsState == null) {
                    rdsState = new RouteDiscoveryState(hcm.rdsName());
                    this.routeDiscoveryStates.put(hcm.rdsName(), rdsState);
                    XdsServerWrapper.this.xdsClient.watchXdsResource(XdsRouteConfigureResource.getInstance(), hcm.rdsName(), rdsState, XdsServerWrapper.this.syncContext);
                }
                if (rdsState.isPending) {
                    this.pendingRds.add(hcm.rdsName());
                }
                allRds.add(hcm.rdsName());
            }
            for (Map.Entry entry : this.routeDiscoveryStates.entrySet()) {
                if (allRds.contains(entry.getKey())) continue;
                XdsServerWrapper.this.xdsClient.cancelXdsResourceWatch(XdsRouteConfigureResource.getInstance(), (String)entry.getKey(), (XdsClient.ResourceWatcher)entry.getValue());
            }
            this.routeDiscoveryStates.keySet().retainAll(allRds);
            if (this.pendingRds.isEmpty()) {
                this.updateSelector();
            }
        }

        private boolean ipAddressesMatch(String ldsAddress) {
            HostAndPort ldsAddressHnP = HostAndPort.fromString(ldsAddress);
            HostAndPort listenerAddressHnP = HostAndPort.fromString(XdsServerWrapper.this.listenerAddress);
            if (!ldsAddressHnP.hasPort() || !listenerAddressHnP.hasPort() || ldsAddressHnP.getPort() != listenerAddressHnP.getPort()) {
                return false;
            }
            InetAddress listenerIp = InetAddresses.forString(listenerAddressHnP.getHost());
            InetAddress ldsIp = InetAddresses.forString(ldsAddressHnP.getHost());
            return listenerIp.equals(ldsIp);
        }

        @Override
        public void onResourceDoesNotExist(String resourceName) {
            if (this.stopped) {
                return;
            }
            StatusException statusException = Status.UNAVAILABLE.withDescription(String.format("Listener %s unavailable, xDS node ID: %s", resourceName, XdsServerWrapper.this.xdsClient.getBootstrapInfo().node().getId())).asException();
            this.handleConfigNotFoundOrMismatch(statusException);
        }

        @Override
        public void onError(Status error) {
            if (this.stopped) {
                return;
            }
            String description = error.getDescription() == null ? "" : error.getDescription() + " ";
            Status errorWithNodeId = error.withDescription(description + "xDS node ID: " + XdsServerWrapper.this.xdsClient.getBootstrapInfo().node().getId());
            logger.log(Level.FINE, "Error from XdsClient", errorWithNodeId);
            if (!XdsServerWrapper.this.isServing) {
                XdsServerWrapper.this.listener.onNotServing(errorWithNodeId.asException());
            }
        }

        private void shutdown() {
            this.stopped = true;
            this.cleanUpRouteDiscoveryStates();
            logger.log(Level.FINE, "Stop watching LDS resource {0}", this.resourceName);
            XdsServerWrapper.this.xdsClient.cancelXdsResourceWatch(XdsListenerResource.getInstance(), this.resourceName, this);
            this.shutdownActiveFilters();
            List<SslContextProviderSupplier> toRelease = this.getSuppliersInUse();
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector.NO_FILTER_CHAIN);
            for (SslContextProviderSupplier s : toRelease) {
                s.close();
            }
            this.releaseSuppliersInFlight();
        }

        private void updateSelector() {
            this.savedRdsRoutingConfigRef.clear();
            ImmutableMap.Builder<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>> routingConfigs = ImmutableMap.builder();
            for (EnvoyServerProtoData.FilterChain filterChain : this.filterChains) {
                HashMap chainFilters = (HashMap)XdsServerWrapper.this.activeFilters.get(filterChain.name());
                routingConfigs.put(filterChain, this.generateRoutingConfig(filterChain, chainFilters));
            }
            FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector selector = this.defaultFilterChain != null ? new FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector(routingConfigs.build(), this.defaultFilterChain.sslContextProviderSupplier(), this.generateRoutingConfig(this.defaultFilterChain, XdsServerWrapper.this.activeFiltersDefaultChain)) : new FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector(routingConfigs.build());
            List<SslContextProviderSupplier> oldSslSuppliers = this.getSuppliersInUse();
            logger.log(Level.FINEST, "Updating selector {0}", selector);
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(selector);
            for (SslContextProviderSupplier supplier : oldSslSuppliers) {
                supplier.close();
            }
            XdsServerWrapper.this.startDelegateServer();
        }

        private void updateActiveFilters() {
            HashSet removedChains = new HashSet(XdsServerWrapper.this.activeFilters.keySet());
            for (EnvoyServerProtoData.FilterChain filterChain : this.filterChains) {
                removedChains.remove(filterChain.name());
                this.updateActiveFiltersForChain(XdsServerWrapper.this.activeFilters.computeIfAbsent(filterChain.name(), k -> new HashMap()), filterChain.httpConnectionManager().httpFilterConfigs());
            }
            for (String chainToShutdown : removedChains) {
                HashMap filtersToShutdown = (HashMap)XdsServerWrapper.this.activeFilters.get(chainToShutdown);
                Preconditions.checkNotNull(filtersToShutdown, "filtersToShutdown of chain %s", (Object)chainToShutdown);
                this.updateActiveFiltersForChain(filtersToShutdown, null);
                XdsServerWrapper.this.activeFilters.remove(chainToShutdown);
            }
            ImmutableList<Filter.NamedFilterConfig> defaultChainConfigs = null;
            if (this.defaultFilterChain != null) {
                defaultChainConfigs = this.defaultFilterChain.httpConnectionManager().httpFilterConfigs();
            }
            this.updateActiveFiltersForChain(XdsServerWrapper.this.activeFiltersDefaultChain, defaultChainConfigs);
        }

        private void shutdownActiveFilters() {
            for (HashMap chainFilters : XdsServerWrapper.this.activeFilters.values()) {
                Preconditions.checkNotNull(chainFilters, "chainFilters");
                this.updateActiveFiltersForChain(chainFilters, null);
            }
            XdsServerWrapper.this.activeFilters.clear();
            this.updateActiveFiltersForChain(XdsServerWrapper.this.activeFiltersDefaultChain, null);
        }

        private void updateActiveFiltersForChain(Map<String, Filter> chainFilters, @Nullable List<Filter.NamedFilterConfig> filterConfigs) {
            if (filterConfigs == null) {
                filterConfigs = ImmutableList.of();
            }
            HashSet<String> filtersToShutdown = new HashSet<String>(chainFilters.keySet());
            for (Filter.NamedFilterConfig namedFilter : filterConfigs) {
                String typeUrl = namedFilter.filterConfig.typeUrl();
                String filterKey = namedFilter.filterStateKey();
                Filter.Provider provider = XdsServerWrapper.this.filterRegistry.get(typeUrl);
                Preconditions.checkNotNull(provider, "provider %s", (Object)typeUrl);
                Filter filter = chainFilters.computeIfAbsent(filterKey, k -> provider.newInstance(namedFilter.name));
                Preconditions.checkNotNull(filter, "filter %s", (Object)filterKey);
                filtersToShutdown.remove(filterKey);
            }
            for (String filterKey : filtersToShutdown) {
                Filter filterToShutdown = chainFilters.remove(filterKey);
                Preconditions.checkNotNull(filterToShutdown, "filterToShutdown %s", (Object)filterKey);
                filterToShutdown.close();
            }
        }

        private AtomicReference<ServerRoutingConfig> generateRoutingConfig(EnvoyServerProtoData.FilterChain filterChain, Map<String, Filter> chainFilters) {
            HttpConnectionManager hcm = filterChain.httpConnectionManager();
            ImmutableList<VirtualHost> vhosts = hcm.virtualHosts();
            if (vhosts != null) {
                ServerRoutingConfig routingConfig = ServerRoutingConfig.create(vhosts, this.generatePerRouteInterceptors(hcm.httpFilterConfigs(), vhosts, chainFilters));
                return new AtomicReference<ServerRoutingConfig>(routingConfig);
            }
            RouteDiscoveryState rds = this.routeDiscoveryStates.get(hcm.rdsName());
            Preconditions.checkNotNull(rds, "rds");
            ImmutableList savedVhosts = rds.savedVirtualHosts;
            ServerRoutingConfig routingConfig = savedVhosts != null ? ServerRoutingConfig.create(savedVhosts, this.generatePerRouteInterceptors(hcm.httpFilterConfigs(), savedVhosts, chainFilters)) : ServerRoutingConfig.FAILING_ROUTING_CONFIG;
            AtomicReference<ServerRoutingConfig> routingConfigRef = new AtomicReference<ServerRoutingConfig>(routingConfig);
            this.savedRdsRoutingConfigRef.put(filterChain, routingConfigRef);
            return routingConfigRef;
        }

        private ImmutableMap<VirtualHost.Route, ServerInterceptor> generatePerRouteInterceptors(@Nullable List<Filter.NamedFilterConfig> filterConfigs, List<VirtualHost> virtualHosts, Map<String, Filter> chainFilters) {
            XdsServerWrapper.this.syncContext.throwIfNotInThisSynchronizationContext();
            Preconditions.checkNotNull(chainFilters, "chainFilters");
            ImmutableMap.Builder<VirtualHost.Route, ServerInterceptor> perRouteInterceptors = new ImmutableMap.Builder<VirtualHost.Route, ServerInterceptor>();
            for (VirtualHost virtualHost : virtualHosts) {
                for (VirtualHost.Route route : virtualHost.routes()) {
                    if (filterConfigs == null) {
                        perRouteInterceptors.put(route, this.noopInterceptor);
                        continue;
                    }
                    ImmutableMap<String, Filter.FilterConfig> perRouteOverrides = ImmutableMap.builder().putAll(virtualHost.filterConfigOverrides()).putAll(route.filterConfigOverrides()).buildKeepingLast();
                    ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>(filterConfigs.size());
                    for (Filter.NamedFilterConfig namedFilter : filterConfigs) {
                        String name = namedFilter.name;
                        Filter.FilterConfig config = namedFilter.filterConfig;
                        Filter.FilterConfig overrideConfig = (Filter.FilterConfig)perRouteOverrides.get(name);
                        String filterKey = namedFilter.filterStateKey();
                        Filter filter = chainFilters.get(filterKey);
                        Preconditions.checkNotNull(filter, "chainFilters.get(%s)", (Object)filterKey);
                        ServerInterceptor interceptor = filter.buildServerInterceptor(config, overrideConfig);
                        if (interceptor == null) continue;
                        interceptors.add(interceptor);
                    }
                    perRouteInterceptors.put(route, this.combineInterceptors(interceptors));
                }
            }
            return perRouteInterceptors.buildOrThrow();
        }

        private ServerInterceptor combineInterceptors(final List<ServerInterceptor> interceptors) {
            if (interceptors.isEmpty()) {
                return this.noopInterceptor;
            }
            if (interceptors.size() == 1) {
                return interceptors.get(0);
            }
            return new ServerInterceptor(){

                @Override
                public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                    for (int i = interceptors.size() - 1; i >= 0; --i) {
                        next = InternalServerInterceptors.interceptCallHandlerCreate((ServerInterceptor)interceptors.get(i), next);
                    }
                    return next.startCall(call, headers);
                }
            };
        }

        private void handleConfigNotFoundOrMismatch(StatusException exception) {
            this.cleanUpRouteDiscoveryStates();
            this.shutdownActiveFilters();
            List<SslContextProviderSupplier> toRelease = this.getSuppliersInUse();
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector.NO_FILTER_CHAIN);
            for (SslContextProviderSupplier s : toRelease) {
                s.close();
            }
            if (XdsServerWrapper.this.restartTimer != null) {
                XdsServerWrapper.this.restartTimer.cancel();
            }
            if (!XdsServerWrapper.this.delegate.isShutdown()) {
                XdsServerWrapper.this.delegate.shutdown();
            }
            XdsServerWrapper.this.isServing = false;
            XdsServerWrapper.this.listener.onNotServing(exception);
        }

        private void cleanUpRouteDiscoveryStates() {
            for (RouteDiscoveryState rdsState : this.routeDiscoveryStates.values()) {
                String rdsName = rdsState.resourceName;
                logger.log(Level.FINE, "Stop watching RDS resource {0}", rdsName);
                XdsServerWrapper.this.xdsClient.cancelXdsResourceWatch(XdsRouteConfigureResource.getInstance(), rdsName, rdsState);
            }
            this.routeDiscoveryStates.clear();
            this.savedRdsRoutingConfigRef.clear();
        }

        private List<SslContextProviderSupplier> getSuppliersInUse() {
            ArrayList<SslContextProviderSupplier> toRelease = new ArrayList<SslContextProviderSupplier>();
            FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector selector = XdsServerWrapper.this.filterChainSelectorManager.getSelectorToUpdateSelector();
            if (selector != null) {
                for (EnvoyServerProtoData.FilterChain f : selector.getRoutingConfigs().keySet()) {
                    if (f.sslContextProviderSupplier() == null) continue;
                    toRelease.add(f.sslContextProviderSupplier());
                }
                SslContextProviderSupplier defaultSupplier = selector.getDefaultSslContextProviderSupplier();
                if (defaultSupplier != null) {
                    toRelease.add(defaultSupplier);
                }
            }
            return toRelease;
        }

        private void releaseSuppliersInFlight() {
            SslContextProviderSupplier supplier;
            for (EnvoyServerProtoData.FilterChain filterChain : this.filterChains) {
                supplier = filterChain.sslContextProviderSupplier();
                if (supplier == null) continue;
                supplier.close();
            }
            if (this.defaultFilterChain != null && (supplier = this.defaultFilterChain.sslContextProviderSupplier()) != null) {
                supplier.close();
            }
        }

        private final class RouteDiscoveryState
        implements XdsClient.ResourceWatcher<XdsRouteConfigureResource.RdsUpdate> {
            private final String resourceName;
            private ImmutableList<VirtualHost> savedVirtualHosts;
            private boolean isPending = true;

            private RouteDiscoveryState(String resourceName) {
                this.resourceName = Preconditions.checkNotNull(resourceName, "resourceName");
            }

            @Override
            public void onChanged(final XdsRouteConfigureResource.RdsUpdate update) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(RouteDiscoveryState.this.resourceName)) {
                            return;
                        }
                        if (RouteDiscoveryState.this.savedVirtualHosts == null && !RouteDiscoveryState.this.isPending) {
                            logger.log(Level.WARNING, "Received valid Rds {0} configuration.", RouteDiscoveryState.this.resourceName);
                        }
                        RouteDiscoveryState.this.savedVirtualHosts = ImmutableList.copyOf(update.virtualHosts);
                        RouteDiscoveryState.this.updateRdsRoutingConfig();
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(resourceName)) {
                            return;
                        }
                        logger.log(Level.WARNING, "Rds {0} unavailable", resourceName);
                        RouteDiscoveryState.this.savedVirtualHosts = null;
                        RouteDiscoveryState.this.updateRdsRoutingConfig();
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(RouteDiscoveryState.this.resourceName)) {
                            return;
                        }
                        String description = error.getDescription() == null ? "" : error.getDescription() + " ";
                        Status errorWithNodeId = error.withDescription(description + "xDS node ID: " + XdsServerWrapper.this.xdsClient.getBootstrapInfo().node().getId());
                        logger.log(Level.WARNING, "Error loading RDS resource {0} from XdsClient: {1}.", new Object[]{RouteDiscoveryState.this.resourceName, errorWithNodeId});
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            private void updateRdsRoutingConfig() {
                for (EnvoyServerProtoData.FilterChain filterChain : DiscoveryState.this.savedRdsRoutingConfigRef.keySet()) {
                    ServerRoutingConfig updatedRoutingConfig;
                    HttpConnectionManager hcm = filterChain.httpConnectionManager();
                    if (!this.resourceName.equals(hcm.rdsName())) continue;
                    if (this.savedVirtualHosts == null) {
                        updatedRoutingConfig = ServerRoutingConfig.FAILING_ROUTING_CONFIG;
                    } else {
                        HashMap chainFilters = (HashMap)XdsServerWrapper.this.activeFilters.get(filterChain.name());
                        ImmutableMap interceptors = DiscoveryState.this.generatePerRouteInterceptors(hcm.httpFilterConfigs(), this.savedVirtualHosts, chainFilters);
                        updatedRoutingConfig = ServerRoutingConfig.create(this.savedVirtualHosts, interceptors);
                    }
                    logger.log(Level.FINEST, "Updating filter chain {0} rds routing config: {1}", new Object[]{filterChain.name(), updatedRoutingConfig});
                    ((AtomicReference)DiscoveryState.this.savedRdsRoutingConfigRef.get(filterChain)).set(updatedRoutingConfig);
                }
            }

            private void maybeUpdateSelector() {
                boolean isLastPending;
                this.isPending = false;
                boolean bl = isLastPending = DiscoveryState.this.pendingRds.remove(this.resourceName) && DiscoveryState.this.pendingRds.isEmpty();
                if (isLastPending) {
                    DiscoveryState.this.updateSelector();
                }
            }
        }
    }

    private final class RestartTask
    implements Runnable {
        private RestartTask() {
        }

        @Override
        public void run() {
            XdsServerWrapper.this.startDelegateServer();
        }
    }
}

