/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.httpjson.HttpJsonClientInterceptor;
import com.google.api.gax.httpjson.HttpJsonHeaderInterceptor;
import com.google.api.gax.httpjson.HttpJsonInterceptorProvider;
import com.google.api.gax.httpjson.HttpJsonLoggingInterceptor;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.ManagedHttpJsonChannel;
import com.google.api.gax.httpjson.ManagedHttpJsonInterceptorChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.mtls.CertificateBasedAccess;
import com.google.auth.Credentials;
import com.google.auth.mtls.CertificateSourceUnavailableException;
import com.google.auth.mtls.DefaultMtlsProviderFactory;
import com.google.auth.mtls.MtlsProvider;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@InternalExtensionOnly
public final class InstantiatingHttpJsonChannelProvider
implements TransportChannelProvider {
    @VisibleForTesting
    static final Logger LOG = Logger.getLogger(InstantiatingHttpJsonChannelProvider.class.getName());
    private final Executor executor;
    private final HeaderProvider headerProvider;
    private final HttpJsonInterceptorProvider interceptorProvider;
    private final String endpoint;
    private final HttpTransport httpTransport;
    @Nullable
    private final MtlsProvider mtlsProvider;
    private final CertificateBasedAccess certificateBasedAccess;

    private InstantiatingHttpJsonChannelProvider(Executor executor, HeaderProvider headerProvider, HttpJsonInterceptorProvider interceptorProvider, String endpoint, HttpTransport httpTransport, MtlsProvider mtlsProvider, CertificateBasedAccess certificateBasedAccess) {
        this.executor = executor;
        this.headerProvider = headerProvider;
        this.interceptorProvider = interceptorProvider;
        this.endpoint = endpoint;
        this.httpTransport = httpTransport;
        this.mtlsProvider = mtlsProvider;
        this.certificateBasedAccess = certificateBasedAccess;
    }

    @Override
    @Deprecated
    public boolean needsExecutor() {
        return this.executor == null;
    }

    @Override
    @Deprecated
    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.withExecutor((Executor)executor);
    }

    @Override
    public TransportChannelProvider withExecutor(Executor executor) {
        return this.toBuilder().setExecutor(executor).build();
    }

    @Override
    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    @Override
    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider(FixedHeaderProvider.create(headers)).build();
    }

    @Override
    public boolean needsEndpoint() {
        return this.endpoint == null;
    }

    @Override
    public TransportChannelProvider withEndpoint(String endpoint) {
        return this.toBuilder().setEndpoint(endpoint).build();
    }

    @Override
    @Deprecated
    public boolean acceptsPoolSize() {
        return false;
    }

    @Override
    @Deprecated
    public TransportChannelProvider withPoolSize(int size) {
        throw new UnsupportedOperationException("InstantiatingHttpJsonChannelProvider doesn't allow pool size customization");
    }

    @Override
    public String getTransportName() {
        return HttpJsonTransportChannel.getHttpJsonTransportName();
    }

    @Override
    public HttpJsonTransportChannel getTransportChannel() throws IOException {
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        try {
            return this.createChannel();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean needsCredentials() {
        return false;
    }

    @Override
    public TransportChannelProvider withCredentials(Credentials credentials) {
        throw new UnsupportedOperationException("InstantiatingHttpJsonChannelProvider doesn't need credentials");
    }

    HttpTransport createHttpTransport() throws IOException, GeneralSecurityException {
        KeyStore mtlsKeyStore;
        if (this.mtlsProvider == null) {
            return null;
        }
        if (this.certificateBasedAccess.useMtlsClientCertificate() && (mtlsKeyStore = this.mtlsProvider.getKeyStore()) != null) {
            return new NetHttpTransport.Builder().trustCertificates(null, mtlsKeyStore, "").build();
        }
        return null;
    }

    private HttpJsonTransportChannel createChannel() throws IOException, GeneralSecurityException {
        HttpTransport httpTransportToUse = this.httpTransport;
        if (httpTransportToUse == null) {
            httpTransportToUse = this.createHttpTransport();
        }
        ManagedHttpJsonChannel channel = ManagedHttpJsonChannel.newBuilder().setEndpoint(this.endpoint).setExecutor(this.executor).setHttpTransport(httpTransportToUse).build();
        HttpJsonHeaderInterceptor headerInterceptor = new HttpJsonHeaderInterceptor(this.headerProvider.getHeaders());
        channel = new ManagedHttpJsonInterceptorChannel(channel, new HttpJsonLoggingInterceptor());
        channel = new ManagedHttpJsonInterceptorChannel(channel, headerInterceptor);
        if (this.interceptorProvider != null && this.interceptorProvider.getInterceptors() != null) {
            for (HttpJsonClientInterceptor interceptor : this.interceptorProvider.getInterceptors()) {
                channel = new ManagedHttpJsonInterceptorChannel(channel, interceptor);
            }
        }
        return HttpJsonTransportChannel.newBuilder().setManagedChannel(channel).build();
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Executor executor;
        private HeaderProvider headerProvider;
        private HttpJsonInterceptorProvider interceptorProvider;
        private String endpoint;
        private HttpTransport httpTransport;
        private MtlsProvider mtlsProvider;
        private CertificateBasedAccess certificateBasedAccess;

        private Builder() {
        }

        private Builder(InstantiatingHttpJsonChannelProvider provider) {
            this.executor = provider.executor;
            this.headerProvider = provider.headerProvider;
            this.endpoint = provider.endpoint;
            this.httpTransport = provider.httpTransport;
            this.mtlsProvider = provider.mtlsProvider;
            this.certificateBasedAccess = provider.certificateBasedAccess;
            this.interceptorProvider = provider.interceptorProvider;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Deprecated
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            return this.setExecutor(executorProvider.getExecutor());
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setInterceptorProvider(HttpJsonInterceptorProvider interceptorProvider) {
            this.interceptorProvider = interceptorProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        @VisibleForTesting
        Builder setMtlsProvider(MtlsProvider mtlsProvider) {
            this.mtlsProvider = mtlsProvider;
            return this;
        }

        @VisibleForTesting
        Builder setCertificateBasedAccess(CertificateBasedAccess certificateBasedAccess) {
            this.certificateBasedAccess = certificateBasedAccess;
            return this;
        }

        public InstantiatingHttpJsonChannelProvider build() {
            if (this.certificateBasedAccess == null) {
                this.certificateBasedAccess = CertificateBasedAccess.createWithSystemEnv();
            }
            if (this.certificateBasedAccess.useMtlsClientCertificate() && this.mtlsProvider == null) {
                try {
                    this.mtlsProvider = DefaultMtlsProviderFactory.create();
                }
                catch (CertificateSourceUnavailableException certificateSourceUnavailableException) {
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "DefaultMtlsProviderFactory encountered unexpected IOException: " + e.getMessage());
                }
            }
            return new InstantiatingHttpJsonChannelProvider(this.executor, this.headerProvider, this.interceptorProvider, this.endpoint, this.httpTransport, this.mtlsProvider, this.certificateBasedAccess);
        }
    }
}

