/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_LambdaExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ReturnExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@AutoValue
public abstract class LambdaExpr
implements Expr {
    @Override
    public TypeNode type() {
        return this.returnExpr().expr().type();
    }

    public abstract ImmutableList<VariableExpr> arguments();

    public abstract ReturnExpr returnExpr();

    public abstract ImmutableList<Statement> body();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_LambdaExpr.Builder().setArguments(Collections.emptyList()).setBody(Collections.emptyList());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public Builder setArguments(VariableExpr ... arguments) {
            return this.setArguments(Arrays.asList(arguments));
        }

        public abstract Builder setArguments(List<VariableExpr> var1);

        public abstract Builder setBody(List<Statement> var1);

        public abstract Builder setReturnExpr(ReturnExpr var1);

        public Builder setReturnExpr(Expr expr) {
            return this.setReturnExpr(ReturnExpr.builder().setExpr(expr).build());
        }

        public abstract LambdaExpr autoBuild();

        public LambdaExpr build() {
            LambdaExpr lambdaExpr = this.autoBuild();
            lambdaExpr.arguments().stream().forEach(varExpr -> Preconditions.checkState(varExpr.isDecl(), String.format("Argument %s must be a variable declaration", varExpr.variable().identifier())));
            lambdaExpr.arguments().stream().forEach(varExpr -> Preconditions.checkState(varExpr.scope().equals(ScopeNode.LOCAL) && !varExpr.isStatic() && !varExpr.isFinal() && !varExpr.isVolatile(), String.format("Argument %s must have local scope, and cannot have static, final, or volatile modifiers", varExpr.variable().identifier())));
            List allArgNames = lambdaExpr.arguments().stream().map(v -> v.variable().identifier().name()).collect(Collectors.toList());
            Set duplicateArgNames = allArgNames.stream().filter(n -> Collections.frequency(allArgNames, n) > 1).collect(Collectors.toSet());
            Preconditions.checkState(duplicateArgNames.isEmpty(), String.format("Lambda arguments cannot have duplicate names: %s", duplicateArgNames.toString()));
            return lambdaExpr;
        }
    }
}

