/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.mtls;

import com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.api.gax.rpc.testing.FakeMtlsProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMtlsTransportChannelTest {
    protected abstract Object getMtlsObjectFromTransportChannel(MtlsProvider var1) throws IOException, GeneralSecurityException;

    @Test
    void testNotUseClientCertificate() throws IOException, GeneralSecurityException {
        FakeMtlsProvider provider = new FakeMtlsProvider(false, MtlsProvider.MtlsEndpointUsagePolicy.AUTO, null, "", false);
        Assertions.assertNull((Object)this.getMtlsObjectFromTransportChannel(provider));
    }

    @Test
    void testUseClientCertificate() throws IOException, GeneralSecurityException {
        FakeMtlsProvider provider = new FakeMtlsProvider(true, MtlsProvider.MtlsEndpointUsagePolicy.AUTO, FakeMtlsProvider.createTestMtlsKeyStore(), "", false);
        Assertions.assertNotNull((Object)this.getMtlsObjectFromTransportChannel(provider));
    }

    @Test
    void testNoClientCertificate() throws IOException, GeneralSecurityException {
        FakeMtlsProvider provider = new FakeMtlsProvider(true, MtlsProvider.MtlsEndpointUsagePolicy.AUTO, null, "", false);
        Assertions.assertNull((Object)this.getMtlsObjectFromTransportChannel(provider));
    }

    @Test
    void testGetKeyStoreThrows() throws GeneralSecurityException {
        FakeMtlsProvider provider = new FakeMtlsProvider(true, MtlsProvider.MtlsEndpointUsagePolicy.AUTO, null, "", true);
        IOException actual = (IOException)Assertions.assertThrows(IOException.class, () -> this.getMtlsObjectFromTransportChannel(provider));
        Assertions.assertTrue((boolean)actual.getMessage().contains("getKeyStore throws exception"));
    }
}

