/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.gapic.model.AutoValue_HttpBindings;
import com.google.api.generator.gapic.model.AutoValue_HttpBindings_HttpBinding;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class HttpBindings {
    public abstract HttpVerb httpVerb();

    public abstract String pattern();

    public abstract List<String> additionalPatterns();

    public abstract Set<HttpBinding> pathParameters();

    public abstract Set<HttpBinding> queryParameters();

    public abstract Set<HttpBinding> bodyParameters();

    public abstract boolean isAsteriskBody();

    public static Builder builder() {
        return new AutoValue_HttpBindings.Builder().setPathParameters(ImmutableSet.of()).setQueryParameters(ImmutableSet.of()).setBodyParameters(ImmutableSet.of());
    }

    public String lowerCamelPattern() {
        return HttpBindings.lowerCamelPattern(this.pattern(), this.pathParameters());
    }

    public List<String> lowerCamelAdditionalPatterns() {
        return this.additionalPatterns().stream().map(a -> HttpBindings.lowerCamelPattern(a, this.pathParameters())).collect(Collectors.toList());
    }

    private static String lowerCamelPattern(String originalPattern, Set<HttpBinding> pathParameters) {
        String lowerCamelPattern = originalPattern;
        for (HttpBinding pathParam : pathParameters) {
            lowerCamelPattern = lowerCamelPattern.replaceAll("\\{" + pathParam.name(), "{" + JavaStyle.toLowerCamelCase(pathParam.name()));
        }
        return lowerCamelPattern;
    }

    public Map<String, String> getPathParametersValuePatterns() {
        LinkedHashMap<String, String> valuePatterns = new LinkedHashMap<String, String>();
        for (HttpBinding pathParameter : this.pathParameters()) {
            valuePatterns.put(pathParameter.lowerCamelName(), pathParameter.valuePattern());
        }
        return valuePatterns;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setHttpVerb(HttpVerb var1);

        public abstract Builder setPattern(String var1);

        public abstract Builder setAdditionalPatterns(List<String> var1);

        abstract String pattern();

        public abstract Builder setPathParameters(Set<HttpBinding> var1);

        public abstract Builder setQueryParameters(Set<HttpBinding> var1);

        public abstract Builder setBodyParameters(Set<HttpBinding> var1);

        public abstract Builder setIsAsteriskBody(boolean var1);

        public abstract HttpBindings autoBuild();

        public HttpBindings build() {
            if ("".equals(this.pattern())) {
                throw new IllegalArgumentException("pattern cannot be empty");
            }
            return this.autoBuild();
        }
    }

    @AutoValue
    public static abstract class HttpBinding
    implements Comparable<HttpBinding> {
        public abstract String name();

        abstract String lowerCamelName();

        @Nullable
        public abstract Field field();

        public boolean isOptional() {
            return this.field() != null && this.field().isProto3Optional();
        }

        public boolean isRepeated() {
            return this.field() != null && this.field().isRepeated();
        }

        public boolean isEnum() {
            return this.field() != null && this.field().isEnum();
        }

        @Nullable
        public abstract String valuePattern();

        public static Builder builder() {
            return new AutoValue_HttpBindings_HttpBinding.Builder();
        }

        @Override
        public int compareTo(HttpBinding o) {
            int res = this.name().compareTo(o.name());
            return res == 0 ? Boolean.compare(this.isOptional(), o.isOptional()) : res;
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            public abstract Builder setField(Field var1);

            abstract Builder setLowerCamelName(String var1);

            public abstract Builder setValuePattern(String var1);

            abstract String name();

            abstract HttpBinding autoBuild();

            public HttpBinding build() {
                this.setLowerCamelName(JavaStyle.toLowerCamelCase(this.name()));
                return this.autoBuild();
            }
        }
    }

    public static enum HttpVerb {
        GET,
        PUT,
        POST,
        DELETE,
        PATCH;

    }
}

