/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.auth.CredentialTypeForMetrics;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialFormatException;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IamUtils;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.MetricsUtils;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ImpersonatedCredentials
extends GoogleCredentials
implements ServiceAccountSigner,
IdTokenProvider {
    static final String IMPERSONATED_CREDENTIALS_FILE_TYPE = "impersonated_service_account";
    private static final long serialVersionUID = -2133257318957488431L;
    private static final String RFC3339 = "yyyy-MM-dd'T'HH:mm:ssX";
    private static final int TWELVE_HOURS_IN_SECONDS = 43200;
    private static final int DEFAULT_LIFETIME_IN_SECONDS = 3600;
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private GoogleCredentials sourceCredentials;
    private String targetPrincipal;
    private List<String> delegates;
    private List<String> scopes;
    private int lifetime;
    private String iamEndpointOverride;
    private final String transportFactoryClassName;
    private transient HttpTransportFactory transportFactory;
    private transient Calendar calendar;

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime, HttpTransportFactory transportFactory) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).setHttpTransportFactory(transportFactory).build();
    }

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime, HttpTransportFactory transportFactory, String quotaProjectId) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).setHttpTransportFactory(transportFactory).setQuotaProjectId(quotaProjectId).build();
    }

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime, HttpTransportFactory transportFactory, String quotaProjectId, String iamEndpointOverride) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).setHttpTransportFactory(transportFactory).setQuotaProjectId(quotaProjectId).setIamEndpointOverride(iamEndpointOverride).build();
    }

    public static ImpersonatedCredentials create(GoogleCredentials sourceCredentials, String targetPrincipal, List<String> delegates, List<String> scopes, int lifetime) {
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(scopes).setLifetime(lifetime).build();
    }

    static String extractTargetPrincipal(String serviceAccountImpersonationUrl) {
        int startIndex = serviceAccountImpersonationUrl.lastIndexOf(47);
        int endIndex = serviceAccountImpersonationUrl.indexOf(":generateAccessToken");
        if (startIndex != -1 && endIndex != -1 && startIndex < endIndex) {
            return serviceAccountImpersonationUrl.substring(startIndex + 1, endIndex);
        }
        throw new IllegalArgumentException("Unable to determine target principal from service account impersonation URL.");
    }

    @Override
    public String getAccount() {
        return this.targetPrincipal;
    }

    @VisibleForTesting
    String getIamEndpointOverride() {
        return this.iamEndpointOverride;
    }

    @VisibleForTesting
    List<String> getDelegates() {
        return this.delegates;
    }

    @VisibleForTesting
    List<String> getScopes() {
        return this.scopes;
    }

    public GoogleCredentials getSourceCredentials() {
        return this.sourceCredentials;
    }

    int getLifetime() {
        return this.lifetime;
    }

    public void setTransportFactory(HttpTransportFactory httpTransportFactory) {
        this.transportFactory = httpTransportFactory;
    }

    @Override
    public byte[] sign(byte[] toSign) {
        try {
            return IamUtils.sign(this.getAccount(), this.sourceCredentials, this.getUniverseDomain(), this.transportFactory.create(), toSign, ImmutableMap.of("delegates", this.delegates));
        }
        catch (IOException ex) {
            throw new ServiceAccountSigner.SigningException("Failed to sign: Error obtaining universe domain", ex);
        }
    }

    static ImpersonatedCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) throws IOException {
        GoogleCredentials sourceCredentials;
        String targetPrincipal;
        String quotaProjectId;
        String sourceCredentialsType;
        Map sourceCredentialsJson;
        String serviceAccountImpersonationUrl;
        Preconditions.checkNotNull(json);
        Preconditions.checkNotNull(transportFactory);
        List delegates = null;
        try {
            serviceAccountImpersonationUrl = (String)json.get("service_account_impersonation_url");
            if (json.containsKey("delegates")) {
                delegates = (List)json.get("delegates");
            }
            sourceCredentialsJson = (Map)json.get("source_credentials");
            sourceCredentialsType = (String)sourceCredentialsJson.get("type");
            quotaProjectId = (String)json.get("quota_project_id");
            targetPrincipal = ImpersonatedCredentials.extractTargetPrincipal(serviceAccountImpersonationUrl);
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            throw new CredentialFormatException("An invalid input stream was provided.", e);
        }
        if ("authorized_user".equals(sourceCredentialsType)) {
            sourceCredentials = UserCredentials.fromJson(sourceCredentialsJson, transportFactory);
        } else if ("service_account".equals(sourceCredentialsType)) {
            sourceCredentials = ServiceAccountCredentials.fromJson(sourceCredentialsJson, transportFactory);
        } else {
            throw new IOException(String.format("A credential of type %s is not supported as source credential for impersonation.", sourceCredentialsType));
        }
        return ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal(targetPrincipal).setDelegates(delegates).setScopes(new ArrayList<String>()).setLifetime(3600).setHttpTransportFactory(transportFactory).setQuotaProjectId(quotaProjectId).setIamEndpointOverride(serviceAccountImpersonationUrl).build();
    }

    @Override
    public boolean createScopedRequired() {
        return this.scopes == null || this.scopes.isEmpty();
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> scopes) {
        return this.toBuilder().setScopes(new ArrayList<String>(scopes)).setAccessToken(null).build();
    }

    @Override
    public CredentialTypeForMetrics getMetricsCredentialType() {
        return CredentialTypeForMetrics.IMPERSONATED_CREDENTIALS;
    }

    public ImpersonatedCredentials createWithCustomCalendar(Calendar calendar) {
        return this.toBuilder().setScopes(this.scopes).setLifetime(this.lifetime).setDelegates(this.delegates).setHttpTransportFactory(this.transportFactory).setQuotaProjectId(this.quotaProjectId).setIamEndpointOverride(this.iamEndpointOverride).setCalendar(calendar).build();
    }

    private ImpersonatedCredentials(Builder builder) throws IOException {
        super(builder);
        this.sourceCredentials = builder.getSourceCredentials();
        this.targetPrincipal = builder.getTargetPrincipal();
        this.delegates = builder.getDelegates();
        this.scopes = builder.getScopes();
        this.lifetime = builder.getLifetime();
        this.transportFactory = MoreObjects.firstNonNull(builder.getHttpTransportFactory(), ImpersonatedCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.iamEndpointOverride = builder.iamEndpointOverride;
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        this.calendar = builder.getCalendar();
        if (this.delegates == null) {
            this.delegates = new ArrayList<String>();
        }
        if (this.scopes == null) {
            throw new IllegalStateException("Scopes cannot be null");
        }
        if (this.lifetime > 43200) {
            throw new IllegalStateException("lifetime must be less than or equal to 43200");
        }
        if (this.isExplicitUniverseDomain() && !this.sourceCredentials.getUniverseDomain().equals(builder.getUniverseDomain())) {
            throw new IllegalStateException(String.format("Universe domain %s in source credentials does not match %s universe domain set for impersonated credentials.", this.sourceCredentials.getUniverseDomain(), builder.getUniverseDomain()));
        }
    }

    @Override
    public String getUniverseDomain() throws IOException {
        return this.sourceCredentials.getUniverseDomain();
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        if (this.sourceCredentials.getAccessToken() == null) {
            this.sourceCredentials = this.sourceCredentials.createScoped(Arrays.asList(CLOUD_PLATFORM_SCOPE));
        }
        if (!(this.sourceCredentials instanceof ServiceAccountCredentials) || this.isDefaultUniverseDomain() && ((ServiceAccountCredentials)this.sourceCredentials).shouldUseAssertionFlowForGdu()) {
            try {
                this.sourceCredentials.refreshIfExpired();
            }
            catch (IOException e) {
                throw new IOException("Unable to refresh sourceCredentials", e);
            }
        }
        HttpTransport httpTransport = this.transportFactory.create();
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter(this.sourceCredentials);
        HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
        String endpointUrl = this.iamEndpointOverride != null ? this.iamEndpointOverride : String.format("https://iamcredentials.%s/v1/projects/-/serviceAccounts/%s:generateAccessToken", this.getUniverseDomain(), this.targetPrincipal);
        GenericUrl url = new GenericUrl(endpointUrl);
        ImmutableMap<String, String> body = ImmutableMap.of("delegates", this.delegates, "scope", this.scopes, "lifetime", this.lifetime + "s");
        JsonHttpContent requestContent = new JsonHttpContent(parser.getJsonFactory(), body);
        HttpRequest request = requestFactory.buildPostRequest(url, requestContent);
        adapter.initialize(request);
        request.setParser(parser);
        MetricsUtils.setMetricsHeader(request, MetricsUtils.getGoogleCredentialsMetricsHeader(MetricsUtils.RequestType.ACCESS_TOKEN_REQUEST, this.getMetricsCredentialType()));
        HttpResponse response = null;
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw new IOException("Error requesting access token", e);
        }
        GenericData responseData = response.parseAs(GenericData.class);
        response.disconnect();
        String accessToken = OAuth2Utils.validateString(responseData, "accessToken", "Expected to find an accessToken");
        String expireTime = OAuth2Utils.validateString(responseData, "expireTime", "Expected to find an expireTime");
        SimpleDateFormat format = new SimpleDateFormat(RFC3339);
        format.setCalendar(this.calendar);
        try {
            Date date = format.parse(expireTime);
            return new AccessToken(accessToken, date);
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing expireTime: " + pe.getMessage());
        }
    }

    @Override
    public IdToken idTokenWithAudience(String targetAudience, List<IdTokenProvider.Option> options) throws IOException {
        boolean includeEmail = options != null && options.contains((Object)IdTokenProvider.Option.INCLUDE_EMAIL);
        return IamUtils.getIdToken(this.getAccount(), this.sourceCredentials, this.transportFactory.create(), targetAudience, includeEmail, ImmutableMap.of("delegates", this.delegates), this.getMetricsCredentialType(), this.getUniverseDomain());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sourceCredentials, this.targetPrincipal, this.delegates, this.scopes, this.lifetime, this.quotaProjectId, this.iamEndpointOverride);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("sourceCredentials", this.sourceCredentials).add("targetPrincipal", this.targetPrincipal).add("delegates", this.delegates).add("scopes", this.scopes).add("lifetime", this.lifetime).add("transportFactoryClassName", this.transportFactoryClassName).add("quotaProjectId", this.quotaProjectId).add("iamEndpointOverride", this.iamEndpointOverride).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ImpersonatedCredentials)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ImpersonatedCredentials other = (ImpersonatedCredentials)obj;
        return Objects.equals(this.sourceCredentials, other.sourceCredentials) && Objects.equals(this.targetPrincipal, other.targetPrincipal) && Objects.equals(this.delegates, other.delegates) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.lifetime, other.lifetime) && Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName) && Objects.equals(this.quotaProjectId, other.quotaProjectId) && Objects.equals(this.iamEndpointOverride, other.iamEndpointOverride);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)ImpersonatedCredentials.newInstance(this.transportFactoryClassName);
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private GoogleCredentials sourceCredentials;
        private String targetPrincipal;
        private List<String> delegates;
        private List<String> scopes;
        private int lifetime = 3600;
        private HttpTransportFactory transportFactory;
        private String iamEndpointOverride;
        private Calendar calendar = Calendar.getInstance();

        protected Builder() {
        }

        @Deprecated
        protected Builder(GoogleCredentials sourceCredentials, String targetPrincipal) {
            this.sourceCredentials = sourceCredentials;
            this.targetPrincipal = targetPrincipal;
        }

        protected Builder(ImpersonatedCredentials credentials) {
            super(credentials);
            this.sourceCredentials = credentials.sourceCredentials;
            this.targetPrincipal = credentials.targetPrincipal;
            this.delegates = credentials.delegates;
            this.scopes = credentials.scopes;
            this.lifetime = credentials.lifetime;
            this.transportFactory = credentials.transportFactory;
            this.iamEndpointOverride = credentials.iamEndpointOverride;
        }

        @CanIgnoreReturnValue
        public Builder setSourceCredentials(GoogleCredentials sourceCredentials) {
            this.sourceCredentials = sourceCredentials;
            return this;
        }

        public GoogleCredentials getSourceCredentials() {
            return this.sourceCredentials;
        }

        @CanIgnoreReturnValue
        public Builder setTargetPrincipal(String targetPrincipal) {
            this.targetPrincipal = targetPrincipal;
            return this;
        }

        public String getTargetPrincipal() {
            return this.targetPrincipal;
        }

        @CanIgnoreReturnValue
        public Builder setDelegates(List<String> delegates) {
            this.delegates = delegates;
            return this;
        }

        public List<String> getDelegates() {
            return this.delegates;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        @CanIgnoreReturnValue
        public Builder setLifetime(int lifetime) {
            this.lifetime = lifetime == 0 ? 3600 : lifetime;
            return this;
        }

        public int getLifetime() {
            return this.lifetime;
        }

        @CanIgnoreReturnValue
        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIamEndpointOverride(String iamEndpointOverride) {
            this.iamEndpointOverride = iamEndpointOverride;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCalendar(Calendar calendar) {
            this.calendar = calendar;
            return this;
        }

        public Calendar getCalendar() {
            return this.calendar;
        }

        @Override
        public ImpersonatedCredentials build() {
            try {
                return new ImpersonatedCredentials(this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

