/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.GenericData;
import com.google.auth.CredentialTypeForMetrics;
import com.google.auth.Credentials;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.MetricsUtils;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class IamUtils {
    static final String IAM_ID_TOKEN_ENDPOINT_FORMAT = "https://iamcredentials.%s/v1/projects/-/serviceAccounts/%s:generateIdToken";
    static final String IAM_ACCESS_TOKEN_ENDPOINT_FORMAT = "https://iamcredentials.%s/v1/projects/-/serviceAccounts/%s:generateAccessToken";
    static final String IAM_SIGN_BLOB_ENDPOINT_FORMAT = "https://iamcredentials.%s/v1/projects/-/serviceAccounts/%s:signBlob";
    private static final String PARSE_ERROR_MESSAGE = "Error parsing error message response. ";
    private static final String PARSE_ERROR_SIGNATURE = "Error parsing signature response. ";
    static final Set<Integer> IAM_RETRYABLE_STATUS_CODES = new HashSet<Integer>(Arrays.asList(500, 502, 503, 504));

    IamUtils() {
    }

    static byte[] sign(String serviceAccountEmail, Credentials credentials, String universeDomain, HttpTransport transport, byte[] toSign, Map<String, ?> additionalFields) {
        String signature;
        BaseEncoding base64 = BaseEncoding.base64();
        HttpRequestFactory factory = transport.createRequestFactory(new HttpCredentialsAdapter(credentials));
        try {
            signature = IamUtils.getSignature(serviceAccountEmail, universeDomain, base64.encode(toSign), additionalFields, factory);
        }
        catch (IOException ex) {
            throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", ex);
        }
        return base64.decode(signature);
    }

    private static String getSignature(String serviceAccountEmail, String universeDomain, String bytes, Map<String, ?> additionalFields, HttpRequestFactory factory) throws IOException {
        String signBlobUrl = String.format(IAM_SIGN_BLOB_ENDPOINT_FORMAT, universeDomain, serviceAccountEmail);
        GenericUrl genericUrl = new GenericUrl(signBlobUrl);
        GenericData signRequest = new GenericData();
        signRequest.set("payload", bytes);
        for (Map.Entry<String, ?> entry : additionalFields.entrySet()) {
            signRequest.set(entry.getKey(), entry.getValue());
        }
        JsonHttpContent signContent = new JsonHttpContent(OAuth2Utils.JSON_FACTORY, signRequest);
        HttpRequest request = factory.buildPostRequest(genericUrl, signContent);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser(parser);
        request.setThrowExceptionOnExecuteError(false);
        request.setNumberOfRetries(3);
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setRandomizationFactor(0.1).setMultiplier(2.0).build();
        request.setUnsuccessfulResponseHandler(new HttpBackOffUnsuccessfulResponseHandler(backoff).setBackOffRequired(response -> IAM_RETRYABLE_STATUS_CODES.contains(response.getStatusCode())));
        request.setIOExceptionHandler(new HttpBackOffIOExceptionHandler(backoff));
        HttpResponse response2 = request.execute();
        int statusCode = response2.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            GenericData responseError = response2.parseAs(GenericData.class);
            Map<String, Object> error = OAuth2Utils.validateMap(responseError, "error", PARSE_ERROR_MESSAGE);
            String errorMessage = OAuth2Utils.validateString(error, "message", PARSE_ERROR_MESSAGE);
            throw new IOException(String.format("Error code %s trying to sign provided bytes: %s", statusCode, errorMessage));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to sign provided bytes: %s", statusCode, response2.parseAsString()));
        }
        InputStream content = response2.getContent();
        if (content == null) {
            throw new IOException("Empty content from sign blob server request.");
        }
        GenericData responseData = response2.parseAs(GenericData.class);
        return OAuth2Utils.validateString(responseData, "signedBlob", PARSE_ERROR_SIGNATURE);
    }

    static IdToken getIdToken(String serviceAccountEmail, Credentials credentials, HttpTransport transport, String targetAudience, boolean includeEmail, Map<String, ?> additionalFields, CredentialTypeForMetrics credentialTypeForMetrics, String universeDomain) throws IOException {
        String idTokenUrl = String.format(IAM_ID_TOKEN_ENDPOINT_FORMAT, universeDomain, serviceAccountEmail);
        GenericUrl genericUrl = new GenericUrl(idTokenUrl);
        GenericData idTokenRequest = new GenericData();
        idTokenRequest.set("audience", targetAudience);
        idTokenRequest.set("includeEmail", includeEmail);
        for (Map.Entry<String, ?> entry : additionalFields.entrySet()) {
            idTokenRequest.set(entry.getKey(), entry.getValue());
        }
        JsonHttpContent idTokenContent = new JsonHttpContent(OAuth2Utils.JSON_FACTORY, idTokenRequest);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter(credentials);
        HttpRequest request = transport.createRequestFactory(adapter).buildPostRequest(genericUrl, idTokenContent);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser(parser);
        request.setThrowExceptionOnExecuteError(false);
        MetricsUtils.setMetricsHeader(request, MetricsUtils.getGoogleCredentialsMetricsHeader(MetricsUtils.RequestType.ID_TOKEN_REQUEST, credentialTypeForMetrics));
        HttpResponse response = request.execute();
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            GenericData responseError = response.parseAs(GenericData.class);
            Map<String, Object> error = OAuth2Utils.validateMap(responseError, "error", PARSE_ERROR_MESSAGE);
            String errorMessage = OAuth2Utils.validateString(error, "message", PARSE_ERROR_MESSAGE);
            throw new IOException(String.format("Error code %s trying to getIDToken: %s", statusCode, errorMessage));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to getIDToken: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from generateIDToken server request.");
        }
        GenericJson responseData = response.parseAs(GenericJson.class);
        String rawToken = OAuth2Utils.validateString(responseData, "token", PARSE_ERROR_MESSAGE);
        return IdToken.create(rawToken);
    }
}

