/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.OperationResponse;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_Message
extends Message {
    private final String name;
    private final String fullProtoName;
    private final ImmutableList<Field> fields;
    private final ImmutableMap<String, Integer> enumValues;
    private final TypeNode type;
    private final ImmutableMap<String, Field> fieldMap;
    @Nullable
    private final OperationResponse operationResponse;
    private final Map<String, String> operationRequestFields;
    private final BiMap<String, String> operationResponseFields;
    @Nullable
    private final ResourceName resource;
    private final ImmutableList<String> outerNestedTypes;
    private final ImmutableList<String> nestedEnums;

    private AutoValue_Message(String name, String fullProtoName, ImmutableList<Field> fields, ImmutableMap<String, Integer> enumValues, TypeNode type, ImmutableMap<String, Field> fieldMap, @Nullable OperationResponse operationResponse, Map<String, String> operationRequestFields, BiMap<String, String> operationResponseFields, @Nullable ResourceName resource, ImmutableList<String> outerNestedTypes, ImmutableList<String> nestedEnums) {
        this.name = name;
        this.fullProtoName = fullProtoName;
        this.fields = fields;
        this.enumValues = enumValues;
        this.type = type;
        this.fieldMap = fieldMap;
        this.operationResponse = operationResponse;
        this.operationRequestFields = operationRequestFields;
        this.operationResponseFields = operationResponseFields;
        this.resource = resource;
        this.outerNestedTypes = outerNestedTypes;
        this.nestedEnums = nestedEnums;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String fullProtoName() {
        return this.fullProtoName;
    }

    @Override
    public ImmutableList<Field> fields() {
        return this.fields;
    }

    @Override
    public ImmutableMap<String, Integer> enumValues() {
        return this.enumValues;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public ImmutableMap<String, Field> fieldMap() {
        return this.fieldMap;
    }

    @Override
    @Nullable
    public OperationResponse operationResponse() {
        return this.operationResponse;
    }

    @Override
    public Map<String, String> operationRequestFields() {
        return this.operationRequestFields;
    }

    @Override
    public BiMap<String, String> operationResponseFields() {
        return this.operationResponseFields;
    }

    @Override
    @Nullable
    public ResourceName resource() {
        return this.resource;
    }

    @Override
    public ImmutableList<String> outerNestedTypes() {
        return this.outerNestedTypes;
    }

    @Override
    public ImmutableList<String> nestedEnums() {
        return this.nestedEnums;
    }

    public String toString() {
        return "Message{name=" + this.name + ", fullProtoName=" + this.fullProtoName + ", fields=" + this.fields + ", enumValues=" + this.enumValues + ", type=" + this.type + ", fieldMap=" + this.fieldMap + ", operationResponse=" + this.operationResponse + ", operationRequestFields=" + this.operationRequestFields + ", operationResponseFields=" + this.operationResponseFields + ", resource=" + this.resource + ", outerNestedTypes=" + this.outerNestedTypes + ", nestedEnums=" + this.nestedEnums + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Message) {
            Message that = (Message)o;
            return this.name.equals(that.name()) && this.fullProtoName.equals(that.fullProtoName()) && this.fields.equals(that.fields()) && this.enumValues.equals(that.enumValues()) && this.type.equals(that.type()) && this.fieldMap.equals(that.fieldMap()) && (this.operationResponse == null ? that.operationResponse() == null : this.operationResponse.equals(that.operationResponse())) && this.operationRequestFields.equals(that.operationRequestFields()) && this.operationResponseFields.equals(that.operationResponseFields()) && (this.resource == null ? that.resource() == null : this.resource.equals(that.resource())) && this.outerNestedTypes.equals(that.outerNestedTypes()) && this.nestedEnums.equals(that.nestedEnums());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.fullProtoName.hashCode();
        h$ *= 1000003;
        h$ ^= this.fields.hashCode();
        h$ *= 1000003;
        h$ ^= this.enumValues.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.fieldMap.hashCode();
        h$ *= 1000003;
        h$ ^= this.operationResponse == null ? 0 : this.operationResponse.hashCode();
        h$ *= 1000003;
        h$ ^= this.operationRequestFields.hashCode();
        h$ *= 1000003;
        h$ ^= this.operationResponseFields.hashCode();
        h$ *= 1000003;
        h$ ^= this.resource == null ? 0 : this.resource.hashCode();
        h$ *= 1000003;
        h$ ^= this.outerNestedTypes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.nestedEnums.hashCode();
    }

    @Override
    public Message.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Message.Builder {
        private String name;
        private String fullProtoName;
        private ImmutableList<Field> fields;
        private ImmutableMap<String, Integer> enumValues;
        private TypeNode type;
        private ImmutableMap<String, Field> fieldMap;
        private OperationResponse operationResponse;
        private Map<String, String> operationRequestFields;
        private BiMap<String, String> operationResponseFields;
        private ResourceName resource;
        private ImmutableList<String> outerNestedTypes;
        private ImmutableList<String> nestedEnums;

        Builder() {
        }

        Builder(Message source) {
            this.name = source.name();
            this.fullProtoName = source.fullProtoName();
            this.fields = source.fields();
            this.enumValues = source.enumValues();
            this.type = source.type();
            this.fieldMap = source.fieldMap();
            this.operationResponse = source.operationResponse();
            this.operationRequestFields = source.operationRequestFields();
            this.operationResponseFields = source.operationResponseFields();
            this.resource = source.resource();
            this.outerNestedTypes = source.outerNestedTypes();
            this.nestedEnums = source.nestedEnums();
        }

        @Override
        public Message.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public Message.Builder setFullProtoName(String fullProtoName) {
            if (fullProtoName == null) {
                throw new NullPointerException("Null fullProtoName");
            }
            this.fullProtoName = fullProtoName;
            return this;
        }

        @Override
        public Message.Builder setFields(List<Field> fields) {
            this.fields = ImmutableList.copyOf(fields);
            return this;
        }

        @Override
        ImmutableList<Field> fields() {
            if (this.fields == null) {
                throw new IllegalStateException("Property \"fields\" has not been set");
            }
            return this.fields;
        }

        @Override
        public Message.Builder setEnumValues(Map<String, Integer> enumValues) {
            this.enumValues = ImmutableMap.copyOf(enumValues);
            return this;
        }

        @Override
        ImmutableMap<String, Integer> enumValues() {
            if (this.enumValues == null) {
                throw new IllegalStateException("Property \"enumValues\" has not been set");
            }
            return this.enumValues;
        }

        @Override
        public Message.Builder setType(TypeNode type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        Message.Builder setFieldMap(Map<String, Field> fieldMap) {
            this.fieldMap = ImmutableMap.copyOf(fieldMap);
            return this;
        }

        @Override
        public Message.Builder setOperationResponse(OperationResponse operationResponse) {
            this.operationResponse = operationResponse;
            return this;
        }

        @Override
        public Message.Builder setOperationRequestFields(Map<String, String> operationRequestFields) {
            if (operationRequestFields == null) {
                throw new NullPointerException("Null operationRequestFields");
            }
            this.operationRequestFields = operationRequestFields;
            return this;
        }

        @Override
        public Message.Builder setOperationResponseFields(BiMap<String, String> operationResponseFields) {
            if (operationResponseFields == null) {
                throw new NullPointerException("Null operationResponseFields");
            }
            this.operationResponseFields = operationResponseFields;
            return this;
        }

        @Override
        public Message.Builder setResource(ResourceName resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public Message.Builder setOuterNestedTypes(List<String> outerNestedTypes) {
            this.outerNestedTypes = ImmutableList.copyOf(outerNestedTypes);
            return this;
        }

        @Override
        public Message.Builder setNestedEnums(List<String> nestedEnums) {
            this.nestedEnums = ImmutableList.copyOf(nestedEnums);
            return this;
        }

        @Override
        Message autoBuild() {
            if (this.name == null || this.fullProtoName == null || this.fields == null || this.enumValues == null || this.type == null || this.fieldMap == null || this.operationRequestFields == null || this.operationResponseFields == null || this.outerNestedTypes == null || this.nestedEnums == null) {
                StringBuilder missing = new StringBuilder();
                if (this.name == null) {
                    missing.append(" name");
                }
                if (this.fullProtoName == null) {
                    missing.append(" fullProtoName");
                }
                if (this.fields == null) {
                    missing.append(" fields");
                }
                if (this.enumValues == null) {
                    missing.append(" enumValues");
                }
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.fieldMap == null) {
                    missing.append(" fieldMap");
                }
                if (this.operationRequestFields == null) {
                    missing.append(" operationRequestFields");
                }
                if (this.operationResponseFields == null) {
                    missing.append(" operationResponseFields");
                }
                if (this.outerNestedTypes == null) {
                    missing.append(" outerNestedTypes");
                }
                if (this.nestedEnums == null) {
                    missing.append(" nestedEnums");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Message(this.name, this.fullProtoName, this.fields, this.enumValues, this.type, this.fieldMap, this.operationResponse, this.operationRequestFields, this.operationResponseFields, this.resource, this.outerNestedTypes, this.nestedEnums);
        }
    }
}

