/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.generator.gapic.model.GapicLroRetrySettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class GapicLroRetrySettingsParser {
    private static final String YAML_KEY_INTERFACES = "interfaces";
    private static final String YAML_KEY_NAME = "name";
    private static final String YAML_KEY_METHODS = "methods";
    private static final String YAML_KEY_LONG_RUNNING = "long_running";
    private static final String YAML_KEY_INITIAL_POLL_DELAY_MILLIS = "initial_poll_delay_millis";
    private static final String YAML_KEY_POLL_DELAY_MULTIPLIER = "poll_delay_multiplier";
    private static final String YAML_KEY_MAX_POLL_DELAY_MILLIS = "max_poll_delay_millis";
    private static final String YAML_KEY_TOTAL_POLL_TIMEOUT_MILLIS = "total_poll_timeout_millis";

    public static Optional<List<GapicLroRetrySettings>> parse(Optional<String> gapicYamlConfigFilePathOpt) {
        return gapicYamlConfigFilePathOpt.isPresent() ? GapicLroRetrySettingsParser.parse(gapicYamlConfigFilePathOpt.get()) : Optional.empty();
    }

    @VisibleForTesting
    static Optional<List<GapicLroRetrySettings>> parse(String gapicYamlConfigFilePath) {
        if (Strings.isNullOrEmpty(gapicYamlConfigFilePath) || !new File(gapicYamlConfigFilePath).exists()) {
            return Optional.empty();
        }
        String fileContents = null;
        try {
            fileContents = new String(Files.readAllBytes(Paths.get(gapicYamlConfigFilePath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        Map yamlMap = (Map)yaml.load(fileContents);
        return GapicLroRetrySettingsParser.parseFromMap(yamlMap);
    }

    private static Optional<List<GapicLroRetrySettings>> parseFromMap(Map<String, Object> yamlMap) {
        if (!yamlMap.containsKey(YAML_KEY_INTERFACES)) {
            return Optional.empty();
        }
        ArrayList<GapicLroRetrySettings> settings = new ArrayList<GapicLroRetrySettings>();
        for (Map serviceYamlConfig : (List)yamlMap.get(YAML_KEY_INTERFACES)) {
            if (!serviceYamlConfig.containsKey(YAML_KEY_METHODS)) continue;
            for (Map methodYamlConfig : (List)serviceYamlConfig.get(YAML_KEY_METHODS)) {
                Map lroRetrySettingsYamlConfig;
                if (!methodYamlConfig.containsKey(YAML_KEY_LONG_RUNNING) || !(lroRetrySettingsYamlConfig = (Map)methodYamlConfig.get(YAML_KEY_LONG_RUNNING)).containsKey(YAML_KEY_INITIAL_POLL_DELAY_MILLIS) || !lroRetrySettingsYamlConfig.containsKey(YAML_KEY_POLL_DELAY_MULTIPLIER) || !lroRetrySettingsYamlConfig.containsKey(YAML_KEY_MAX_POLL_DELAY_MILLIS) || !lroRetrySettingsYamlConfig.containsKey(YAML_KEY_TOTAL_POLL_TIMEOUT_MILLIS)) continue;
                String interfaceName = (String)serviceYamlConfig.get(YAML_KEY_NAME);
                int lastDotIndex = interfaceName.lastIndexOf(".");
                String protoPakkage = interfaceName.substring(0, lastDotIndex);
                String serviceName = interfaceName.substring(lastDotIndex + 1);
                String methodName = (String)methodYamlConfig.get(YAML_KEY_NAME);
                GapicLroRetrySettings.Builder lroRetrySettingsBuilder = GapicLroRetrySettings.builder().setProtoPakkage(protoPakkage).setServiceName(serviceName).setMethodName(methodName).setInitialPollDelayMillis(((Integer)lroRetrySettingsYamlConfig.get(YAML_KEY_INITIAL_POLL_DELAY_MILLIS)).intValue()).setMaxPollDelayMillis(((Integer)lroRetrySettingsYamlConfig.get(YAML_KEY_MAX_POLL_DELAY_MILLIS)).intValue()).setTotalPollTimeoutMillis(((Integer)lroRetrySettingsYamlConfig.get(YAML_KEY_TOTAL_POLL_TIMEOUT_MILLIS)).intValue());
                Object pollDelayMultObj = lroRetrySettingsYamlConfig.get(YAML_KEY_POLL_DELAY_MULTIPLIER);
                if (pollDelayMultObj instanceof Integer) {
                    lroRetrySettingsBuilder = lroRetrySettingsBuilder.setPollDelayMultiplier(((Integer)pollDelayMultObj).intValue());
                } else if (pollDelayMultObj instanceof Double) {
                    lroRetrySettingsBuilder = lroRetrySettingsBuilder.setPollDelayMultiplier((Double)pollDelayMultObj);
                }
                settings.add(lroRetrySettingsBuilder.build());
            }
        }
        return settings.isEmpty() ? Optional.empty() : Optional.of(settings);
    }
}

