/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslContextOption;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslSessionContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.s2a.internal.handshaker.AuthenticationMechanism;
import io.grpc.s2a.internal.handshaker.ConnectionSide;
import io.grpc.s2a.internal.handshaker.GetAuthenticationMechanisms;
import io.grpc.s2a.internal.handshaker.GetTlsConfigurationReq;
import io.grpc.s2a.internal.handshaker.GetTlsConfigurationResp;
import io.grpc.s2a.internal.handshaker.ProtoUtil;
import io.grpc.s2a.internal.handshaker.S2AConnectionException;
import io.grpc.s2a.internal.handshaker.S2AIdentity;
import io.grpc.s2a.internal.handshaker.S2APrivateKeyMethod;
import io.grpc.s2a.internal.handshaker.S2AStub;
import io.grpc.s2a.internal.handshaker.S2ATrustManager;
import io.grpc.s2a.internal.handshaker.SessionReq;
import io.grpc.s2a.internal.handshaker.SessionResp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSessionContext;

final class SslContextFactory {
    static SslContext createForClient(S2AStub stub, String targetName, Optional<S2AIdentity> localIdentity) throws IOException, InterruptedException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, GeneralSecurityException {
        GetTlsConfigurationResp.ClientTlsConfiguration clientTlsConfiguration;
        Preconditions.checkNotNull(stub, "stub should not be null.");
        Preconditions.checkNotNull(targetName, "targetName should not be null on client side.");
        try {
            clientTlsConfiguration = SslContextFactory.getClientTlsConfigurationFromS2A(stub, localIdentity);
        }
        catch (IOException | InterruptedException e) {
            throw new GeneralSecurityException("Failed to get client TLS configuration from S2A.", e);
        }
        SslContextBuilder sslContextBuilder = GrpcSslContexts.configure(SslContextBuilder.forClient()).sessionCacheSize(1L).sessionTimeout(0L);
        SslContextFactory.configureSslContextWithClientTlsConfiguration(clientTlsConfiguration, sslContextBuilder);
        sslContextBuilder.trustManager(S2ATrustManager.createForClient(stub, targetName, localIdentity));
        sslContextBuilder.option(OpenSslContextOption.PRIVATE_KEY_METHOD, S2APrivateKeyMethod.create(stub, localIdentity));
        SslContext sslContext = sslContextBuilder.build();
        SSLSessionContext sslSessionContext = sslContext.sessionContext();
        if (sslSessionContext instanceof OpenSslSessionContext) {
            OpenSslSessionContext openSslSessionContext = (OpenSslSessionContext)sslSessionContext;
            openSslSessionContext.setSessionCacheEnabled(false);
        }
        return sslContext;
    }

    private static GetTlsConfigurationResp.ClientTlsConfiguration getClientTlsConfigurationFromS2A(S2AStub stub, Optional<S2AIdentity> localIdentity) throws IOException, InterruptedException {
        SessionResp resp;
        Optional<AuthenticationMechanism> authMechanism;
        Preconditions.checkNotNull(stub, "stub should not be null.");
        SessionReq.Builder reqBuilder = SessionReq.newBuilder();
        if (localIdentity.isPresent()) {
            reqBuilder.setLocalIdentity(localIdentity.get().getIdentity());
        }
        if ((authMechanism = GetAuthenticationMechanisms.getAuthMechanism(localIdentity)).isPresent()) {
            reqBuilder.addAuthenticationMechanisms(authMechanism.get());
        }
        if ((resp = stub.send(reqBuilder.setGetTlsConfigurationReq(GetTlsConfigurationReq.newBuilder().setConnectionSide(ConnectionSide.CONNECTION_SIDE_CLIENT)).build())).hasStatus() && resp.getStatus().getCode() != 0) {
            throw new S2AConnectionException(String.format("response from S2A server has ean error %d with error message %s.", resp.getStatus().getCode(), resp.getStatus().getDetails()));
        }
        if (!resp.getGetTlsConfigurationResp().hasClientTlsConfiguration()) {
            throw new S2AConnectionException("Response from S2A server does NOT contain ClientTlsConfiguration.");
        }
        return resp.getGetTlsConfigurationResp().getClientTlsConfiguration();
    }

    private static void configureSslContextWithClientTlsConfiguration(GetTlsConfigurationResp.ClientTlsConfiguration clientTlsConfiguration, SslContextBuilder sslContextBuilder) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        sslContextBuilder.keyManager(SslContextFactory.createKeylessManager(clientTlsConfiguration));
        ImmutableSet<String> tlsVersions = ProtoUtil.buildTlsProtocolVersionSet(clientTlsConfiguration.getMinTlsVersion(), clientTlsConfiguration.getMaxTlsVersion());
        if (tlsVersions.isEmpty()) {
            throw new S2AConnectionException("Set of TLS versions received from S2A server is empty or not supported.");
        }
        sslContextBuilder.protocols(tlsVersions);
    }

    private static KeyManager createKeylessManager(GetTlsConfigurationResp.ClientTlsConfiguration clientTlsConfiguration) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X509Certificate[] certificates = new X509Certificate[clientTlsConfiguration.getCertificateChainCount()];
        for (int i = 0; i < clientTlsConfiguration.getCertificateChainCount(); ++i) {
            certificates[i] = SslContextFactory.convertStringToX509Cert(clientTlsConfiguration.getCertificateChain(i));
        }
        KeyManager[] keyManagers = OpenSslX509KeyManagerFactory.newKeyless(certificates).getKeyManagers();
        if (keyManagers == null || keyManagers.length == 0) {
            throw new IllegalStateException("No key managers created.");
        }
        return keyManagers[0];
    }

    private static X509Certificate convertStringToX509Cert(String certificate) throws CertificateException {
        return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(certificate.getBytes(StandardCharsets.UTF_8)));
    }

    private SslContextFactory() {
    }
}

