/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.samplecode;

import com.google.common.annotations.VisibleForTesting;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SampleBodyJavaFormatter {
    private static final Formatter FORMATTER = new Formatter();
    private static final String FAKE_CLASS_TITLE = "public class FakeClass { void fakeMethod() {\n";
    private static final String FAKE_CLASS_CLOSE = "}}";

    private SampleBodyJavaFormatter() {
    }

    public static String format(String sampleCode) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(FAKE_CLASS_TITLE);
        buffer.append(sampleCode);
        buffer.append(FAKE_CLASS_CLOSE);
        String formattedString = null;
        try {
            formattedString = FORMATTER.formatSource(buffer.toString());
        }
        catch (FormatterException e) {
            throw new FormatException(String.format("The sample code should be string where is composed by statements; %s", e));
        }
        Pattern pattern = Pattern.compile("(^([^\n]*\n){2})|(([^\n]*\n){2}$)");
        Matcher matcher = pattern.matcher(formattedString);
        formattedString = matcher.replaceAll("");
        pattern = Pattern.compile("(?m)^ {4}");
        matcher = pattern.matcher(formattedString);
        formattedString = matcher.replaceAll("");
        return formattedString.trim();
    }

    @VisibleForTesting
    protected static class FormatException
    extends RuntimeException {
        public FormatException(String errorMessage) {
            super(errorMessage);
        }
    }
}

