/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonClientCall;
import com.google.api.gax.httpjson.HttpJsonMetadata;
import com.google.api.gax.httpjson.HttpJsonStatusRuntimeException;
import com.google.api.gax.rpc.ApiCallContext;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;

class HttpJsonClientCalls {
    private static final Logger LOGGER = Logger.getLogger(HttpJsonClientCalls.class.getName());

    HttpJsonClientCalls() {
    }

    public static <RequestT, ResponseT> HttpJsonClientCall<RequestT, ResponseT> newCall(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, ApiCallContext context) {
        HttpJsonCallContext httpJsonContext = HttpJsonCallContext.createDefault().nullToSelf(context);
        if (httpJsonContext.getTimeoutDuration() != null) {
            HttpJsonCallOptions callOptions = httpJsonContext.getCallOptions();
            if (callOptions.getTimeoutDuration() == null || httpJsonContext.getTimeoutDuration().compareTo(Duration.ofMillis(callOptions.getTimeoutDuration().toMillis())) < 0) {
                callOptions = callOptions.toBuilder().setTimeoutDuration(Duration.ofMillis(httpJsonContext.getTimeoutDuration().toMillis())).build();
            }
            httpJsonContext = httpJsonContext.withCallOptions(callOptions);
        }
        httpJsonContext.validateUniverseDomain();
        return httpJsonContext.getChannel().newCall(methodDescriptor, httpJsonContext.getCallOptions());
    }

    static <RequestT, ResponseT> ApiFuture<ResponseT> futureUnaryCall(HttpJsonClientCall<RequestT, ResponseT> clientCall, RequestT request, HttpJsonCallContext context) {
        HttpJsonFuture future = new HttpJsonFuture(clientCall);
        clientCall.start(new FutureListener(future), HttpJsonMetadata.newBuilder().build().withHeaders(context.getExtraHeaders()));
        try {
            clientCall.sendMessage(request);
            clientCall.halfClose();
            clientCall.request(2);
        }
        catch (Throwable sendError) {
            try {
                clientCall.cancel(null, sendError);
            }
            catch (Throwable cancelError) {
                LOGGER.log(Level.SEVERE, "Error encountered while closing it", sendError);
            }
            throw sendError;
        }
        return future;
    }

    private static class HttpJsonFuture<T>
    extends AbstractApiFuture<T> {
        private final HttpJsonClientCall<?, T> call;

        private HttpJsonFuture(HttpJsonClientCall<?, T> call) {
            this.call = call;
        }

        @Override
        protected void interruptTask() {
            this.call.cancel("HttpJsonFuture was cancelled", null);
        }

        @Override
        public boolean set(T value) {
            return super.set(value);
        }

        @Override
        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }

    private static class FutureListener<T>
    extends HttpJsonClientCall.Listener<T> {
        private final HttpJsonFuture<T> future;
        private T message;
        private boolean isMessageReceived;

        private FutureListener(HttpJsonFuture<T> future) {
            this.future = future;
            this.isMessageReceived = false;
        }

        @Override
        public void onMessage(T message) {
            if (this.isMessageReceived) {
                throw new IllegalStateException("More than one value received for unary call");
            }
            this.isMessageReceived = true;
            this.message = message;
        }

        @Override
        public void onClose(int statusCode, HttpJsonMetadata trailers) {
            if (!this.isMessageReceived) {
                if (trailers == null || trailers.getException() == null) {
                    this.future.setException(new HttpJsonStatusRuntimeException(statusCode, "Exception during a client call closure", new NullPointerException("Both response message and response exception were null")));
                } else {
                    this.future.setException(trailers.getException());
                }
            } else {
                this.future.set(this.message);
            }
        }
    }
}

