/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.trust;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.re2j.Pattern;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.matcher.v3.RegexMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.matcher.v3.StringMatcher;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class XdsX509TrustManager
extends X509ExtendedTrustManager
implements X509TrustManager {
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_URI_NAME = 6;
    private static final int ALT_IPA_NAME = 7;
    private final X509ExtendedTrustManager delegate;
    private final CertificateValidationContext certContext;

    XdsX509TrustManager(@Nullable CertificateValidationContext certContext, X509ExtendedTrustManager delegate) {
        Preconditions.checkNotNull(delegate, "delegate");
        this.certContext = certContext;
        this.delegate = delegate;
    }

    private static boolean verifyDnsNameInPattern(String altNameFromCert, StringMatcher sanToVerifyMatcher) {
        if (Strings.isNullOrEmpty(altNameFromCert)) {
            return false;
        }
        switch (sanToVerifyMatcher.getMatchPatternCase()) {
            case EXACT: {
                return XdsX509TrustManager.verifyDnsNameExact(altNameFromCert, sanToVerifyMatcher.getExact(), sanToVerifyMatcher.getIgnoreCase());
            }
            case PREFIX: {
                return XdsX509TrustManager.verifyDnsNamePrefix(altNameFromCert, sanToVerifyMatcher.getPrefix(), sanToVerifyMatcher.getIgnoreCase());
            }
            case SUFFIX: {
                return XdsX509TrustManager.verifyDnsNameSuffix(altNameFromCert, sanToVerifyMatcher.getSuffix(), sanToVerifyMatcher.getIgnoreCase());
            }
            case CONTAINS: {
                return XdsX509TrustManager.verifyDnsNameContains(altNameFromCert, sanToVerifyMatcher.getContains(), sanToVerifyMatcher.getIgnoreCase());
            }
            case SAFE_REGEX: {
                return XdsX509TrustManager.verifyDnsNameSafeRegex(altNameFromCert, sanToVerifyMatcher.getSafeRegex());
            }
        }
        throw new IllegalArgumentException("Unknown match-pattern-case " + sanToVerifyMatcher.getMatchPatternCase());
    }

    private static boolean verifyDnsNameSafeRegex(String altNameFromCert, RegexMatcher sanToVerifySafeRegex) {
        Pattern safeRegExMatch = Pattern.compile(sanToVerifySafeRegex.getRegex());
        return safeRegExMatch.matches(altNameFromCert);
    }

    private static boolean verifyDnsNamePrefix(String altNameFromCert, String sanToVerifyPrefix, boolean ignoreCase) {
        if (Strings.isNullOrEmpty(sanToVerifyPrefix)) {
            return false;
        }
        return ignoreCase ? altNameFromCert.toLowerCase(Locale.ROOT).startsWith(sanToVerifyPrefix.toLowerCase(Locale.ROOT)) : altNameFromCert.startsWith(sanToVerifyPrefix);
    }

    private static boolean verifyDnsNameSuffix(String altNameFromCert, String sanToVerifySuffix, boolean ignoreCase) {
        if (Strings.isNullOrEmpty(sanToVerifySuffix)) {
            return false;
        }
        return ignoreCase ? altNameFromCert.toLowerCase(Locale.ROOT).endsWith(sanToVerifySuffix.toLowerCase(Locale.ROOT)) : altNameFromCert.endsWith(sanToVerifySuffix);
    }

    private static boolean verifyDnsNameContains(String altNameFromCert, String sanToVerifySubstring, boolean ignoreCase) {
        if (Strings.isNullOrEmpty(sanToVerifySubstring)) {
            return false;
        }
        return ignoreCase ? altNameFromCert.toLowerCase(Locale.ROOT).contains(sanToVerifySubstring.toLowerCase(Locale.ROOT)) : altNameFromCert.contains(sanToVerifySubstring);
    }

    private static boolean verifyDnsNameExact(String altNameFromCert, String sanToVerifyExact, boolean ignoreCase) {
        if (Strings.isNullOrEmpty(sanToVerifyExact)) {
            return false;
        }
        return ignoreCase ? sanToVerifyExact.equalsIgnoreCase(altNameFromCert) : sanToVerifyExact.equals(altNameFromCert);
    }

    private static boolean verifyDnsNameInSanList(String altNameFromCert, List<StringMatcher> verifySanList) {
        for (StringMatcher verifySan : verifySanList) {
            if (!XdsX509TrustManager.verifyDnsNameInPattern(altNameFromCert, verifySan)) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyOneSanInList(List<?> entry, List<StringMatcher> verifySanList) throws CertificateParsingException {
        if (entry == null || entry.size() < 2) {
            throw new CertificateParsingException("Invalid SAN entry");
        }
        Integer altNameType = (Integer)entry.get(0);
        if (altNameType == null) {
            throw new CertificateParsingException("Invalid SAN entry: null altNameType");
        }
        switch (altNameType) {
            case 2: 
            case 6: 
            case 7: {
                return XdsX509TrustManager.verifyDnsNameInSanList((String)entry.get(1), verifySanList);
            }
        }
        return false;
    }

    private static void verifySubjectAltNameInLeaf(X509Certificate cert, List<StringMatcher> verifyList) throws CertificateException {
        Collection<List<?>> names = cert.getSubjectAlternativeNames();
        if (names == null || names.isEmpty()) {
            throw new CertificateException("Peer certificate SAN check failed");
        }
        for (List<?> name : names) {
            if (!XdsX509TrustManager.verifyOneSanInList(name, verifyList)) continue;
            return;
        }
        throw new CertificateException("Peer certificate SAN check failed");
    }

    @VisibleForTesting
    void verifySubjectAltNameInChain(X509Certificate[] peerCertChain) throws CertificateException {
        if (this.certContext == null) {
            return;
        }
        List<StringMatcher> verifyList = this.certContext.getMatchSubjectAltNamesList();
        if (verifyList.isEmpty()) {
            return;
        }
        if (peerCertChain == null || peerCertChain.length < 1) {
            throw new CertificateException("Peer certificate(s) missing");
        }
        XdsX509TrustManager.verifySubjectAltNameInLeaf(peerCertChain[0], verifyList);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, sslEngine);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        SSLSocket sslSocket;
        SSLParameters sslParams;
        if (socket instanceof SSLSocket && (sslParams = (sslSocket = (SSLSocket)socket).getSSLParameters()) != null) {
            sslParams.setEndpointIdentificationAlgorithm("");
            sslSocket.setSSLParameters(sslParams);
        }
        this.delegate.checkServerTrusted(chain, authType, socket);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        SSLParameters sslParams = sslEngine.getSSLParameters();
        if (sslParams != null) {
            sslParams.setEndpointIdentificationAlgorithm("");
            sslEngine.setSSLParameters(sslParams);
        }
        this.delegate.checkServerTrusted(chain, authType, sslEngine);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
        this.verifySubjectAltNameInChain(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

