/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.InternalApi;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.StatusCode;
import com.google.longrunning.Operation;
import com.google.rpc.Code;

@InternalApi
public class HttpJsonOperationSnapshot
implements OperationSnapshot {
    private final String name;
    private final Object metadata;
    private final boolean done;
    private final Object response;
    private final StatusCode errorCode;
    private final String errorMessage;

    private HttpJsonOperationSnapshot(String name, Object metadata, boolean done, Object response, StatusCode errorCode, String errorMessage) {
        this.name = name;
        this.metadata = metadata;
        this.done = done;
        this.response = response;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public StatusCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static HttpJsonOperationSnapshot create(Operation operation) {
        return HttpJsonOperationSnapshot.newBuilder().setOperation(operation).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Object metadata;
        private boolean done;
        private Object response;
        private StatusCode errorCode;
        private String errorMessage;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMetadata(Object metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setDone(boolean done) {
            this.done = done;
            return this;
        }

        public Builder setResponse(Object response) {
            this.response = response;
            return this;
        }

        public Builder setError(int httpStatus, String errorMessage) {
            this.errorCode = httpStatus == 0 ? HttpJsonStatusCode.of(StatusCode.Code.OK) : HttpJsonStatusCode.of(httpStatus);
            this.errorMessage = errorMessage;
            return this;
        }

        private Builder setOperation(Operation operation) {
            this.name = operation.getName();
            this.done = operation.getDone();
            this.response = operation.getResponse();
            this.metadata = operation.getMetadata();
            this.errorCode = HttpJsonStatusCode.of(Code.forNumber(operation.getError().getCode()));
            this.errorMessage = operation.getError().getMessage();
            return this;
        }

        public HttpJsonOperationSnapshot build() {
            return new HttpJsonOperationSnapshot(this.name, this.metadata, this.done, this.response, this.errorCode, this.errorMessage);
        }
    }
}

