/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.common;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.CastExpr;
import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.LambdaExpr;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.NewObjectExpr;
import com.google.api.generator.engine.ast.PrimitiveValue;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.ReferenceConstructorExpr;
import com.google.api.generator.engine.ast.RelationalOperationExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.SuperObjectValue;
import com.google.api.generator.engine.ast.TernaryExpr;
import com.google.api.generator.engine.ast.ThisObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.comment.ServiceClientCommentComposer;
import com.google.api.generator.gapic.composer.common.ClassComposer;
import com.google.api.generator.gapic.composer.common.TransportContext;
import com.google.api.generator.gapic.composer.samplecode.SampleCodeWriter;
import com.google.api.generator.gapic.composer.samplecode.SampleComposerUtil;
import com.google.api.generator.gapic.composer.samplecode.ServiceClientCallableMethodSampleComposer;
import com.google.api.generator.gapic.composer.samplecode.ServiceClientHeaderSampleComposer;
import com.google.api.generator.gapic.composer.samplecode.ServiceClientMethodSampleComposer;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.composer.utils.ClassNames;
import com.google.api.generator.gapic.composer.utils.PackageChecker;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.LongrunningOperation;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.MethodArgument;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Sample;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.api.generator.util.TriFunction;
import com.google.api.generator.util.Trie;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gapic.metadata.GapicMetadata;
import com.google.longrunning.Operation;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;

public abstract class AbstractServiceClientClassComposer
implements ClassComposer {
    private static final String PAGED_RESPONSE_TYPE_NAME_PATTERN = "%sPagedResponse";
    private static final String CALLABLE_NAME_PATTERN = "%sCallable";
    private static final String PAGED_CALLABLE_NAME_PATTERN = "%sPagedCallable";
    private static final String OPERATION_CALLABLE_NAME_PATTERN = "%sOperationCallable";
    private static final Reference LIST_REFERENCE = ConcreteReference.withClazz(List.class);
    private static final Reference MAP_REFERENCE = ConcreteReference.withClazz(Map.class);
    private final TransportContext transportContext;

    protected AbstractServiceClientClassComposer(TransportContext transportContext) {
        this.transportContext = transportContext;
    }

    protected TransportContext getTransportContext() {
        return this.transportContext;
    }

    @Override
    public GapicClass generate(GapicContext context, Service service) {
        ImmutableMap<String, ResourceName> resourceNames = context.helperResourceNames();
        ImmutableMap<String, Message> messageTypes = context.messages();
        TypeStore typeStore = AbstractServiceClientClassComposer.createTypes(service, messageTypes);
        String className = ClassNames.getServiceClientClassName(service);
        GapicClass.Kind kind = GapicClass.Kind.MAIN;
        String pakkage = service.pakkage();
        boolean hasLroClient = service.hasStandardLroMethods();
        ArrayList<Sample> samples = new ArrayList<Sample>();
        HashMap<String, List<String>> grpcRpcsToJavaMethodNames = new HashMap<String, List<String>>();
        HashMap<String, List<String>> methodVariantsForClientHeader = new HashMap<String, List<String>>();
        ClassDefinition classDef = ClassDefinition.builder().setPackageString(pakkage).setAnnotations(AbstractServiceClientClassComposer.createClassAnnotations(service, typeStore)).setScope(ScopeNode.PUBLIC).setName(className).setImplementsTypes(AbstractServiceClientClassComposer.createClassImplements(typeStore)).setStatements(this.createFieldDeclarations(service, typeStore, hasLroClient)).setMethods(this.createClassMethods(service, messageTypes, typeStore, resourceNames, hasLroClient, grpcRpcsToJavaMethodNames, methodVariantsForClientHeader, samples)).setNestedClasses(AbstractServiceClientClassComposer.createNestedPagingClasses(service, messageTypes, typeStore)).setHeaderCommentStatements(this.createClassHeaderComments(methodVariantsForClientHeader, service, typeStore, resourceNames, messageTypes, samples)).build();
        AbstractServiceClientClassComposer.updateGapicMetadata(context, service, className, grpcRpcsToJavaMethodNames);
        return GapicClass.create(kind, classDef, SampleComposerUtil.handleDuplicateSamples(samples)).withApiShortName(service.apiShortName()).withApiVersion(service.apiVersion());
    }

    private static List<AnnotationNode> createClassAnnotations(Service service, TypeStore typeStore) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (!PackageChecker.isGaApi(service.pakkage())) {
            annotations.add(AnnotationNode.withType(typeStore.get("BetaApi")));
        }
        if (service.isDeprecated()) {
            annotations.add(AnnotationNode.withType(TypeNode.DEPRECATED));
        }
        annotations.add(AnnotationNode.builder().setType(typeStore.get("Generated")).setDescription("by gapic-generator-java").build());
        return annotations;
    }

    private static List<TypeNode> createClassImplements(TypeStore typeStore) {
        return Arrays.asList(typeStore.get("BackgroundResource"));
    }

    protected List<CommentStatement> createClassHeaderComments(Map<String, List<String>> methodVariantsForClientHeader, Service service, TypeStore typeStore, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes, List<Sample> samples) {
        TypeNode clientType = typeStore.get(ClassNames.getServiceClientClassName(service));
        TypeNode settingsType = typeStore.get(ClassNames.getServiceSettingsClassName(service));
        Sample classMethodSampleCode = ServiceClientHeaderSampleComposer.composeClassHeaderSample(service, clientType, resourceNames, messageTypes);
        Sample credentialsSampleCode = ServiceClientHeaderSampleComposer.composeSetCredentialsSample(clientType, settingsType, service);
        Sample endpointSampleCode = ServiceClientHeaderSampleComposer.composeSetEndpointSample(clientType, settingsType, service);
        samples.addAll(Arrays.asList(classMethodSampleCode, credentialsSampleCode, endpointSampleCode));
        return ServiceClientCommentComposer.createClassHeaderComments(methodVariantsForClientHeader, service, SampleCodeWriter.writeInlineSample(classMethodSampleCode.body()), SampleCodeWriter.writeInlineSample(credentialsSampleCode.body()), SampleCodeWriter.writeInlineSample(endpointSampleCode.body()), null, null, null);
    }

    private List<MethodDefinition> createClassMethods(Service service, Map<String, Message> messageTypes, TypeStore typeStore, Map<String, ResourceName> resourceNames, boolean hasLroClient, Map<String, List<String>> grpcRpcToJavaMethodMetadata, Map<String, List<String>> methodVariantsForClientHeader, List<Sample> samples) {
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        methods.addAll(AbstractServiceClientClassComposer.createStaticCreatorMethods(service, typeStore));
        methods.addAll(this.createConstructorMethods(service, typeStore, hasLroClient));
        methods.addAll(this.createGetterMethods(service, typeStore, hasLroClient));
        methods.addAll(AbstractServiceClientClassComposer.createServiceMethods(service, messageTypes, typeStore, resourceNames, grpcRpcToJavaMethodMetadata, methodVariantsForClientHeader, samples));
        methods.addAll(AbstractServiceClientClassComposer.createBackgroundResourceMethods(service, typeStore));
        return methods;
    }

    private List<Statement> createFieldDeclarations(Service service, TypeStore typeStore, boolean hasLroClient) {
        HashMap<String, TypeNode> fieldNameToTypes = new HashMap<String, TypeNode>();
        fieldNameToTypes.put("settings", typeStore.get(ClassNames.getServiceSettingsClassName(service)));
        fieldNameToTypes.put("stub", typeStore.get(ClassNames.getServiceStubClassName(service)));
        if (hasLroClient) {
            Iterator<String> opClientName = this.getTransportContext().operationsClientNames().iterator();
            Iterator<TypeNode> opClientType = this.getTransportContext().operationsClientTypes().iterator();
            while (opClientName.hasNext() && opClientType.hasNext()) {
                fieldNameToTypes.put(opClientName.next(), opClientType.next());
            }
        }
        return fieldNameToTypes.entrySet().stream().map(e -> {
            String varName = (String)e.getKey();
            TypeNode varType = (TypeNode)e.getValue();
            Variable variable = Variable.builder().setName(varName).setType(varType).build();
            VariableExpr varExpr = VariableExpr.builder().setVariable(variable).setScope(ScopeNode.PRIVATE).setIsFinal(true).setIsDecl(true).build();
            return ExprStatement.withExpr(varExpr);
        }).collect(Collectors.toList());
    }

    private static List<MethodDefinition> createStaticCreatorMethods(Service service, TypeStore typeStore) {
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        String thisClientName = ClassNames.getServiceClientClassName(service);
        String settingsName = ClassNames.getServiceSettingsClassName(service);
        TypeNode thisClassType = typeStore.get(thisClientName);
        TypeNode exceptionType = typeStore.get("IOException");
        TypeNode settingsType = typeStore.get(settingsName);
        Preconditions.checkNotNull(settingsType, String.format("Type %s not found", settingsName));
        MethodInvocationExpr newBuilderExpr = MethodInvocationExpr.builder().setMethodName("newBuilder").setStaticReferenceType(settingsType).build();
        MethodInvocationExpr buildExpr = MethodInvocationExpr.builder().setMethodName("build").setExprReferenceExpr(newBuilderExpr).build();
        MethodInvocationExpr createMethodInvocationExpr = MethodInvocationExpr.builder().setMethodName("create").setArguments(Arrays.asList(buildExpr)).setReturnType(typeStore.get(thisClientName)).build();
        MethodDefinition createMethodOne = MethodDefinition.builder().setHeaderCommentStatements(ServiceClientCommentComposer.createMethodNoArgComment(ClassNames.getServiceClientClassName(service))).setScope(ScopeNode.PUBLIC).setIsStatic(true).setIsFinal(true).setReturnType(thisClassType).setName("create").setThrowsExceptions(Arrays.asList(exceptionType)).setReturnExpr(createMethodInvocationExpr).build();
        methods.add(createMethodOne);
        VariableExpr settingsVarExpr = VariableExpr.withVariable(Variable.builder().setName("settings").setType(typeStore.get(settingsName)).build());
        methods.add(MethodDefinition.builder().setHeaderCommentStatements(ServiceClientCommentComposer.createMethodSettingsArgComment(ClassNames.getServiceClientClassName(service))).setScope(ScopeNode.PUBLIC).setIsStatic(true).setIsFinal(true).setReturnType(thisClassType).setName("create").setThrowsExceptions(Arrays.asList(exceptionType)).setArguments(settingsVarExpr.toBuilder().setIsDecl(true).build()).setReturnExpr(NewObjectExpr.builder().setType(thisClassType).setArguments(settingsVarExpr).build()).build());
        VariableExpr stubVarExpr = VariableExpr.withVariable(Variable.builder().setType(typeStore.get(ClassNames.getServiceStubClassName(service))).setName("stub").build());
        methods.add(MethodDefinition.builder().setHeaderCommentStatements(ServiceClientCommentComposer.createCreateMethodStubArgComment(ClassNames.getServiceClientClassName(service), settingsVarExpr.type())).setScope(ScopeNode.PUBLIC).setIsStatic(true).setIsFinal(true).setReturnType(thisClassType).setName("create").setArguments(stubVarExpr.toBuilder().setIsDecl(true).build()).setReturnExpr(NewObjectExpr.builder().setType(thisClassType).setArguments(stubVarExpr).build()).build());
        return methods;
    }

    private List<MethodDefinition> createConstructorMethods(Service service, TypeStore typeStore, boolean hasLroClient) {
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        String thisClientName = ClassNames.getServiceClientClassName(service);
        String settingsName = ClassNames.getServiceSettingsClassName(service);
        TypeNode thisClassType = typeStore.get(thisClientName);
        TypeNode stubSettingsType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        TypeNode exceptionType = typeStore.get("IOException");
        VariableExpr settingsVarExpr = VariableExpr.withVariable(Variable.builder().setName("settings").setType(typeStore.get(settingsName)).build());
        VariableExpr stubVarExpr = VariableExpr.withVariable(Variable.builder().setType(typeStore.get(ClassNames.getServiceStubClassName(service))).setName("stub").build());
        ArrayList<AssignmentExpr> ctorAssignmentExprs = new ArrayList<AssignmentExpr>();
        ValueExpr thisExpr = ValueExpr.withValue(ThisObjectValue.withType(thisClassType));
        ctorAssignmentExprs.add(AssignmentExpr.builder().setVariableExpr(settingsVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(settingsVarExpr).build());
        ctorAssignmentExprs.add(AssignmentExpr.builder().setVariableExpr(stubVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(MethodInvocationExpr.builder().setExprReferenceExpr(CastExpr.builder().setType(stubSettingsType).setExpr(MethodInvocationExpr.builder().setExprReferenceExpr(settingsVarExpr).setMethodName("getStubSettings").setReturnType(stubSettingsType).build()).build()).setMethodName("createStub").setReturnType(stubVarExpr.type()).build()).build());
        List<AssignmentExpr> operationsClientAssignExprs = this.createOperationsClientAssignExprs(thisExpr, stubVarExpr);
        if (hasLroClient) {
            ctorAssignmentExprs.addAll(operationsClientAssignExprs);
        }
        methods.add(MethodDefinition.constructorBuilder().setHeaderCommentStatements(ServiceClientCommentComposer.createProtectedCtorSettingsArgComment(ClassNames.getServiceClientClassName(service))).setScope(ScopeNode.PROTECTED).setReturnType(thisClassType).setArguments(settingsVarExpr.toBuilder().setIsDecl(true).build()).setThrowsExceptions(Arrays.asList(exceptionType)).setBody(ctorAssignmentExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).build());
        ctorAssignmentExprs.clear();
        ctorAssignmentExprs.add(AssignmentExpr.builder().setVariableExpr(settingsVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(ValueExpr.createNullExpr()).build());
        ctorAssignmentExprs.add(AssignmentExpr.builder().setVariableExpr(stubVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(stubVarExpr).build());
        if (hasLroClient) {
            ctorAssignmentExprs.addAll(operationsClientAssignExprs);
        }
        methods.add(MethodDefinition.constructorBuilder().setScope(ScopeNode.PROTECTED).setReturnType(thisClassType).setArguments(stubVarExpr.toBuilder().setIsDecl(true).build()).setBody(ctorAssignmentExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).build());
        return methods;
    }

    private List<AssignmentExpr> createOperationsClientAssignExprs(Expr thisExpr, VariableExpr stubVarExpr) {
        ArrayList<AssignmentExpr> operationsClientAssignExprs = new ArrayList<AssignmentExpr>();
        Iterator<TypeNode> opClientTypesIt = this.getTransportContext().operationsClientTypes().iterator();
        Iterator<String> opClientNamesIt = this.getTransportContext().operationsClientNames().iterator();
        Iterator<String> opStubNamesIt = this.getTransportContext().transportOperationsStubNames().iterator();
        while (opClientTypesIt.hasNext() && opClientNamesIt.hasNext() && opStubNamesIt.hasNext()) {
            TypeNode operationsClientType = opClientTypesIt.next();
            String opClientName = opClientNamesIt.next();
            String opStubName = opStubNamesIt.next();
            VariableExpr operationsClientVarExpr = VariableExpr.withVariable(Variable.builder().setType(operationsClientType).setName(opClientName).build());
            String operationsStubGetterName = String.format("get%s", JavaStyle.toUpperCamelCase(opStubName));
            MethodInvocationExpr clientArgExpr = MethodInvocationExpr.builder().setExprReferenceExpr(stubVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setMethodName(operationsStubGetterName).build();
            AssignmentExpr operationsClientAssignExpr = AssignmentExpr.builder().setVariableExpr(operationsClientVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(operationsClientType).setMethodName("create").setArguments(clientArgExpr).setReturnType(operationsClientVarExpr.type()).build()).build();
            operationsClientAssignExprs.add(operationsClientAssignExpr);
        }
        return operationsClientAssignExprs;
    }

    private List<MethodDefinition> createGetterMethods(Service service, TypeStore typeStore, boolean hasLroClient) {
        LinkedHashMap<String, TypeNode> methodNameToTypes = new LinkedHashMap<String, TypeNode>();
        methodNameToTypes.put("getSettings", typeStore.get(ClassNames.getServiceSettingsClassName(service)));
        methodNameToTypes.put("getStub", typeStore.get(ClassNames.getServiceStubClassName(service)));
        HashMap getOperationsClientMethod = new HashMap();
        AnnotationNode betaAnnotation = AnnotationNode.builder().setType(typeStore.get("BetaApi")).build();
        if (hasLroClient) {
            Iterator<String> opClientNamesIt = this.getTransportContext().operationsClientNames().iterator();
            Iterator<TypeNode> opClientTypesIt = this.getTransportContext().operationsClientTypes().iterator();
            List<Object> operationClientGetterAnnotations = new ArrayList();
            while (opClientNamesIt.hasNext() && opClientTypesIt.hasNext()) {
                String opClientMethodName = String.format("get%s", JavaStyle.toUpperCamelCase(opClientNamesIt.next()));
                getOperationsClientMethod.put(opClientMethodName, operationClientGetterAnnotations);
                methodNameToTypes.put(opClientMethodName, opClientTypesIt.next());
                if (!operationClientGetterAnnotations.isEmpty()) continue;
                operationClientGetterAnnotations = Collections.singletonList(betaAnnotation);
            }
        }
        return methodNameToTypes.entrySet().stream().map(e -> {
            String methodName = (String)e.getKey();
            TypeNode methodReturnType = (TypeNode)e.getValue();
            String returnVariableName = JavaStyle.toLowerCamelCase(methodName.substring(3));
            MethodDefinition.Builder methodBuilder = MethodDefinition.builder();
            List annotations = (List)getOperationsClientMethod.get(methodName);
            if (annotations != null) {
                methodBuilder = methodBuilder.setHeaderCommentStatements(ServiceClientCommentComposer.GET_OPERATIONS_CLIENT_METHOD_COMMENT);
                methodBuilder.setAnnotations(annotations);
            }
            return methodBuilder.setScope(ScopeNode.PUBLIC).setName(methodName).setIsFinal(!methodName.equals("getStub")).setReturnType(methodReturnType).setReturnExpr(VariableExpr.builder().setVariable(Variable.builder().setName(returnVariableName).setType(methodReturnType).build()).build()).build();
        }).collect(Collectors.toList());
    }

    private static String getJavaMethod(MethodDefinition m4) {
        StringBuilder methodSignature = new StringBuilder();
        methodSignature.append(m4.methodIdentifier().name()).append("(");
        List parameters = m4.arguments().stream().map(VariableExpr::variable).collect(Collectors.toList());
        for (int i = 0; i < parameters.size(); ++i) {
            Variable param = (Variable)parameters.get(i);
            String paramType = param.type().reference() != null ? param.type().reference().name() + " " : param.type().typeKind().name().toLowerCase() + " ";
            String paramName = param.identifier().name();
            methodSignature.append(paramType).append(paramName);
            if (i >= parameters.size() - 1) continue;
            methodSignature.append(", ");
        }
        methodSignature.append(")");
        return methodSignature.toString();
    }

    private static List<MethodDefinition> createServiceMethods(Service service, Map<String, Message> messageTypes, TypeStore typeStore, Map<String, ResourceName> resourceNames, Map<String, List<String>> grpcRpcToJavaMethodMetadata, Map<String, List<String>> methodVariantsForClientHeader, List<Sample> samples) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        Function<MethodDefinition, String> javaMethodNameFn = m4 -> m4.methodIdentifier().name();
        for (Method method : service.methods()) {
            MethodDefinition generatedMethod;
            if (!grpcRpcToJavaMethodMetadata.containsKey(method.name())) {
                grpcRpcToJavaMethodMetadata.put(method.name(), new ArrayList());
                methodVariantsForClientHeader.put(method.name(), new ArrayList());
            }
            if (method.stream().equals((Object)Method.Stream.NONE)) {
                List<MethodDefinition> generatedMethods = AbstractServiceClientClassComposer.createMethodVariants(method, ClassNames.getServiceClientClassName(service), messageTypes, typeStore, resourceNames, samples, service);
                grpcRpcToJavaMethodMetadata.get(method.name()).addAll(generatedMethods.stream().map(m4 -> (String)javaMethodNameFn.apply((MethodDefinition)m4)).collect(Collectors.toList()));
                methodVariantsForClientHeader.get(method.name()).addAll(generatedMethods.stream().map(AbstractServiceClientClassComposer::getJavaMethod).collect(Collectors.toList()));
                javaMethods.addAll(generatedMethods);
                MethodDefinition generatedMethod2 = AbstractServiceClientClassComposer.createMethodDefaultMethod(method, ClassNames.getServiceClientClassName(service), messageTypes, typeStore, resourceNames, samples, service);
                grpcRpcToJavaMethodMetadata.get(method.name()).add(javaMethodNameFn.apply(generatedMethod2));
                methodVariantsForClientHeader.get(method.name()).add(AbstractServiceClientClassComposer.getJavaMethod(generatedMethod2));
                javaMethods.add(generatedMethod2);
            }
            if (method.hasLro()) {
                generatedMethod = AbstractServiceClientClassComposer.createLroCallableMethod(service, method, typeStore, messageTypes, resourceNames, samples);
                grpcRpcToJavaMethodMetadata.get(method.name()).add(javaMethodNameFn.apply(generatedMethod));
                methodVariantsForClientHeader.get(method.name()).add(AbstractServiceClientClassComposer.getJavaMethod(generatedMethod));
                javaMethods.add(generatedMethod);
            }
            if (method.isPaged()) {
                generatedMethod = AbstractServiceClientClassComposer.createPagedCallableMethod(service, method, typeStore, messageTypes, resourceNames, samples);
                grpcRpcToJavaMethodMetadata.get(method.name()).add(javaMethodNameFn.apply(generatedMethod));
                methodVariantsForClientHeader.get(method.name()).add(AbstractServiceClientClassComposer.getJavaMethod(generatedMethod));
                javaMethods.add(generatedMethod);
            }
            generatedMethod = AbstractServiceClientClassComposer.createCallableMethod(service, method, typeStore, messageTypes, resourceNames, samples);
            grpcRpcToJavaMethodMetadata.get(method.name()).add(javaMethodNameFn.apply(generatedMethod));
            methodVariantsForClientHeader.get(method.name()).add(AbstractServiceClientClassComposer.getJavaMethod(generatedMethod));
            javaMethods.add(generatedMethod);
        }
        return javaMethods;
    }

    private static List<MethodDefinition> createMethodVariants(Method method, String clientName, Map<String, Message> messageTypes, TypeStore typeStore, Map<String, ResourceName> resourceNames, List<Sample> samples, Service service) {
        TypeNode methodOutputType;
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        String methodName = JavaStyle.toLowerCamelCase(method.name());
        TypeNode methodInputType = method.inputType();
        TypeNode typeNode = methodOutputType = method.isPaged() ? typeStore.get(String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, method.name())) : method.outputType();
        if (method.hasLro()) {
            LongrunningOperation lro = method.lro();
            methodOutputType = TypeNode.withReference(typeStore.get("OperationFuture").reference().copyAndSetGenerics(Arrays.asList(lro.responseType().reference(), lro.metadataType().reference())));
        }
        for (List list : method.methodSignatures()) {
            List<VariableExpr> arguments = list.stream().map(methodArg -> VariableExpr.builder().setVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(methodArg.name())).setType(methodArg.type()).build()).setIsDecl(true).build()).collect(Collectors.toList());
            VariableExpr requestVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("request").setType(methodInputType).build()).setIsDecl(true).build();
            Expr requestBuilderExpr = AbstractServiceClientClassComposer.createRequestBuilderExpr(method, list, typeStore);
            AssignmentExpr requestAssignmentExpr = AssignmentExpr.builder().setVariableExpr(requestVarExpr).setValueExpr(requestBuilderExpr).build();
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add(ExprStatement.withExpr(requestAssignmentExpr));
            MethodInvocationExpr rpcInvocationExpr = MethodInvocationExpr.builder().setMethodName(String.format(method.hasLro() ? "%sAsync" : "%s", methodName)).setArguments(Arrays.asList(requestVarExpr.toBuilder().setIsDecl(false).build())).setReturnType(methodOutputType).build();
            Optional<Sample> methodSample = Optional.of(ServiceClientHeaderSampleComposer.composeShowcaseMethodSample(method, typeStore.get(clientName), list, resourceNames, messageTypes, service));
            Optional<String> methodDocSample = Optional.empty();
            if (methodSample.isPresent()) {
                samples.add(methodSample.get());
                methodDocSample = Optional.of(SampleCodeWriter.writeInlineSample(methodSample.get().body()));
            }
            MethodDefinition.Builder methodVariantBuilder = MethodDefinition.builder().setHeaderCommentStatements(ServiceClientCommentComposer.createRpcMethodHeaderComment(method, list, methodDocSample)).setScope(ScopeNode.PUBLIC).setIsFinal(true).setName(String.format(method.hasLro() ? "%sAsync" : "%s", methodName)).setArguments(arguments);
            if (AbstractServiceClientClassComposer.isProtoEmptyType(methodOutputType)) {
                statements.add(ExprStatement.withExpr(rpcInvocationExpr));
                methodVariantBuilder = methodVariantBuilder.setReturnType(TypeNode.VOID);
            } else {
                methodVariantBuilder = methodVariantBuilder.setReturnType(methodOutputType).setReturnExpr(rpcInvocationExpr);
            }
            if (method.isDeprecated()) {
                methodVariantBuilder = methodVariantBuilder.setAnnotations(Arrays.asList(AnnotationNode.withType(TypeNode.DEPRECATED)));
            }
            methodVariantBuilder = methodVariantBuilder.setBody(statements);
            javaMethods.add(methodVariantBuilder.build());
        }
        return javaMethods;
    }

    private static MethodDefinition createMethodDefaultMethod(Method method, String clientName, Map<String, Message> messageTypes, TypeStore typeStore, Map<String, ResourceName> resourceNames, List<Sample> samples, Service service) {
        String callableMethodName;
        String methodName = JavaStyle.toLowerCamelCase(method.name());
        TypeNode methodInputType = method.inputType();
        TypeNode methodOutputType = method.isPaged() ? typeStore.get(String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, method.name())) : method.outputType();
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (method.hasLro()) {
            LongrunningOperation lro = method.lro();
            methodOutputType = TypeNode.withReference(typeStore.get("OperationFuture").reference().copyAndSetGenerics(Arrays.asList(lro.responseType().reference(), lro.metadataType().reference())));
        }
        VariableExpr requestArgVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("request").setType(methodInputType).build()).setIsDecl(true).build();
        String string = callableMethodName = method.isPaged() ? String.format(PAGED_CALLABLE_NAME_PATTERN, methodName) : String.format(CALLABLE_NAME_PATTERN, methodName);
        if (method.hasLro()) {
            callableMethodName = String.format(OPERATION_CALLABLE_NAME_PATTERN, methodName);
        }
        Optional<Sample> defaultMethodSample = Optional.of(ServiceClientMethodSampleComposer.composeCanonicalSample(method, typeStore.get(clientName), resourceNames, messageTypes, service));
        Optional<String> defaultMethodDocSample = Optional.empty();
        if (defaultMethodSample.isPresent()) {
            samples.add(defaultMethodSample.get());
            defaultMethodDocSample = Optional.of(SampleCodeWriter.writeInlineSample(defaultMethodSample.get().body()));
        }
        MethodInvocationExpr callableMethodExpr = MethodInvocationExpr.builder().setMethodName(callableMethodName).build();
        callableMethodExpr = MethodInvocationExpr.builder().setMethodName(method.hasLro() ? "futureCall" : "call").setArguments(Arrays.asList(requestArgVarExpr.toBuilder().setIsDecl(false).build())).setExprReferenceExpr(callableMethodExpr).setReturnType(methodOutputType).build();
        MethodDefinition.Builder methodBuilder = MethodDefinition.builder().setHeaderCommentStatements(ServiceClientCommentComposer.createRpcMethodHeaderComment(method, defaultMethodDocSample)).setScope(ScopeNode.PUBLIC).setIsFinal(true).setName(String.format(method.hasLro() ? "%sAsync" : "%s", methodName)).setArguments(Arrays.asList(requestArgVarExpr));
        if (method.isDeprecated()) {
            annotations.add(AnnotationNode.withType(TypeNode.DEPRECATED));
        }
        methodBuilder = AbstractServiceClientClassComposer.isProtoEmptyType(methodOutputType) ? methodBuilder.setBody(Arrays.asList(ExprStatement.withExpr(callableMethodExpr))).setReturnType(TypeNode.VOID) : methodBuilder.setReturnExpr(callableMethodExpr).setReturnType(methodOutputType);
        methodBuilder.setAnnotations(annotations);
        return methodBuilder.build();
    }

    private static MethodDefinition createLroCallableMethod(Service service, Method method, TypeStore typeStore, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, List<Sample> samples) {
        return AbstractServiceClientClassComposer.createCallableMethod(service, method, CallableMethodKind.LRO, typeStore, messageTypes, resourceNames, samples);
    }

    private static MethodDefinition createCallableMethod(Service service, Method method, TypeStore typeStore, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, List<Sample> samples) {
        return AbstractServiceClientClassComposer.createCallableMethod(service, method, CallableMethodKind.REGULAR, typeStore, messageTypes, resourceNames, samples);
    }

    private static MethodDefinition createPagedCallableMethod(Service service, Method method, TypeStore typeStore, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, List<Sample> samples) {
        return AbstractServiceClientClassComposer.createCallableMethod(service, method, CallableMethodKind.PAGED, typeStore, messageTypes, resourceNames, samples);
    }

    private static MethodDefinition createCallableMethod(Service service, Method method, CallableMethodKind callableMethodKind, TypeStore typeStore, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, List<Sample> samples) {
        TypeNode rawCallableReturnType = null;
        if (callableMethodKind.equals((Object)CallableMethodKind.LRO)) {
            rawCallableReturnType = typeStore.get("OperationCallable");
        } else {
            switch (method.stream()) {
                case CLIENT: {
                    rawCallableReturnType = typeStore.get("ClientStreamingCallable");
                    break;
                }
                case SERVER: {
                    rawCallableReturnType = typeStore.get("ServerStreamingCallable");
                    break;
                }
                case BIDI: {
                    rawCallableReturnType = typeStore.get("BidiStreamingCallable");
                    break;
                }
                default: {
                    rawCallableReturnType = typeStore.get("UnaryCallable");
                }
            }
        }
        TypeNode returnType = TypeNode.withReference(rawCallableReturnType.reference().copyAndSetGenerics(AbstractServiceClientClassComposer.getGenericsForCallable(callableMethodKind, method, typeStore)));
        String rawMethodName = JavaStyle.toLowerCamelCase(method.name());
        String methodName = AbstractServiceClientClassComposer.getCallableName(callableMethodKind, rawMethodName);
        TypeNode stubType = typeStore.get(ClassNames.getServiceStubClassName(service));
        MethodInvocationExpr returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(VariableExpr.builder().setVariable(Variable.builder().setName("stub").setType(stubType).build()).build()).setMethodName(methodName).setReturnType(returnType).build();
        Optional<Object> sampleCode = Optional.empty();
        if (callableMethodKind.equals((Object)CallableMethodKind.LRO)) {
            sampleCode = Optional.of(ServiceClientCallableMethodSampleComposer.composeLroCallableMethod(method, typeStore.get(ClassNames.getServiceClientClassName(service)), resourceNames, messageTypes, service));
        } else if (callableMethodKind.equals((Object)CallableMethodKind.PAGED)) {
            sampleCode = Optional.of(ServiceClientCallableMethodSampleComposer.composePagedCallableMethod(method, typeStore.get(ClassNames.getServiceClientClassName(service)), resourceNames, messageTypes, service));
        } else if (callableMethodKind.equals((Object)CallableMethodKind.REGULAR)) {
            sampleCode = method.stream().equals((Object)Method.Stream.NONE) ? Optional.of(ServiceClientCallableMethodSampleComposer.composeRegularCallableMethod(method, typeStore.get(ClassNames.getServiceClientClassName(service)), resourceNames, messageTypes, service)) : Optional.of(ServiceClientCallableMethodSampleComposer.composeStreamCallableMethod(method, typeStore.get(ClassNames.getServiceClientClassName(service)), resourceNames, messageTypes, service));
        }
        Optional<String> sampleDocCode = Optional.empty();
        if (sampleCode.isPresent()) {
            samples.add((Sample)sampleCode.get());
            sampleDocCode = Optional.of(SampleCodeWriter.writeInlineSample(((Sample)sampleCode.get()).body()));
        }
        MethodDefinition.Builder methodDefBuilder = MethodDefinition.builder();
        if (method.isDeprecated()) {
            methodDefBuilder = methodDefBuilder.setAnnotations(Arrays.asList(AnnotationNode.withType(TypeNode.DEPRECATED)));
        }
        return methodDefBuilder.setHeaderCommentStatements(ServiceClientCommentComposer.createRpcCallableMethodHeaderComment(method, sampleDocCode)).setScope(ScopeNode.PUBLIC).setIsFinal(true).setName(methodName).setReturnType(returnType).setReturnExpr(returnExpr).build();
    }

    private static List<MethodDefinition> createBackgroundResourceMethods(Service service, TypeStore typeStore) {
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        VariableExpr stubVarExpr = VariableExpr.withVariable(Variable.builder().setType(typeStore.get(ClassNames.getServiceStubClassName(service))).setName("stub").build());
        MethodDefinition closeMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setIsFinal(true).setReturnType(TypeNode.VOID).setName("close").setBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(stubVarExpr).setMethodName("close").build()))).build();
        methods.add(closeMethod);
        MethodDefinition shutdownMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.VOID).setName("shutdown").setBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(stubVarExpr).setMethodName("shutdown").build()))).build();
        methods.add(shutdownMethod);
        MethodDefinition isShutdownMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.BOOLEAN).setName("isShutdown").setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(stubVarExpr).setMethodName("isShutdown").setReturnType(TypeNode.BOOLEAN).build()).build();
        methods.add(isShutdownMethod);
        MethodDefinition isTerminatedMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.BOOLEAN).setName("isTerminated").setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(stubVarExpr).setMethodName("isTerminated").setReturnType(TypeNode.BOOLEAN).build()).build();
        methods.add(isTerminatedMethod);
        MethodDefinition shutdownNowMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.VOID).setName("shutdownNow").setBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(stubVarExpr).setMethodName("shutdownNow").build()))).build();
        methods.add(shutdownNowMethod);
        List<VariableExpr> arguments = Arrays.asList(VariableExpr.builder().setVariable(Variable.builder().setName("duration").setType(TypeNode.LONG).build()).build(), VariableExpr.builder().setVariable(Variable.builder().setName("unit").setType(typeStore.get("TimeUnit")).build()).build());
        MethodDefinition awaitTerminationMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.BOOLEAN).setName("awaitTermination").setArguments(arguments.stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setThrowsExceptions(Arrays.asList(typeStore.get("InterruptedException"))).setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(stubVarExpr).setMethodName("awaitTermination").setArguments(arguments.stream().map(v -> v).collect(Collectors.toList())).setReturnType(TypeNode.BOOLEAN).build()).build();
        methods.add(awaitTerminationMethod);
        return methods;
    }

    private static List<ClassDefinition> createNestedPagingClasses(Service service, Map<String, Message> messageTypes, TypeStore typeStore) {
        ArrayList<ClassDefinition> nestedClasses = new ArrayList<ClassDefinition>();
        for (Method method : service.methods()) {
            if (!method.isPaged()) continue;
            Message methodOutputMessage = messageTypes.get(method.outputType().reference().fullName());
            Field repeatedPagedResultsField = methodOutputMessage.findAndUnwrapPaginatedRepeatedField();
            Preconditions.checkNotNull(repeatedPagedResultsField, String.format("No repeated field found on message %s for method %s", methodOutputMessage.name(), method.name()));
            TypeNode repeatedResponseType = repeatedPagedResultsField.type();
            nestedClasses.add(AbstractServiceClientClassComposer.createNestedRpcPagedResponseClass(method, repeatedResponseType, messageTypes, typeStore));
            nestedClasses.add(AbstractServiceClientClassComposer.createNestedRpcPageClass(method, repeatedResponseType, messageTypes, typeStore));
            nestedClasses.add(AbstractServiceClientClassComposer.createNestedRpcFixedSizeCollectionClass(method, repeatedResponseType, messageTypes, typeStore));
        }
        return nestedClasses;
    }

    private static ClassDefinition createNestedRpcPagedResponseClass(Method method, TypeNode repeatedResponseType, Map<String, Message> messageTypes, TypeStore typeStore) {
        Preconditions.checkState(method.isPaged(), String.format("Expected method %s to be paged", method.name()));
        String className = String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, JavaStyle.toUpperCamelCase(method.name()));
        TypeNode thisClassType = typeStore.get(className);
        String upperJavaMethodName = JavaStyle.toUpperCamelCase(method.name());
        TypeNode methodPageType = typeStore.get(String.format("%sPage", upperJavaMethodName));
        TypeNode classExtendsType = TypeNode.withReference(ConcreteReference.builder().setClazz(AbstractPagedListResponse.class).setGenerics(Arrays.asList(method.inputType(), method.outputType(), repeatedResponseType, methodPageType, typeStore.get(String.format("%sFixedSizeCollection", upperJavaMethodName))).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
        VariableExpr contextVarExpr = VariableExpr.withVariable(Variable.builder().setName("context").setType(TypeNode.withReference(ConcreteReference.builder().setClazz(PageContext.class).setGenerics(Arrays.asList(method.inputType(), method.outputType(), repeatedResponseType).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build())).build());
        VariableExpr futureResponseVarExpr = VariableExpr.withVariable(Variable.builder().setName("futureResponse").setType(TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFuture.class).setGenerics(Arrays.asList(method.outputType().reference())).build())).build());
        VariableExpr futurePageVarExpr = VariableExpr.withVariable(Variable.builder().setName("futurePage").setType(TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFuture.class).setGenerics(Arrays.asList(methodPageType.reference())).build())).build());
        MethodInvocationExpr createPageAsyncExpr = MethodInvocationExpr.builder().setStaticReferenceType(methodPageType).setMethodName("createEmptyPage").build();
        createPageAsyncExpr = MethodInvocationExpr.builder().setExprReferenceExpr(createPageAsyncExpr).setMethodName("createPageAsync").setArguments(contextVarExpr, futureResponseVarExpr).setReturnType(futurePageVarExpr.type()).build();
        AssignmentExpr futurePageAssignExpr = AssignmentExpr.builder().setVariableExpr(futurePageVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(createPageAsyncExpr).build();
        VariableExpr inputVarExpr = VariableExpr.withVariable(Variable.builder().setName("input").setType(methodPageType).build());
        LambdaExpr pageToTransformExpr = LambdaExpr.builder().setArguments(inputVarExpr.toBuilder().setIsDecl(true).build()).setReturnExpr(NewObjectExpr.builder().setType(thisClassType).setArguments(inputVarExpr).build()).build();
        TypeNode returnType = TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFuture.class).setGenerics(Arrays.asList(typeStore.get(className).reference())).build());
        MethodInvocationExpr returnExpr = MethodInvocationExpr.builder().setStaticReferenceType(typeStore.get("ApiFutures")).setMethodName("transform").setArguments(futurePageVarExpr, pageToTransformExpr, MethodInvocationExpr.builder().setStaticReferenceType(typeStore.get("MoreExecutors")).setMethodName("directExecutor").build()).setReturnType(returnType).build();
        MethodDefinition createAsyncMethod = MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName("createAsync").setArguments(Arrays.asList(contextVarExpr, futureResponseVarExpr).stream().map(e -> e.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setBody(Arrays.asList(ExprStatement.withExpr(futurePageAssignExpr))).setReturnExpr(returnExpr).build();
        VariableExpr pageVarExpr = VariableExpr.withVariable(Variable.builder().setName("page").setType(methodPageType).build());
        MethodDefinition privateCtor = MethodDefinition.constructorBuilder().setScope(ScopeNode.PRIVATE).setReturnType(thisClassType).setArguments(pageVarExpr.toBuilder().setIsDecl(true).build()).setBody(Arrays.asList(ExprStatement.withExpr(ReferenceConstructorExpr.superBuilder().setType(methodPageType).setArguments(pageVarExpr, MethodInvocationExpr.builder().setStaticReferenceType(typeStore.get(String.format("%sFixedSizeCollection", upperJavaMethodName))).setMethodName("createEmptyCollection").build()).build()))).build();
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.add(createAsyncMethod);
        javaMethods.add(privateCtor);
        return ClassDefinition.builder().setIsNested(true).setScope(ScopeNode.PUBLIC).setIsStatic(true).setExtendsType(classExtendsType).setName(className).setMethods(javaMethods).build();
    }

    private static ClassDefinition createNestedRpcPageClass(Method method, TypeNode repeatedResponseType, Map<String, Message> messageTypes, TypeStore typeStore) {
        Preconditions.checkState(method.isPaged(), String.format("Expected method %s to be paged", method.name()));
        String upperJavaMethodName = JavaStyle.toUpperCamelCase(method.name());
        String className = String.format("%sPage", upperJavaMethodName);
        TypeNode classType = typeStore.get(className);
        TypeNode classExtendsType = TypeNode.withReference(ConcreteReference.builder().setClazz(AbstractPage.class).setGenerics(Arrays.asList(method.inputType(), method.outputType(), repeatedResponseType, classType).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
        VariableExpr contextVarExpr = VariableExpr.withVariable(Variable.builder().setName("context").setType(TypeNode.withReference(ConcreteReference.builder().setClazz(PageContext.class).setGenerics(Arrays.asList(method.inputType(), method.outputType(), repeatedResponseType).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build())).build());
        VariableExpr responseVarExpr = VariableExpr.withVariable(Variable.builder().setName("response").setType(method.outputType()).build());
        MethodDefinition privateCtor = MethodDefinition.constructorBuilder().setScope(ScopeNode.PRIVATE).setReturnType(classType).setArguments(Arrays.asList(contextVarExpr, responseVarExpr).stream().map(e -> e.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setBody(Arrays.asList(ExprStatement.withExpr(ReferenceConstructorExpr.superBuilder().setType(classExtendsType).setArguments(contextVarExpr, responseVarExpr).build()))).build();
        ValueExpr nullExpr = ValueExpr.createNullExpr();
        MethodDefinition createEmptyPageMethod = MethodDefinition.builder().setScope(ScopeNode.PRIVATE).setIsStatic(true).setReturnType(classType).setName("createEmptyPage").setReturnExpr(NewObjectExpr.builder().setType(classType).setArguments(nullExpr, nullExpr).build()).build();
        MethodDefinition createPageMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PROTECTED).setReturnType(classType).setName("createPage").setArguments(Arrays.asList(contextVarExpr, responseVarExpr).stream().map(e -> e.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setReturnExpr(NewObjectExpr.builder().setType(classType).setArguments(contextVarExpr, responseVarExpr).build()).build();
        Function<TypeNode, TypeNode> futureTypeFn = t2 -> TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFuture.class).setGenerics(Arrays.asList(t2.reference())).build());
        VariableExpr futureResponseVarExpr = VariableExpr.withVariable(Variable.builder().setName("futureResponse").setType(futureTypeFn.apply(method.outputType())).build());
        TypeNode futurePageType = futureTypeFn.apply(classType);
        MethodDefinition createPageAsyncMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(futurePageType).setName("createPageAsync").setArguments(Arrays.asList(contextVarExpr, futureResponseVarExpr).stream().map(e -> e.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(ValueExpr.withValue(SuperObjectValue.withType(classExtendsType))).setMethodName("createPageAsync").setArguments(contextVarExpr, futureResponseVarExpr).setReturnType(futurePageType).build()).build();
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.add(privateCtor);
        javaMethods.add(createEmptyPageMethod);
        javaMethods.add(createPageMethod);
        javaMethods.add(createPageAsyncMethod);
        return ClassDefinition.builder().setIsNested(true).setScope(ScopeNode.PUBLIC).setIsStatic(true).setExtendsType(classExtendsType).setName(className).setMethods(javaMethods).build();
    }

    private static ClassDefinition createNestedRpcFixedSizeCollectionClass(Method method, TypeNode repeatedResponseType, Map<String, Message> messageTypes, TypeStore typeStore) {
        String upperJavaMethodName = JavaStyle.toUpperCamelCase(method.name());
        String className = String.format("%sFixedSizeCollection", upperJavaMethodName);
        TypeNode classType = typeStore.get(className);
        TypeNode methodPageType = typeStore.get(String.format("%sPage", upperJavaMethodName));
        TypeNode classExtendsType = TypeNode.withReference(ConcreteReference.builder().setClazz(AbstractFixedSizeCollection.class).setGenerics(Arrays.asList(method.inputType(), method.outputType(), repeatedResponseType, methodPageType, classType).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
        VariableExpr pagesVarExpr = VariableExpr.withVariable(Variable.builder().setName("pages").setType(TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(methodPageType.reference())).build())).build());
        VariableExpr collectionSizeVarExpr = VariableExpr.withVariable(Variable.builder().setName("collectionSize").setType(TypeNode.INT).build());
        MethodDefinition privateCtor = MethodDefinition.constructorBuilder().setScope(ScopeNode.PRIVATE).setReturnType(classType).setArguments(Arrays.asList(pagesVarExpr, collectionSizeVarExpr).stream().map(e -> e.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setBody(Arrays.asList(ExprStatement.withExpr(ReferenceConstructorExpr.superBuilder().setType(classExtendsType).setArguments(pagesVarExpr, collectionSizeVarExpr).build()))).build();
        MethodDefinition createEmptyCollectionMethod = MethodDefinition.builder().setScope(ScopeNode.PRIVATE).setIsStatic(true).setReturnType(classType).setName("createEmptyCollection").setReturnExpr(NewObjectExpr.builder().setType(classType).setArguments(ValueExpr.createNullExpr(), ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("0").build())).build()).build();
        MethodDefinition createCollectionMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PROTECTED).setReturnType(classType).setName("createCollection").setArguments(Arrays.asList(pagesVarExpr, collectionSizeVarExpr).stream().map(e -> e.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setReturnExpr(NewObjectExpr.builder().setType(classType).setArguments(pagesVarExpr, collectionSizeVarExpr).build()).build();
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.add(privateCtor);
        javaMethods.add(createEmptyCollectionMethod);
        javaMethods.add(createCollectionMethod);
        return ClassDefinition.builder().setIsNested(true).setScope(ScopeNode.PUBLIC).setIsStatic(true).setExtendsType(classExtendsType).setName(className).setMethods(javaMethods).build();
    }

    @VisibleForTesting
    static Expr createRequestBuilderExpr(Method method, List<MethodArgument> signature, TypeStore typeStore) {
        TypeNode methodInputType = method.inputType();
        Expr newBuilderExpr = MethodInvocationExpr.builder().setMethodName("newBuilder").setStaticReferenceType(methodInputType).build();
        ArrayList<Field> rootFields = new ArrayList<Field>();
        HashMap<Field, Trie> rootFieldToTrie = new HashMap<Field, Trie>();
        for (MethodArgument arg : signature) {
            Field rootField;
            Field field2 = rootField = arg.nestedFields().isEmpty() ? arg.field() : (Field)arg.nestedFields().get(0);
            if (!rootFields.contains(rootField)) {
                rootFields.add(rootField);
            }
            Trie updatedTrie = rootFieldToTrie.containsKey(rootField) ? (Trie)rootFieldToTrie.get(rootField) : new Trie();
            ArrayList<Field> nestedFieldsWithChild = new ArrayList<Field>(arg.nestedFields());
            nestedFieldsWithChild.add(arg.field());
            updatedTrie.insert(nestedFieldsWithChild);
            rootFieldToTrie.put(rootField, updatedTrie);
        }
        Function<Field, Expr> parentPreprocFn = field -> MethodInvocationExpr.builder().setStaticReferenceType(field.type()).setMethodName("newBuilder").build();
        TriFunction<Field, Expr, Expr, Expr> parentPostprocFn = (field, baseRefExpr, leafProcessedExpr) -> {
            boolean isRootNode = field == null;
            return isRootNode ? leafProcessedExpr : MethodInvocationExpr.builder().setExprReferenceExpr((Expr)baseRefExpr).setMethodName(String.format("set%s", JavaStyle.toUpperCamelCase(field.name()))).setArguments(MethodInvocationExpr.builder().setExprReferenceExpr((Expr)leafProcessedExpr).setMethodName("build").build()).build();
        };
        Map<Field, MethodArgument> fieldToMethodArg = signature.stream().collect(Collectors.toMap(a -> a.field(), a -> a));
        BiFunction<Field, Expr, Expr> leafProcFn = (field, parentBaseRefExpr) -> AbstractServiceClientClassComposer.buildNestedSetterInvocationExpr((MethodArgument)fieldToMethodArg.get(field), parentBaseRefExpr);
        for (Field rootField : rootFields) {
            newBuilderExpr = ((Trie)rootFieldToTrie.get(rootField)).dfsTraverseAndReduce(parentPreprocFn, parentPostprocFn, leafProcFn, newBuilderExpr);
        }
        return MethodInvocationExpr.builder().setExprReferenceExpr(newBuilderExpr).setMethodName("build").setReturnType(methodInputType).build();
    }

    @VisibleForTesting
    static MethodInvocationExpr buildNestedSetterInvocationExpr(MethodArgument argument, Expr referenceExpr) {
        String argumentName = JavaStyle.toLowerCamelCase(argument.name());
        TypeNode argumentType = argument.type();
        Expr argVarExpr = VariableExpr.withVariable(Variable.builder().setName(argumentName).setType(argumentType).build());
        if (argument.isResourceNameHelper()) {
            ValueExpr nullExpr = ValueExpr.createNullExpr();
            RelationalOperationExpr isNullCheckExpr = RelationalOperationExpr.equalToWithExprs(argVarExpr, nullExpr);
            MethodInvocationExpr toStringExpr = MethodInvocationExpr.builder().setExprReferenceExpr(argVarExpr).setMethodName("toString").setReturnType(TypeNode.STRING).build();
            argVarExpr = TernaryExpr.builder().setConditionExpr(isNullCheckExpr).setThenExpr(nullExpr).setElseExpr(toStringExpr).build();
        }
        String setterMethodName = String.format(AbstractServiceClientClassComposer.typeToSetterMethodName(argumentType), JavaStyle.toUpperCamelCase(argumentName));
        return MethodInvocationExpr.builder().setExprReferenceExpr(referenceExpr).setMethodName(setterMethodName).setArguments(argVarExpr).build();
    }

    private static String typeToSetterMethodName(TypeNode type) {
        String setterMethodVariantPattern = "set%s";
        if (TypeNode.isReferenceType(type)) {
            if (LIST_REFERENCE.isSupertypeOrEquals(type.reference())) {
                setterMethodVariantPattern = "addAll%s";
            } else if (MAP_REFERENCE.isSupertypeOrEquals(type.reference())) {
                setterMethodVariantPattern = "putAll%s";
            }
        }
        return setterMethodVariantPattern;
    }

    private static TypeStore createTypes(Service service, Map<String, Message> messageTypes) {
        List<Class<?>> concreteClazzes = Arrays.asList(AbstractPagedListResponse.class, ApiFunction.class, ApiFuture.class, ApiFutures.class, BackgroundResource.class, BetaApi.class, BidiStreamingCallable.class, ClientStreamingCallable.class, Generated.class, InterruptedException.class, IOException.class, MoreExecutors.class, Objects.class, Operation.class, OperationFuture.class, OperationCallable.class, ServerStreamingCallable.class, Status.class, Strings.class, TimeUnit.class, UnaryCallable.class);
        TypeStore typeStore = new TypeStore(concreteClazzes);
        AbstractServiceClientClassComposer.createVaporTypes(service, typeStore);
        return typeStore;
    }

    private static void createVaporTypes(Service service, TypeStore typeStore) {
        typeStore.putAll(String.format("%s.stub", service.pakkage()), Arrays.asList(ClassNames.getServiceStubClassName(service), ClassNames.getServiceStubSettingsClassName(service)));
        typeStore.putAll(service.pakkage(), Arrays.asList(ClassNames.getServiceClientClassName(service), ClassNames.getServiceSettingsClassName(service)));
        for (Method method : service.methods()) {
            if (!method.isPaged()) continue;
            typeStore.putAll(service.pakkage(), Arrays.asList(PAGED_RESPONSE_TYPE_NAME_PATTERN, "%sPage", "%sFixedSizeCollection").stream().map(p -> String.format(p, JavaStyle.toUpperCamelCase(method.name()))).collect(Collectors.toList()), true, ClassNames.getServiceClientClassName(service));
        }
        typeStore.putAll(service.pakkage(), service.methods().stream().filter(m4 -> m4.isPaged()).map(m4 -> String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, m4.name())).collect(Collectors.toList()), true, ClassNames.getServiceClientClassName(service));
    }

    private static List<Reference> getGenericsForCallable(CallableMethodKind kind, Method method, TypeStore typeStore) {
        if (kind.equals((Object)CallableMethodKind.LRO)) {
            return Arrays.asList(method.inputType().reference(), method.lro().responseType().reference(), method.lro().metadataType().reference());
        }
        if (kind.equals((Object)CallableMethodKind.PAGED)) {
            return Arrays.asList(method.inputType().reference(), typeStore.get(String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, method.name())).reference());
        }
        return Arrays.asList(method.inputType().reference(), method.outputType().reference());
    }

    private static String getCallableName(CallableMethodKind kind, String rawMethodName) {
        if (kind.equals((Object)CallableMethodKind.LRO)) {
            return String.format(OPERATION_CALLABLE_NAME_PATTERN, rawMethodName);
        }
        if (kind.equals((Object)CallableMethodKind.PAGED)) {
            return String.format(PAGED_CALLABLE_NAME_PATTERN, rawMethodName);
        }
        return String.format(CALLABLE_NAME_PATTERN, rawMethodName);
    }

    private static boolean isProtoEmptyType(TypeNode type) {
        return type.reference().pakkage().equals("com.google.protobuf") && type.reference().name().equals("Empty");
    }

    private static void updateGapicMetadata(GapicContext context, Service service, String clientClassName, Map<String, List<String>> grpcRpcToJavaMethodNames) {
        GapicMetadata.Builder metadataBuilder = context.gapicMetadata().toBuilder();
        metadataBuilder = metadataBuilder.setProtoPackage(service.protoPakkage()).setLibraryPackage(service.pakkage());
        GapicMetadata.ServiceAsClient.Builder serviceClientProtoBuilder = GapicMetadata.ServiceAsClient.newBuilder().setLibraryClient(clientClassName);
        ArrayList<String> sortedRpcNames = new ArrayList<String>(grpcRpcToJavaMethodNames.keySet());
        Collections.sort(sortedRpcNames);
        for (String rpcName : sortedRpcNames) {
            GapicMetadata.MethodList methodList = GapicMetadata.MethodList.newBuilder().addAllMethods((Iterable<String>)grpcRpcToJavaMethodNames.get(rpcName)).build();
            serviceClientProtoBuilder.putRpcs(rpcName, methodList);
        }
        metadataBuilder = metadataBuilder.putServices(service.name(), GapicMetadata.ServiceForTransport.newBuilder().putClients("grpc", serviceClientProtoBuilder.build()).build());
        context.updateGapicMetadata(metadataBuilder.build());
    }

    private static enum CallableMethodKind {
        REGULAR,
        LRO,
        PAGED;

    }
}

