/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.InternalServerInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.SynchronizationContext;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.xds.AutoValue_XdsServerWrapper_ServerRoutingConfig;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.Filter;
import io.grpc.xds.FilterChainMatchingProtocolNegotiators;
import io.grpc.xds.FilterChainSelectorManager;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.RoutingUtils;
import io.grpc.xds.ThreadSafeRandom;
import io.grpc.xds.VirtualHost;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsListenerResource;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.XdsRouteConfigureResource;
import io.grpc.xds.XdsServerBuilder;
import io.grpc.xds.internal.security.SslContextProviderSupplier;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class XdsServerWrapper
extends Server {
    private static final Logger logger = Logger.getLogger(XdsServerWrapper.class.getName());
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t2, Throwable e) {
            logger.log(Level.SEVERE, "Exception!" + e);
        }
    });
    public static final Attributes.Key<AtomicReference<ServerRoutingConfig>> ATTR_SERVER_ROUTING_CONFIG = Attributes.Key.create("io.grpc.xds.ServerWrapper.serverRoutingConfig");
    @VisibleForTesting
    static final long RETRY_DELAY_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private final String listenerAddress;
    private final ServerBuilder<?> delegateBuilder;
    private boolean sharedTimeService;
    private final ScheduledExecutorService timeService;
    private final FilterRegistry filterRegistry;
    private final ThreadSafeRandom random = ThreadSafeRandom.ThreadSafeRandomImpl.instance;
    private final XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory;
    private final XdsServerBuilder.XdsServingStatusListener listener;
    private final FilterChainSelectorManager filterChainSelectorManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean isServing;
    private final CountDownLatch internalTerminationLatch = new CountDownLatch(1);
    private final SettableFuture<Exception> initialStartFuture = SettableFuture.create();
    private boolean initialStarted;
    private SynchronizationContext.ScheduledHandle restartTimer;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private DiscoveryState discoveryState;
    private volatile Server delegate;

    XdsServerWrapper(String listenerAddress, ServerBuilder<?> delegateBuilder, XdsServerBuilder.XdsServingStatusListener listener, FilterChainSelectorManager filterChainSelectorManager, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory, FilterRegistry filterRegistry) {
        this(listenerAddress, delegateBuilder, listener, filterChainSelectorManager, xdsClientPoolFactory, filterRegistry, SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE));
        this.sharedTimeService = true;
    }

    @VisibleForTesting
    XdsServerWrapper(String listenerAddress, ServerBuilder<?> delegateBuilder, XdsServerBuilder.XdsServingStatusListener listener, FilterChainSelectorManager filterChainSelectorManager, XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory, FilterRegistry filterRegistry, ScheduledExecutorService timeService) {
        this.listenerAddress = Preconditions.checkNotNull(listenerAddress, "listenerAddress");
        this.delegateBuilder = Preconditions.checkNotNull(delegateBuilder, "delegateBuilder");
        this.delegateBuilder.intercept(new ConfigApplyingInterceptor());
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.filterChainSelectorManager = Preconditions.checkNotNull(filterChainSelectorManager, "filterChainSelectorManager");
        this.xdsClientPoolFactory = Preconditions.checkNotNull(xdsClientPoolFactory, "xdsClientPoolFactory");
        this.timeService = Preconditions.checkNotNull(timeService, "timeService");
        this.filterRegistry = Preconditions.checkNotNull(filterRegistry, "filterRegistry");
        this.delegate = delegateBuilder.build();
    }

    @Override
    public Server start() throws IOException {
        Exception exception;
        Preconditions.checkState(this.started.compareAndSet(false, true), "Already started");
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                XdsServerWrapper.this.internalStart();
            }
        });
        try {
            exception = (Exception)this.initialStartFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (exception != null) {
            throw exception instanceof IOException ? (IOException)exception : new IOException(exception);
        }
        return this;
    }

    private void internalStart() {
        try {
            this.xdsClientPool = this.xdsClientPoolFactory.getOrCreate();
        }
        catch (Exception e) {
            StatusException statusException = Status.UNAVAILABLE.withDescription("Failed to initialize xDS").withCause(e).asException();
            this.listener.onNotServing(statusException);
            this.initialStartFuture.set(statusException);
            return;
        }
        this.xdsClient = this.xdsClientPool.getObject();
        String listenerTemplate = this.xdsClient.getBootstrapInfo().serverListenerResourceNameTemplate();
        if (listenerTemplate == null) {
            StatusException statusException = Status.UNAVAILABLE.withDescription("Can only support xDS v3 with listener resource name template").asException();
            this.listener.onNotServing(statusException);
            this.initialStartFuture.set(statusException);
            this.xdsClient = this.xdsClientPool.returnObject(this.xdsClient);
            return;
        }
        String replacement = this.listenerAddress;
        if (listenerTemplate.startsWith("xdstp:")) {
            replacement = XdsClient.percentEncodePath(replacement);
        }
        this.discoveryState = new DiscoveryState(listenerTemplate.replaceAll("%s", replacement));
    }

    @Override
    public Server shutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!XdsServerWrapper.this.delegate.isShutdown()) {
                    XdsServerWrapper.this.delegate.shutdown();
                }
                XdsServerWrapper.this.internalShutdown();
            }
        });
        return this;
    }

    @Override
    public Server shutdownNow() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!XdsServerWrapper.this.delegate.isShutdown()) {
                    XdsServerWrapper.this.delegate.shutdownNow();
                }
                XdsServerWrapper.this.internalShutdown();
                XdsServerWrapper.this.initialStartFuture.set(new IOException("server is forcefully shut down"));
            }
        });
        return this;
    }

    private void internalShutdown() {
        logger.log(Level.FINER, "Shutting down XdsServerWrapper");
        if (this.discoveryState != null) {
            this.discoveryState.shutdown();
        }
        if (this.xdsClient != null) {
            this.xdsClient = this.xdsClientPool.returnObject(this.xdsClient);
        }
        if (this.restartTimer != null) {
            this.restartTimer.cancel();
        }
        if (this.sharedTimeService) {
            SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timeService);
        }
        this.isServing = false;
        this.internalTerminationLatch.countDown();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.internalTerminationLatch.getCount() == 0L && this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        if (!this.internalTerminationLatch.await(timeout, unit)) {
            return false;
        }
        long remainingTime = unit.toNanos(timeout) - (System.nanoTime() - startTime);
        return this.delegate.awaitTermination(remainingTime, TimeUnit.NANOSECONDS);
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        this.internalTerminationLatch.await();
        this.delegate.awaitTermination();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public List<? extends SocketAddress> getListenSockets() {
        return this.delegate.getListenSockets();
    }

    @Override
    public List<ServerServiceDefinition> getServices() {
        return this.delegate.getServices();
    }

    @Override
    public List<ServerServiceDefinition> getImmutableServices() {
        return this.delegate.getImmutableServices();
    }

    @Override
    public List<ServerServiceDefinition> getMutableServices() {
        return this.delegate.getMutableServices();
    }

    private void startDelegateServer() {
        if (this.restartTimer != null && this.restartTimer.isPending()) {
            return;
        }
        if (this.isServing) {
            return;
        }
        if (this.delegate.isShutdown()) {
            this.delegate = this.delegateBuilder.build();
        }
        try {
            this.delegate.start();
            this.listener.onServing();
            this.isServing = true;
            if (!this.initialStarted) {
                this.initialStarted = true;
                this.initialStartFuture.set(null);
            }
            logger.log(Level.FINER, "Delegate server started.");
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Fail to start delegate server: {0}", e);
            if (!this.initialStarted) {
                this.initialStarted = true;
                this.initialStartFuture.set(e);
            } else {
                this.listener.onNotServing(e);
            }
            this.restartTimer = this.syncContext.schedule(new RestartTask(), RETRY_DELAY_NANOS, TimeUnit.NANOSECONDS, this.timeService);
        }
    }

    @AutoValue
    static abstract class ServerRoutingConfig {
        @VisibleForTesting
        static final ServerRoutingConfig FAILING_ROUTING_CONFIG = ServerRoutingConfig.create(ImmutableList.of(), ImmutableMap.of());

        ServerRoutingConfig() {
        }

        abstract ImmutableList<VirtualHost> virtualHosts();

        abstract ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors();

        public static ServerRoutingConfig create(ImmutableList<VirtualHost> virtualHosts, ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors) {
            Preconditions.checkNotNull(virtualHosts, "virtualHosts");
            Preconditions.checkNotNull(interceptors, "interceptors");
            return new AutoValue_XdsServerWrapper_ServerRoutingConfig(virtualHosts, interceptors);
        }
    }

    @VisibleForTesting
    final class ConfigApplyingInterceptor
    implements ServerInterceptor {
        private final ServerInterceptor noopInterceptor = new ServerInterceptor(){

            @Override
            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall(call, headers);
            }
        };

        ConfigApplyingInterceptor() {
        }

        @Override
        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            ServerRoutingConfig routingConfig;
            AtomicReference<ServerRoutingConfig> routingConfigRef = call.getAttributes().get(ATTR_SERVER_ROUTING_CONFIG);
            ServerRoutingConfig serverRoutingConfig = routingConfig = routingConfigRef == null ? null : routingConfigRef.get();
            if (routingConfig == null || routingConfig == ServerRoutingConfig.FAILING_ROUTING_CONFIG) {
                String errorMsg = "Missing or broken xDS routing config: RDS config unavailable.";
                call.close(Status.UNAVAILABLE.withDescription(errorMsg), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            ImmutableList<VirtualHost> virtualHosts = routingConfig.virtualHosts();
            VirtualHost virtualHost = RoutingUtils.findVirtualHostForHostName(virtualHosts, call.getAuthority());
            if (virtualHost == null) {
                call.close(Status.UNAVAILABLE.withDescription("Could not find xDS virtual host matching RPC"), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            VirtualHost.Route selectedRoute = null;
            MethodDescriptor<ReqT, RespT> method = call.getMethodDescriptor();
            for (VirtualHost.Route route : virtualHost.routes()) {
                if (!RoutingUtils.matchRoute(route.routeMatch(), "/" + method.getFullMethodName(), headers, XdsServerWrapper.this.random)) continue;
                selectedRoute = route;
                break;
            }
            if (selectedRoute == null) {
                call.close(Status.UNAVAILABLE.withDescription("Could not find xDS route matching RPC"), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            if (selectedRoute.routeAction() != null) {
                call.close(Status.UNAVAILABLE.withDescription("Invalid xDS route action for matching route: only Route.non_forwarding_action should be allowed."), new Metadata());
                return new ServerCall.Listener<ReqT>(){};
            }
            ServerInterceptor routeInterceptor = this.noopInterceptor;
            ImmutableMap<VirtualHost.Route, ServerInterceptor> perRouteInterceptors = routingConfig.interceptors();
            if (perRouteInterceptors != null && perRouteInterceptors.get(selectedRoute) != null) {
                routeInterceptor = (ServerInterceptor)perRouteInterceptors.get(selectedRoute);
            }
            return routeInterceptor.interceptCall(call, headers, next);
        }
    }

    private final class DiscoveryState
    implements XdsClient.ResourceWatcher<XdsListenerResource.LdsUpdate> {
        private final String resourceName;
        private final Map<String, RouteDiscoveryState> routeDiscoveryStates = new HashMap<String, RouteDiscoveryState>();
        private final Set<String> pendingRds = new HashSet<String>();
        private List<EnvoyServerProtoData.FilterChain> filterChains = new ArrayList<EnvoyServerProtoData.FilterChain>();
        @Nullable
        private EnvoyServerProtoData.FilterChain defaultFilterChain;
        private boolean stopped;
        private final Map<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>> savedRdsRoutingConfigRef = new HashMap<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>>();
        private final ServerInterceptor noopInterceptor = new ServerInterceptor(){

            @Override
            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall(call, headers);
            }
        };

        private DiscoveryState(String resourceName) {
            this.resourceName = Preconditions.checkNotNull(resourceName, "resourceName");
            XdsServerWrapper.this.xdsClient.watchXdsResource(XdsListenerResource.getInstance(), resourceName, this, XdsServerWrapper.this.syncContext);
        }

        @Override
        public void onChanged(XdsListenerResource.LdsUpdate update) {
            if (this.stopped) {
                return;
            }
            logger.log(Level.FINEST, "Received Lds update {0}", update);
            Preconditions.checkNotNull(update.listener(), "update");
            if (!this.pendingRds.isEmpty()) {
                this.releaseSuppliersInFlight();
                this.pendingRds.clear();
            }
            this.filterChains = update.listener().filterChains();
            this.defaultFilterChain = update.listener().defaultFilterChain();
            List<EnvoyServerProtoData.FilterChain> allFilterChains = this.filterChains;
            if (this.defaultFilterChain != null) {
                allFilterChains = new ArrayList<EnvoyServerProtoData.FilterChain>(this.filterChains);
                allFilterChains.add(this.defaultFilterChain);
            }
            HashSet<String> allRds = new HashSet<String>();
            for (EnvoyServerProtoData.FilterChain filterChain : allFilterChains) {
                HttpConnectionManager hcm = filterChain.httpConnectionManager();
                if (hcm.virtualHosts() != null) continue;
                RouteDiscoveryState rdsState = this.routeDiscoveryStates.get(hcm.rdsName());
                if (rdsState == null) {
                    rdsState = new RouteDiscoveryState(hcm.rdsName());
                    this.routeDiscoveryStates.put(hcm.rdsName(), rdsState);
                    XdsServerWrapper.this.xdsClient.watchXdsResource(XdsRouteConfigureResource.getInstance(), hcm.rdsName(), rdsState, XdsServerWrapper.this.syncContext);
                }
                if (rdsState.isPending) {
                    this.pendingRds.add(hcm.rdsName());
                }
                allRds.add(hcm.rdsName());
            }
            for (Map.Entry entry : this.routeDiscoveryStates.entrySet()) {
                if (allRds.contains(entry.getKey())) continue;
                XdsServerWrapper.this.xdsClient.cancelXdsResourceWatch(XdsRouteConfigureResource.getInstance(), (String)entry.getKey(), (XdsClient.ResourceWatcher)entry.getValue());
            }
            this.routeDiscoveryStates.keySet().retainAll(allRds);
            if (this.pendingRds.isEmpty()) {
                this.updateSelector();
            }
        }

        @Override
        public void onResourceDoesNotExist(String resourceName) {
            if (this.stopped) {
                return;
            }
            StatusException statusException = Status.UNAVAILABLE.withDescription("Listener " + resourceName + " unavailable").asException();
            this.handleConfigNotFound(statusException);
        }

        @Override
        public void onError(Status error) {
            if (this.stopped) {
                return;
            }
            logger.log(Level.FINE, "Error from XdsClient", error);
            if (!XdsServerWrapper.this.isServing) {
                XdsServerWrapper.this.listener.onNotServing(error.asException());
            }
        }

        private void shutdown() {
            this.stopped = true;
            this.cleanUpRouteDiscoveryStates();
            logger.log(Level.FINE, "Stop watching LDS resource {0}", this.resourceName);
            XdsServerWrapper.this.xdsClient.cancelXdsResourceWatch(XdsListenerResource.getInstance(), this.resourceName, this);
            List<SslContextProviderSupplier> toRelease = this.getSuppliersInUse();
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector.NO_FILTER_CHAIN);
            for (SslContextProviderSupplier s2 : toRelease) {
                s2.close();
            }
            this.releaseSuppliersInFlight();
        }

        private void updateSelector() {
            HashMap<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>> filterChainRouting = new HashMap<EnvoyServerProtoData.FilterChain, AtomicReference<ServerRoutingConfig>>();
            this.savedRdsRoutingConfigRef.clear();
            for (EnvoyServerProtoData.FilterChain filterChain : this.filterChains) {
                filterChainRouting.put(filterChain, this.generateRoutingConfig(filterChain));
            }
            FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector selector = new FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector(Collections.unmodifiableMap(filterChainRouting), this.defaultFilterChain == null ? null : this.defaultFilterChain.sslContextProviderSupplier(), this.defaultFilterChain == null ? new AtomicReference() : this.generateRoutingConfig(this.defaultFilterChain));
            List<SslContextProviderSupplier> toRelease = this.getSuppliersInUse();
            logger.log(Level.FINEST, "Updating selector {0}", selector);
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(selector);
            for (SslContextProviderSupplier e : toRelease) {
                e.close();
            }
            XdsServerWrapper.this.startDelegateServer();
        }

        private AtomicReference<ServerRoutingConfig> generateRoutingConfig(EnvoyServerProtoData.FilterChain filterChain) {
            HttpConnectionManager hcm = filterChain.httpConnectionManager();
            if (hcm.virtualHosts() != null) {
                ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors = this.generatePerRouteInterceptors(hcm.httpFilterConfigs(), hcm.virtualHosts());
                return new AtomicReference<ServerRoutingConfig>(ServerRoutingConfig.create(hcm.virtualHosts(), interceptors));
            }
            RouteDiscoveryState rds = this.routeDiscoveryStates.get(hcm.rdsName());
            Preconditions.checkNotNull(rds, "rds");
            AtomicReference<ServerRoutingConfig> serverRoutingConfigRef = new AtomicReference<ServerRoutingConfig>();
            if (rds.savedVirtualHosts != null) {
                ImmutableMap<VirtualHost.Route, ServerInterceptor> interceptors = this.generatePerRouteInterceptors(hcm.httpFilterConfigs(), rds.savedVirtualHosts);
                ServerRoutingConfig serverRoutingConfig = ServerRoutingConfig.create(rds.savedVirtualHosts, interceptors);
                serverRoutingConfigRef.set(serverRoutingConfig);
            } else {
                serverRoutingConfigRef.set(ServerRoutingConfig.FAILING_ROUTING_CONFIG);
            }
            this.savedRdsRoutingConfigRef.put(filterChain, serverRoutingConfigRef);
            return serverRoutingConfigRef;
        }

        private ImmutableMap<VirtualHost.Route, ServerInterceptor> generatePerRouteInterceptors(List<Filter.NamedFilterConfig> namedFilterConfigs, List<VirtualHost> virtualHosts) {
            ImmutableMap.Builder<VirtualHost.Route, ServerInterceptor> perRouteInterceptors = new ImmutableMap.Builder<VirtualHost.Route, ServerInterceptor>();
            for (VirtualHost virtualHost : virtualHosts) {
                for (VirtualHost.Route route : virtualHost.routes()) {
                    ArrayList<ServerInterceptor> filterInterceptors = new ArrayList<ServerInterceptor>();
                    HashMap<String, Filter.FilterConfig> selectedOverrideConfigs = new HashMap<String, Filter.FilterConfig>(virtualHost.filterConfigOverrides());
                    selectedOverrideConfigs.putAll(route.filterConfigOverrides());
                    if (namedFilterConfigs != null) {
                        for (Filter.NamedFilterConfig namedFilterConfig : namedFilterConfigs) {
                            Filter.FilterConfig filterConfig = namedFilterConfig.filterConfig;
                            Filter filter = XdsServerWrapper.this.filterRegistry.get(filterConfig.typeUrl());
                            if (filter instanceof Filter.ServerInterceptorBuilder) {
                                ServerInterceptor interceptor = ((Filter.ServerInterceptorBuilder)((Object)filter)).buildServerInterceptor(filterConfig, (Filter.FilterConfig)selectedOverrideConfigs.get(namedFilterConfig.name));
                                if (interceptor == null) continue;
                                filterInterceptors.add(interceptor);
                                continue;
                            }
                            logger.log(Level.WARNING, "HttpFilterConfig(type URL: " + filterConfig.typeUrl() + ") is not supported on server-side. Probably a bug at ClientXdsClient verification.");
                        }
                    }
                    ServerInterceptor interceptor = this.combineInterceptors(filterInterceptors);
                    perRouteInterceptors.put(route, interceptor);
                }
            }
            return perRouteInterceptors.buildOrThrow();
        }

        private ServerInterceptor combineInterceptors(final List<ServerInterceptor> interceptors) {
            if (interceptors.isEmpty()) {
                return this.noopInterceptor;
            }
            if (interceptors.size() == 1) {
                return interceptors.get(0);
            }
            return new ServerInterceptor(){

                @Override
                public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                    for (int i = interceptors.size() - 1; i >= 0; --i) {
                        next = InternalServerInterceptors.interceptCallHandlerCreate((ServerInterceptor)interceptors.get(i), next);
                    }
                    return next.startCall(call, headers);
                }
            };
        }

        private void handleConfigNotFound(StatusException exception) {
            this.cleanUpRouteDiscoveryStates();
            List<SslContextProviderSupplier> toRelease = this.getSuppliersInUse();
            XdsServerWrapper.this.filterChainSelectorManager.updateSelector(FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector.NO_FILTER_CHAIN);
            for (SslContextProviderSupplier s2 : toRelease) {
                s2.close();
            }
            if (XdsServerWrapper.this.restartTimer != null) {
                XdsServerWrapper.this.restartTimer.cancel();
            }
            if (!XdsServerWrapper.this.delegate.isShutdown()) {
                XdsServerWrapper.this.delegate.shutdown();
            }
            XdsServerWrapper.this.isServing = false;
            XdsServerWrapper.this.listener.onNotServing(exception);
        }

        private void cleanUpRouteDiscoveryStates() {
            for (RouteDiscoveryState rdsState : this.routeDiscoveryStates.values()) {
                String rdsName = rdsState.resourceName;
                logger.log(Level.FINE, "Stop watching RDS resource {0}", rdsName);
                XdsServerWrapper.this.xdsClient.cancelXdsResourceWatch(XdsRouteConfigureResource.getInstance(), rdsName, rdsState);
            }
            this.routeDiscoveryStates.clear();
            this.savedRdsRoutingConfigRef.clear();
        }

        private List<SslContextProviderSupplier> getSuppliersInUse() {
            ArrayList<SslContextProviderSupplier> toRelease = new ArrayList<SslContextProviderSupplier>();
            FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector selector = XdsServerWrapper.this.filterChainSelectorManager.getSelectorToUpdateSelector();
            if (selector != null) {
                for (EnvoyServerProtoData.FilterChain f : selector.getRoutingConfigs().keySet()) {
                    if (f.sslContextProviderSupplier() == null) continue;
                    toRelease.add(f.sslContextProviderSupplier());
                }
                SslContextProviderSupplier defaultSupplier = selector.getDefaultSslContextProviderSupplier();
                if (defaultSupplier != null) {
                    toRelease.add(defaultSupplier);
                }
            }
            return toRelease;
        }

        private void releaseSuppliersInFlight() {
            SslContextProviderSupplier supplier;
            for (EnvoyServerProtoData.FilterChain filterChain : this.filterChains) {
                supplier = filterChain.sslContextProviderSupplier();
                if (supplier == null) continue;
                supplier.close();
            }
            if (this.defaultFilterChain != null && (supplier = this.defaultFilterChain.sslContextProviderSupplier()) != null) {
                supplier.close();
            }
        }

        private final class RouteDiscoveryState
        implements XdsClient.ResourceWatcher<XdsRouteConfigureResource.RdsUpdate> {
            private final String resourceName;
            private ImmutableList<VirtualHost> savedVirtualHosts;
            private boolean isPending = true;

            private RouteDiscoveryState(String resourceName) {
                this.resourceName = Preconditions.checkNotNull(resourceName, "resourceName");
            }

            @Override
            public void onChanged(final XdsRouteConfigureResource.RdsUpdate update) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(RouteDiscoveryState.this.resourceName)) {
                            return;
                        }
                        if (RouteDiscoveryState.this.savedVirtualHosts == null && !RouteDiscoveryState.this.isPending) {
                            logger.log(Level.WARNING, "Received valid Rds {0} configuration.", RouteDiscoveryState.this.resourceName);
                        }
                        RouteDiscoveryState.this.savedVirtualHosts = ImmutableList.copyOf(update.virtualHosts);
                        RouteDiscoveryState.this.updateRdsRoutingConfig();
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(resourceName)) {
                            return;
                        }
                        logger.log(Level.WARNING, "Rds {0} unavailable", resourceName);
                        RouteDiscoveryState.this.savedVirtualHosts = null;
                        RouteDiscoveryState.this.updateRdsRoutingConfig();
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                XdsServerWrapper.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!DiscoveryState.this.routeDiscoveryStates.containsKey(RouteDiscoveryState.this.resourceName)) {
                            return;
                        }
                        logger.log(Level.WARNING, "Error loading RDS resource {0} from XdsClient: {1}.", new Object[]{RouteDiscoveryState.this.resourceName, error});
                        RouteDiscoveryState.this.maybeUpdateSelector();
                    }
                });
            }

            private void updateRdsRoutingConfig() {
                for (EnvoyServerProtoData.FilterChain filterChain : DiscoveryState.this.savedRdsRoutingConfigRef.keySet()) {
                    ServerRoutingConfig updatedRoutingConfig;
                    if (!this.resourceName.equals(filterChain.httpConnectionManager().rdsName())) continue;
                    if (this.savedVirtualHosts == null) {
                        updatedRoutingConfig = ServerRoutingConfig.FAILING_ROUTING_CONFIG;
                    } else {
                        ImmutableMap updatedInterceptors = DiscoveryState.this.generatePerRouteInterceptors(filterChain.httpConnectionManager().httpFilterConfigs(), this.savedVirtualHosts);
                        updatedRoutingConfig = ServerRoutingConfig.create(this.savedVirtualHosts, updatedInterceptors);
                    }
                    logger.log(Level.FINEST, "Updating filter chain {0} rds routing config: {1}", new Object[]{filterChain.name(), updatedRoutingConfig});
                    ((AtomicReference)DiscoveryState.this.savedRdsRoutingConfigRef.get(filterChain)).set(updatedRoutingConfig);
                }
            }

            private void maybeUpdateSelector() {
                boolean isLastPending;
                this.isPending = false;
                boolean bl = isLastPending = DiscoveryState.this.pendingRds.remove(this.resourceName) && DiscoveryState.this.pendingRds.isEmpty();
                if (isLastPending) {
                    DiscoveryState.this.updateSelector();
                }
            }
        }
    }

    private final class RestartTask
    implements Runnable {
        private RestartTask() {
        }

        @Override
        public void run() {
            XdsServerWrapper.this.startDelegateServer();
        }
    }
}

