/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.FormatterDiagnostic;
import java.util.List;
import java.util.Locale;
import org.openjdk.javax.tools.Diagnostic;
import org.openjdk.javax.tools.JavaFileObject;

public final class FormatterException
extends Exception {
    private ImmutableList<FormatterDiagnostic> diagnostics;

    public FormatterException(String message) {
        this(FormatterDiagnostic.create(message));
    }

    public FormatterException(FormatterDiagnostic diagnostic) {
        this(ImmutableList.of(diagnostic));
    }

    public FormatterException(Iterable<FormatterDiagnostic> diagnostics) {
        super(diagnostics.iterator().next().toString());
        this.diagnostics = ImmutableList.copyOf(diagnostics);
    }

    public List<FormatterDiagnostic> diagnostics() {
        return this.diagnostics;
    }

    public static FormatterException fromJavacDiagnostics(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return new FormatterException(Iterables.transform(diagnostics, d -> FormatterException.toFormatterDiagnostic(d)));
    }

    private static FormatterDiagnostic toFormatterDiagnostic(Diagnostic<?> input) {
        return FormatterDiagnostic.create((int)input.getLineNumber(), (int)input.getColumnNumber(), input.getMessage(Locale.ENGLISH));
    }
}

