/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_VaporReference;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Reference;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@AutoValue
public abstract class VaporReference
implements Reference {
    private static final String DOT = ".";
    private static final String LEFT_ANGLE = "<";
    private static final String RIGHT_ANGLE = ">";
    private static final String COMMA = ", ";

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public abstract ImmutableList<Reference> generics();

    @Override
    public abstract String name();

    @Override
    public abstract String simpleName();

    @Override
    public abstract String pakkage();

    @Override
    public abstract boolean useFullName();

    @Override
    @Nullable
    public abstract ImmutableList<String> enclosingClassNames();

    @Nullable
    public abstract Reference supertypeReference();

    @Override
    @Nullable
    public Reference wildcardUpperBound() {
        return null;
    }

    @Override
    public String fullName() {
        if (this.hasEnclosingClass()) {
            return String.format("%s.%s.%s", this.pakkage(), String.join((CharSequence)DOT, this.enclosingClassNames()), this.simpleName());
        }
        return String.format("%s.%s", this.pakkage(), this.simpleName());
    }

    @Override
    public abstract boolean isStaticImport();

    @Override
    public boolean hasEnclosingClass() {
        return !this.enclosingClassNames().isEmpty();
    }

    @Override
    public boolean isFromPackage(String pkg) {
        return this.pakkage().equals(pkg);
    }

    @Override
    public boolean isSupertypeOrEquals(Reference other) {
        if (!(other instanceof VaporReference)) {
            return false;
        }
        VaporReference ref = (VaporReference)other;
        return this.pakkage().equals(ref.pakkage()) && this.simpleName().equals(ref.simpleName()) && Objects.equals(this.enclosingClassNames(), ref.enclosingClassNames());
    }

    @Override
    public boolean isAssignableFrom(Reference other) {
        return false;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VaporReference)) {
            return false;
        }
        VaporReference ref = (VaporReference)o;
        return this.pakkage().equals(ref.pakkage()) && this.name().equals(ref.name()) && this.generics().equals(ref.generics()) && Objects.equals(this.enclosingClassNames(), ref.enclosingClassNames());
    }

    public int hashCode() {
        int hash = 17 * this.pakkage().hashCode() + 19 * this.name().hashCode() + 23 * this.generics().hashCode();
        if (!this.enclosingClassNames().isEmpty()) {
            hash += 29 * this.enclosingClassNames().hashCode();
        }
        return hash;
    }

    @Override
    public Reference copyAndSetGenerics(List<Reference> generics) {
        return this.toBuilder().setGenerics(generics).build();
    }

    public static Builder builder() {
        return new AutoValue_VaporReference.Builder().setUseFullName(false).setGenerics(ImmutableList.of()).setIsStaticImport(false).setEnclosingClassNames(Collections.emptyList());
    }

    abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setPakkage(String var1);

        public abstract Builder setUseFullName(boolean var1);

        public Builder setGenerics(Reference ... references) {
            return this.setGenerics(Arrays.asList(references));
        }

        public abstract Builder setGenerics(List<Reference> var1);

        public Builder setEnclosingClassNames(String ... enclosingClassNames) {
            return this.setEnclosingClassNames(Arrays.asList(enclosingClassNames));
        }

        public abstract Builder setEnclosingClassNames(List<String> var1);

        public abstract Builder setIsStaticImport(boolean var1);

        public abstract Builder setSupertypeReference(Reference var1);

        abstract Builder setSimpleName(String var1);

        abstract String name();

        abstract ImmutableList<Reference> generics();

        abstract ImmutableList<String> enclosingClassNames();

        abstract boolean isStaticImport();

        abstract VaporReference autoBuild();

        public VaporReference build() {
            String contextInfo = String.format("vapor reference %s", this.name());
            NodeValidator.checkNoNullElements(this.generics(), "generics", contextInfo);
            NodeValidator.checkNoNullElements(this.enclosingClassNames(), "enclosingClassNames", contextInfo);
            IdentifierNode.builder().setName(this.name()).build();
            this.setSimpleName(this.name());
            this.setIsStaticImport(!this.enclosingClassNames().isEmpty() && this.isStaticImport());
            StringBuilder sb = new StringBuilder();
            if (!this.enclosingClassNames().isEmpty() && !this.isStaticImport()) {
                sb.append(String.join((CharSequence)VaporReference.DOT, this.enclosingClassNames()));
                sb.append(VaporReference.DOT);
            }
            sb.append(this.name());
            if (!this.generics().isEmpty()) {
                sb.append(VaporReference.LEFT_ANGLE);
                for (int i = 0; i < this.generics().size(); ++i) {
                    Reference r = (Reference)this.generics().get(i);
                    sb.append(r.name());
                    if (i >= this.generics().size() - 1) continue;
                    sb.append(VaporReference.COMMA);
                }
                sb.append(VaporReference.RIGHT_ANGLE);
            }
            this.setName(sb.toString());
            return this.autoBuild();
        }
    }
}

