/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AutoValue_ThisObjectValue;
import com.google.api.generator.engine.ast.ObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class ThisObjectValue
implements ObjectValue {
    private static final String THIS_VALUE = "this";

    @Override
    public abstract TypeNode type();

    @Override
    public String value() {
        return THIS_VALUE;
    }

    public static ThisObjectValue withType(TypeNode type) {
        return ThisObjectValue.builder().setType(type).build();
    }

    private static Builder builder() {
        return new AutoValue_ThisObjectValue.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setType(TypeNode var1);

        abstract ThisObjectValue autoBuild();

        private ThisObjectValue build() {
            ThisObjectValue thisObjectValue = this.autoBuild();
            Preconditions.checkState(TypeNode.isReferenceType(thisObjectValue.type()), "The \"this\" object can only refer to object types");
            return thisObjectValue;
        }
    }
}

