/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_JavaDocComment;
import com.google.api.generator.engine.ast.Comment;
import com.google.api.generator.engine.escaper.HtmlEscaper;
import com.google.api.generator.engine.escaper.MetacharEscaper;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@AutoValue
public abstract class JavaDocComment
implements Comment {
    @Override
    public abstract String comment();

    public static JavaDocComment withComment(String comment) {
        return JavaDocComment.builder().addComment(comment).build();
    }

    public static Builder builder() {
        return new AutoValue_JavaDocComment.Builder();
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        static final String PARAM_INDENT = "       ";
        String throwsType = null;
        String throwsDescription = null;
        String deprecated = null;
        String returnDescription = null;
        List<String> paramsList = new ArrayList<String>();
        List<String> componentsList = new ArrayList<String>();

        abstract Builder setComment(String var1);

        abstract JavaDocComment autoBuild();

        public Builder setThrows(String type, String description) {
            this.throwsType = type;
            this.throwsDescription = description;
            return this;
        }

        public Builder setDeprecated(String deprecatedText) {
            this.deprecated = deprecatedText;
            return this;
        }

        public Builder setReturn(String returnText) {
            this.returnDescription = returnText;
            return this;
        }

        public Builder addParam(String name, String description) {
            this.paramsList.add(String.format("@param %s %s", name, Builder.processParamComment(description)));
            return this;
        }

        public Builder addUnescapedComment(String comment) {
            this.componentsList.add(comment);
            return this;
        }

        public Builder addComment(String comment) {
            this.componentsList.add(HtmlEscaper.process(comment));
            return this;
        }

        public Builder addSampleCode(String sampleCode) {
            this.componentsList.add("<pre>{@code");
            Arrays.stream(sampleCode.split("\\r?\\n")).forEach(line -> this.componentsList.add((String)line));
            this.componentsList.add("}</pre>");
            return this;
        }

        public Builder addParagraph(String paragraph) {
            this.componentsList.add(String.format("<p> %s", HtmlEscaper.process(paragraph)));
            return this;
        }

        public Builder addOrderedList(List<String> oList) {
            this.componentsList.add("<ol>");
            oList.stream().forEach(s2 -> this.componentsList.add(String.format("<li> %s", HtmlEscaper.process(s2))));
            this.componentsList.add("</ol>");
            return this;
        }

        public Builder addUnorderedList(List<String> uList) {
            this.componentsList.add("<ul>");
            uList.stream().forEach(s2 -> this.componentsList.add(String.format("<li> %s", HtmlEscaper.process(s2))));
            this.componentsList.add("</ul>");
            return this;
        }

        public boolean emptyComments() {
            return Strings.isNullOrEmpty(this.throwsType) && Strings.isNullOrEmpty(this.throwsDescription) && Strings.isNullOrEmpty(this.deprecated) && Strings.isNullOrEmpty(this.returnDescription) && this.paramsList.isEmpty() && this.componentsList.isEmpty();
        }

        public JavaDocComment build() {
            this.componentsList.addAll(this.paramsList);
            if (!Strings.isNullOrEmpty(this.throwsType)) {
                this.componentsList.add(String.format("@throws %s %s", this.throwsType, HtmlEscaper.process(this.throwsDescription)));
            }
            if (!Strings.isNullOrEmpty(this.deprecated)) {
                this.componentsList.add(String.format("@deprecated %s", this.deprecated));
            }
            if (!Strings.isNullOrEmpty(this.returnDescription)) {
                this.componentsList.add(String.format("@return %s", this.returnDescription));
            }
            this.componentsList = this.componentsList.stream().map(c -> MetacharEscaper.process(c)).collect(Collectors.toList());
            this.setComment(String.join((CharSequence)"\n", this.componentsList));
            return this.autoBuild();
        }

        private static String processParamComment(String rawComment) {
            StringBuilder processedCommentBuilder = new StringBuilder();
            String[] descriptionParagraphs = rawComment.split("\\n\\n");
            for (int i = 0; i < descriptionParagraphs.length; ++i) {
                boolean startsWithItemizedList = descriptionParagraphs[i].startsWith(" * ");
                List listItems = Stream.of(descriptionParagraphs[i].split("\\n \\*")).map(s2 -> s2.replace("\n", "")).collect(Collectors.toList());
                if (startsWithItemizedList) {
                    listItems.set(0, ((String)listItems.get(0)).substring(2));
                }
                if (!startsWithItemizedList) {
                    if (i == 0) {
                        processedCommentBuilder.append(String.format("%s", HtmlEscaper.process((String)listItems.get(0))));
                    } else {
                        processedCommentBuilder.append(String.format("%s<p> %s", PARAM_INDENT, HtmlEscaper.process((String)listItems.get(0))));
                    }
                }
                if (listItems.size() <= 1 && !startsWithItemizedList) continue;
                processedCommentBuilder.append(String.format("%s<ul>\n%s\n%s</ul>", PARAM_INDENT, listItems.subList(startsWithItemizedList ? 0 : 1, listItems.size()).stream().map(li -> String.format("%s  <li>%s", PARAM_INDENT, HtmlEscaper.process(li))).reduce("", String::concat), PARAM_INDENT));
            }
            return processedCommentBuilder.toString();
        }
    }
}

