/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.internal;

import com.google.api.client.util.Beta;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

@Beta
public class QuotaProjectIdHidingCredentials
extends Credentials {
    private static final String QUOTA_PROJECT_ID_HEADER_KEY = "x-goog-user-project";
    private final Credentials wrappedCredentials;

    public QuotaProjectIdHidingCredentials(Credentials credentials) {
        this.wrappedCredentials = credentials;
    }

    @Override
    public String getAuthenticationType() {
        return this.wrappedCredentials.getAuthenticationType();
    }

    @Override
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        ImmutableMap.Builder<String, List<String>> metaBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> entry : this.wrappedCredentials.getRequestMetadata(uri).entrySet()) {
            if (entry.getKey().equals(QUOTA_PROJECT_ID_HEADER_KEY)) continue;
            metaBuilder.put(entry);
        }
        return metaBuilder.build();
    }

    @Override
    public Map<String, List<String>> getRequestMetadata() throws IOException {
        return this.getRequestMetadata(null);
    }

    @Override
    public boolean hasRequestMetadata() {
        return this.wrappedCredentials.hasRequestMetadata();
    }

    @Override
    public boolean hasRequestMetadataOnly() {
        return this.wrappedCredentials.hasRequestMetadataOnly();
    }

    @Override
    public void refresh() throws IOException {
        this.wrappedCredentials.refresh();
    }
}

