/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.FieldInfo;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.gapic.model.AutoValue_Field;
import com.google.api.generator.gapic.model.ResourceReference;
import com.google.auto.value.AutoValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@AutoValue
public abstract class Field {
    public abstract String name();

    public abstract String originalName();

    public abstract TypeNode type();

    public abstract boolean isRequired();

    @Nullable
    public abstract FieldInfo.Format fieldInfoFormat();

    public abstract boolean isMessage();

    public abstract boolean isEnum();

    public abstract boolean isRepeated();

    public abstract boolean isMap();

    public abstract boolean isContainedInOneof();

    public abstract boolean isProto3Optional();

    @Nullable
    public abstract ResourceReference resourceReference();

    @Nullable
    public abstract String description();

    public boolean hasFieldNameConflict() {
        return !this.name().equals(this.originalName());
    }

    public boolean hasDescription() {
        return this.description() != null;
    }

    public boolean hasResourceReference() {
        return this.type().equals(TypeNode.STRING) && this.resourceReference() != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        return this.name().equals(other.name()) && this.originalName().equals(other.originalName()) && this.type().equals(other.type()) && this.isRequired() == other.isRequired() && this.fieldInfoFormat() == other.fieldInfoFormat() && this.isMessage() == other.isMessage() && this.isEnum() == other.isEnum() && this.isRepeated() == other.isRepeated() && this.isMap() == other.isMap() && this.isContainedInOneof() == other.isContainedInOneof() && this.isProto3Optional() == other.isProto3Optional() && Objects.equals(this.resourceReference(), other.resourceReference()) && Objects.equals(this.description(), other.description());
    }

    public int hashCode() {
        return 17 * this.name().hashCode() + 31 * this.originalName().hashCode() + 19 * this.type().hashCode() + (this.isMessage() ? 1 : 0) * 23 + (this.isEnum() ? 1 : 0) * 29 + (this.isRequired() ? 1 : 0) * 31 + (this.fieldInfoFormat() == null ? 0 : this.fieldInfoFormat().hashCode()) + (this.isRepeated() ? 1 : 0) * 31 + (this.isMap() ? 1 : 0) * 37 + (this.isContainedInOneof() ? 1 : 0) * 41 + (this.isProto3Optional() ? 1 : 0) * 43 + (this.resourceReference() == null ? 0 : this.resourceReference().hashCode()) + (this.description() == null ? 0 : this.description().hashCode());
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Field.Builder().setIsRequired(false).setIsMessage(false).setIsEnum(false).setIsRepeated(false).setIsMap(false).setIsContainedInOneof(false).setIsProto3Optional(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setOriginalName(String var1);

        public abstract Builder setType(TypeNode var1);

        public abstract Builder setIsRequired(boolean var1);

        public abstract Builder setFieldInfoFormat(FieldInfo.Format var1);

        public abstract Builder setIsMessage(boolean var1);

        public abstract Builder setIsEnum(boolean var1);

        public abstract Builder setIsRepeated(boolean var1);

        public abstract Builder setIsMap(boolean var1);

        public abstract Builder setIsContainedInOneof(boolean var1);

        public abstract Builder setIsProto3Optional(boolean var1);

        public abstract Builder setResourceReference(ResourceReference var1);

        public abstract Builder setDescription(String var1);

        abstract String name();

        abstract Optional<String> originalName();

        abstract Field autoBuild();

        public Field build() {
            if (!this.originalName().isPresent()) {
                this.setOriginalName(this.name());
            }
            return this.autoBuild();
        }
    }
}

