/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.googleapis;

import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.googleapis.GoogleCloudToProdNameResolver;
import io.grpc.internal.GrpcUtil;
import io.grpc.xds.InternalSharedXdsClientPoolProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@Internal
public final class GoogleCloudToProdNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "google-c2p";
    private final String scheme;

    public GoogleCloudToProdNameResolverProvider() {
        this(SCHEME);
    }

    GoogleCloudToProdNameResolverProvider(String scheme) {
        this.scheme = Preconditions.checkNotNull(scheme, "scheme");
    }

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args2) {
        if (this.scheme.equals(targetUri.getScheme())) {
            return new GoogleCloudToProdNameResolver(targetUri, args2, GrpcUtil.SHARED_CHANNEL_EXECUTOR, new SharedXdsClientPoolProviderBootstrapSetter());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return this.scheme;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 4;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }

    private static final class SharedXdsClientPoolProviderBootstrapSetter
    implements GoogleCloudToProdNameResolver.BootstrapSetter {
        private SharedXdsClientPoolProviderBootstrapSetter() {
        }

        @Override
        public void setBootstrap(Map<String, ?> bootstrap) {
            InternalSharedXdsClientPoolProvider.setDefaultProviderBootstrapOverride(bootstrap);
        }
    }
}

