/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.samplecode;

import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.model.MethodArgument;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Sample;
import com.google.api.generator.gapic.utils.JavaStyle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SampleComposerUtil {
    static AssignmentExpr assignClientVariableWithCreateMethodExpr(VariableExpr clientVarExpr) {
        return AssignmentExpr.builder().setVariableExpr(clientVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(clientVarExpr.variable().type()).setReturnType(clientVarExpr.variable().type()).setMethodName("create").build()).build();
    }

    static boolean isStringTypedResourceName(MethodArgument arg, Map<String, ResourceName> resourceNames) {
        return arg.type().equals(TypeNode.STRING) && arg.field().hasResourceReference() && resourceNames.containsKey(arg.field().resourceReference().resourceTypeString());
    }

    static String createOverloadDisambiguation(List<VariableExpr> methodArgVarExprs) {
        if (methodArgVarExprs.isEmpty()) {
            return "Noargs";
        }
        return methodArgVarExprs.stream().map(arg -> JavaStyle.toUpperCamelCase(arg.variable().type().reference() == null ? arg.variable().type().typeKind().name().toLowerCase() : arg.variable().type().reference().name().toLowerCase())).collect(Collectors.joining());
    }

    public static List<Sample> handleDuplicateSamples(List<Sample> samples) {
        Map<String, List<Sample>> distinctSamplesGroupedByName = samples.stream().distinct().collect(Collectors.groupingBy(s2 -> s2.name()));
        List<Sample> uniqueSamples = distinctSamplesGroupedByName.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() < 2).map(entry -> (Sample)((List)entry.getValue()).get(0)).collect(Collectors.toList());
        if (uniqueSamples.size() == distinctSamplesGroupedByName.size()) {
            return uniqueSamples;
        }
        List duplicateDistinctSamples = distinctSamplesGroupedByName.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toList());
        for (Map.Entry entry2 : duplicateDistinctSamples) {
            int sampleNum = 0;
            Iterator iterator2 = ((List)entry2.getValue()).iterator();
            while (iterator2.hasNext()) {
                Sample sample;
                Sample uniqueSample = sample = (Sample)iterator2.next();
                if (sampleNum != 0) {
                    uniqueSample = sample.withRegionTag(sample.regionTag().withOverloadDisambiguation(sample.regionTag().overloadDisambiguation() + sampleNum));
                }
                uniqueSamples.add(uniqueSample);
                ++sampleNum;
            }
        }
        return uniqueSamples;
    }
}

