/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TraceFinisher;
import com.google.common.util.concurrent.MoreExecutors;

@BetaApi(value="The surface for tracing is not stable and might change in the future")
@InternalApi(value="For internal use by google-cloud-java clients only")
public class TracedBatchingCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final ApiTracerFactory tracerFactory;
    private final SpanName spanName;
    private final BatchingDescriptor<RequestT, ResponseT> batchingDescriptor;
    private final UnaryCallable<RequestT, ResponseT> innerCallable;

    public TracedBatchingCallable(UnaryCallable<RequestT, ResponseT> innerCallable, ApiTracerFactory tracerFactory, SpanName spanName, BatchingDescriptor<RequestT, ResponseT> batchingDescriptor) {
        this.tracerFactory = tracerFactory;
        this.spanName = spanName;
        this.batchingDescriptor = batchingDescriptor;
        this.innerCallable = innerCallable;
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext context) {
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), this.spanName, ApiTracerFactory.OperationType.Batching);
        TraceFinisher finisher = new TraceFinisher(tracer);
        try {
            long elementCount = this.batchingDescriptor.countElements(request);
            long requestSize = this.batchingDescriptor.countBytes(request);
            tracer.batchRequestSent(elementCount, requestSize);
            context = context.withTracer(tracer);
            ApiFuture<ResponseT> future = this.innerCallable.futureCall(request, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e) {
            finisher.onFailure(e);
            throw e;
        }
    }
}

