/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javah;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openjdk.javax.lang.model.element.Element;
import org.openjdk.javax.lang.model.element.ExecutableElement;
import org.openjdk.javax.lang.model.element.Modifier;
import org.openjdk.javax.lang.model.element.Name;
import org.openjdk.javax.lang.model.element.TypeElement;
import org.openjdk.javax.lang.model.element.VariableElement;
import org.openjdk.javax.lang.model.type.ArrayType;
import org.openjdk.javax.lang.model.type.PrimitiveType;
import org.openjdk.javax.lang.model.type.TypeKind;
import org.openjdk.javax.lang.model.type.TypeMirror;
import org.openjdk.javax.lang.model.util.ElementFilter;
import org.openjdk.javax.lang.model.util.SimpleTypeVisitor9;
import org.openjdk.tools.javah.Gen;
import org.openjdk.tools.javah.TypeSignature;
import org.openjdk.tools.javah.Util;

public class LLNI
extends Gen {
    protected final char innerDelim = (char)36;
    protected Set<String> doneHandleTypes;
    List<VariableElement> fields;
    List<ExecutableElement> methods;
    private boolean doubleAlign;
    private int padFieldNum = 0;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    LLNI(boolean bl, Util util) {
        super(util);
        this.doubleAlign = bl;
    }

    @Override
    protected String getIncludes() {
        return "";
    }

    @Override
    protected void write(OutputStream outputStream, TypeElement typeElement) throws Util.Exit {
        try {
            String string = this.mangleClassName(typeElement.getQualifiedName().toString());
            PrintWriter printWriter = this.wrapWriter(outputStream);
            this.fields = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
            this.methods = ElementFilter.methodsIn(typeElement.getEnclosedElements());
            this.generateDeclsForClass(printWriter, typeElement, string);
        }
        catch (TypeSignature.SignatureException signatureException) {
            this.util.error("llni.sigerror", signatureException.getMessage());
        }
    }

    protected void generateDeclsForClass(PrintWriter printWriter, TypeElement typeElement, String string) throws TypeSignature.SignatureException, Util.Exit {
        this.doneHandleTypes = new HashSet<String>();
        this.genHandleType(null, "java.lang.Class");
        this.genHandleType(null, "java.lang.ClassLoader");
        this.genHandleType(null, "java.lang.Object");
        this.genHandleType(null, "java.lang.String");
        this.genHandleType(null, "java.lang.Thread");
        this.genHandleType(null, "java.lang.ThreadGroup");
        this.genHandleType(null, "java.lang.Throwable");
        printWriter.println("/* LLNI Header for class " + typeElement.getQualifiedName() + " */" + this.lineSep);
        printWriter.println("#ifndef _Included_" + string);
        printWriter.println("#define _Included_" + string);
        printWriter.println("#include \"typedefs.h\"");
        printWriter.println("#include \"llni.h\"");
        printWriter.println("#include \"jni.h\"" + this.lineSep);
        this.forwardDecls(printWriter, typeElement);
        this.structSectionForClass(printWriter, typeElement, string);
        this.methodSectionForClass(printWriter, typeElement, string);
        printWriter.println("#endif");
    }

    protected void genHandleType(PrintWriter printWriter, String string) {
        String string2 = this.mangleClassName(string);
        if (!this.doneHandleTypes.contains(string2)) {
            this.doneHandleTypes.add(string2);
            if (printWriter != null) {
                printWriter.println("#ifndef DEFINED_" + string2);
                printWriter.println("    #define DEFINED_" + string2);
                printWriter.println("    GEN_HANDLE_TYPES(" + string2 + ");");
                printWriter.println("#endif" + this.lineSep);
            }
        }
    }

    protected String mangleClassName(String string) {
        return string.replace('.', '_').replace('/', '_').replace('$', '_');
    }

    protected void forwardDecls(PrintWriter printWriter, TypeElement typeElement) throws TypeSignature.SignatureException {
        TypeMirror typeMirror;
        Object object;
        Object object2;
        String string;
        TypeElement typeElement2 = this.elems.getTypeElement("java.lang.Object");
        if (typeElement.equals(typeElement2)) {
            return;
        }
        this.genHandleType(printWriter, typeElement.getQualifiedName().toString());
        TypeElement typeElement3 = (TypeElement)this.types.asElement(typeElement.getSuperclass());
        if (typeElement3 != null) {
            Iterator<ExecutableElement> iterator2 = typeElement3.getQualifiedName().toString();
            this.forwardDecls(printWriter, typeElement3);
        }
        for (VariableElement element : this.fields) {
            if (element.getModifiers().contains((Object)Modifier.STATIC) || (string = ((TypeSignature)(object2 = new TypeSignature(this.elems))).getTypeSignature((String)(object = ((TypeSignature)object2).qualifiedTypeName(typeMirror = this.types.erasure(element.asType()))))).charAt(0) == '[') continue;
            this.forwardDeclsFromSig(printWriter, string);
        }
        for (ExecutableElement executableElement : this.methods) {
            if (!executableElement.getModifiers().contains((Object)Modifier.NATIVE)) continue;
            typeMirror = this.types.erasure(executableElement.getReturnType());
            object = new TypeSignature(this.elems);
            object2 = this.signature(executableElement);
            string = ((TypeSignature)object).getTypeSignature((String)object2, typeMirror);
            if (string.charAt(0) == '[') continue;
            this.forwardDeclsFromSig(printWriter, string);
        }
    }

    protected void forwardDeclsFromSig(PrintWriter printWriter, String string) {
        int n;
        int n2 = string.length();
        int n3 = n = string.charAt(0) == '(' ? 1 : 0;
        while (n < n2) {
            if (string.charAt(n) == 'L') {
                int n4 = n + 1;
                while (string.charAt(n4) != ';') {
                    ++n4;
                }
                this.genHandleType(printWriter, string.substring(n + 1, n4));
                n = n4 + 1;
                continue;
            }
            ++n;
        }
    }

    protected void structSectionForClass(PrintWriter printWriter, TypeElement typeElement, String string) {
        String string2 = typeElement.getQualifiedName().toString();
        if (string.equals("java_lang_Object")) {
            printWriter.println("/* struct java_lang_Object is defined in typedefs.h. */");
            printWriter.println();
            return;
        }
        printWriter.println("#if !defined(__i386)");
        printWriter.println("#pragma pack(4)");
        printWriter.println("#endif");
        printWriter.println();
        printWriter.println("struct " + string + " {");
        printWriter.println("    ObjHeader h;");
        printWriter.print(this.fieldDefs(typeElement, string));
        if (string2.equals("java.lang.Class")) {
            printWriter.println("    Class *LLNI_mask(cClass);  /* Fake field; don't access (see oobj.h) */");
        }
        printWriter.println("};" + this.lineSep + this.lineSep + "#pragma pack()");
        printWriter.println();
    }

    private boolean doField(FieldDefsRes fieldDefsRes, VariableElement variableElement, String string, boolean bl) {
        String string2 = this.addStructMember(variableElement, string, bl);
        if (string2 != null) {
            if (!fieldDefsRes.printedOne) {
                if (fieldDefsRes.bottomMost) {
                    if (fieldDefsRes.s.length() != 0) {
                        fieldDefsRes.s = fieldDefsRes.s + "    /* local members: */" + this.lineSep;
                    }
                } else {
                    fieldDefsRes.s = fieldDefsRes.s + "    /* inherited members from " + fieldDefsRes.className + ": */" + this.lineSep;
                }
                fieldDefsRes.printedOne = true;
            }
            fieldDefsRes.s = fieldDefsRes.s + string2;
            return true;
        }
        return false;
    }

    private int doTwoWordFields(FieldDefsRes fieldDefsRes, TypeElement typeElement, int n, String string, boolean bl) {
        boolean bl2 = true;
        List<VariableElement> list = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement variableElement : list) {
            TypeKind typeKind = variableElement.asType().getKind();
            boolean bl3 = typeKind == TypeKind.LONG || typeKind == TypeKind.DOUBLE;
            if (!bl3 || !this.doField(fieldDefsRes, variableElement, string, bl2 && bl)) continue;
            n += 8;
            bl2 = false;
        }
        return n;
    }

    String fieldDefs(TypeElement typeElement, String string) {
        FieldDefsRes fieldDefsRes = this.fieldDefs(typeElement, string, true);
        return fieldDefsRes.s;
    }

    FieldDefsRes fieldDefs(TypeElement typeElement, String string, boolean bl) {
        int n;
        FieldDefsRes fieldDefsRes;
        Object object;
        boolean bl2 = false;
        TypeElement typeElement2 = (TypeElement)this.types.asElement(typeElement.getSuperclass());
        if (typeElement2 != null) {
            object = typeElement2.getQualifiedName().toString();
            fieldDefsRes = new FieldDefsRes(typeElement, this.fieldDefs(typeElement2, string, false), bl);
            n = fieldDefsRes.parent.byteSize;
        } else {
            fieldDefsRes = new FieldDefsRes(typeElement, null, bl);
            n = 0;
        }
        object = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            TypeKind typeKind;
            boolean bl3;
            VariableElement variableElement = (VariableElement)iterator2.next();
            if (this.doubleAlign && !bl2 && n % 8 == 0) {
                n = this.doTwoWordFields(fieldDefsRes, typeElement, n, string, false);
                bl2 = true;
            }
            boolean bl4 = bl3 = (typeKind = variableElement.asType().getKind()) == TypeKind.LONG || typeKind == TypeKind.DOUBLE;
            if (this.doubleAlign && bl3 || !this.doField(fieldDefsRes, variableElement, string, false)) continue;
            n += 4;
        }
        if (this.doubleAlign && !bl2) {
            if (n % 8 != 0) {
                n += 4;
            }
            n = this.doTwoWordFields(fieldDefsRes, typeElement, n, string, true);
        }
        fieldDefsRes.byteSize = n;
        return fieldDefsRes;
    }

    protected String addStructMember(VariableElement variableElement, String string, boolean bl) {
        String string2 = null;
        if (variableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            string2 = this.addStaticStructMember(variableElement, string);
        } else {
            TypeMirror typeMirror = this.types.erasure(variableElement.asType());
            if (bl) {
                string2 = "    java_int padWord" + this.padFieldNum++ + ";" + this.lineSep;
            }
            string2 = "    " + this.llniType(typeMirror, false, false) + " " + this.llniFieldName(variableElement);
            if (this.isLongOrDouble(typeMirror)) {
                string2 = string2 + "[2]";
            }
            string2 = string2 + ";" + this.lineSep;
        }
        return string2;
    }

    protected String addStaticStructMember(VariableElement variableElement, String string) {
        String string2 = null;
        Object object = null;
        if (!variableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return string2;
        }
        if (!variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return string2;
        }
        object = variableElement.getConstantValue();
        if (object != null) {
            String string3 = string + "_" + variableElement.getSimpleName();
            String string4 = null;
            long l = 0L;
            if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
                string4 = "L";
                l = ((Number)object).intValue();
            } else if (object instanceof Long) {
                string4 = isWindows ? "i64" : "LL";
                l = (Long)object;
            } else if (object instanceof Float) {
                string4 = "f";
            } else if (object instanceof Double) {
                string4 = "";
            } else if (object instanceof Character) {
                string4 = "L";
                Character c = (Character)object;
                l = c.charValue() & 0xFFFF;
            }
            if (string4 != null) {
                string2 = string4.equals("L") && l == Integer.MIN_VALUE || string4.equals("LL") && l == Long.MIN_VALUE ? "    #undef  " + string3 + this.lineSep + "    #define " + string3 + " (" + (l + 1L) + string4 + "-1)" + this.lineSep : (string4.equals("L") || string4.endsWith("LL") ? "    #undef  " + string3 + this.lineSep + "    #define " + string3 + " " + l + string4 + this.lineSep : "    #undef  " + string3 + this.lineSep + "    #define " + string3 + " " + object + string4 + this.lineSep);
            }
        }
        return string2;
    }

    protected void methodSectionForClass(PrintWriter printWriter, TypeElement typeElement, String string) throws TypeSignature.SignatureException, Util.Exit {
        String string2 = this.methodDecls(typeElement, string);
        if (string2.length() != 0) {
            printWriter.println("/* Native method declarations: */" + this.lineSep);
            printWriter.println("#ifdef __cplusplus");
            printWriter.println("extern \"C\" {");
            printWriter.println("#endif" + this.lineSep);
            printWriter.println(string2);
            printWriter.println("#ifdef __cplusplus");
            printWriter.println("}");
            printWriter.println("#endif");
        }
    }

    protected String methodDecls(TypeElement typeElement, String string) throws TypeSignature.SignatureException, Util.Exit {
        String string2 = "";
        for (ExecutableElement executableElement : this.methods) {
            if (!executableElement.getModifiers().contains((Object)Modifier.NATIVE)) continue;
            string2 = string2 + this.methodDecl(executableElement, typeElement, string);
        }
        return string2;
    }

    protected String methodDecl(ExecutableElement executableElement, TypeElement typeElement, String string) throws TypeSignature.SignatureException, Util.Exit {
        String string2 = null;
        TypeMirror typeMirror = this.types.erasure(executableElement.getReturnType());
        String string3 = this.signature(executableElement);
        TypeSignature typeSignature = new TypeSignature(this.elems);
        String string4 = typeSignature.getTypeSignature(string3, typeMirror);
        boolean bl = this.needLongName(executableElement, typeElement);
        if (string4.charAt(0) != '(') {
            this.util.error("invalid.method.signature", string4);
        }
        string2 = "JNIEXPORT " + this.jniType(typeMirror) + " JNICALL" + this.lineSep + this.jniMethodName(executableElement, string, bl) + "(JNIEnv *, " + this.cRcvrDecl(executableElement, string);
        List<? extends VariableElement> list = executableElement.getParameters();
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
        for (VariableElement annotatedConstruct : list) {
            arrayList.add(this.types.erasure(annotatedConstruct.asType()));
        }
        for (TypeMirror typeMirror2 : arrayList) {
            string2 = string2 + ", " + this.jniType(typeMirror2);
        }
        string2 = string2 + ");" + this.lineSep;
        return string2;
    }

    protected final boolean needLongName(ExecutableElement executableElement, TypeElement typeElement) {
        Name name = executableElement.getSimpleName();
        for (ExecutableElement executableElement2 : this.methods) {
            if (executableElement2 == executableElement || !executableElement2.getModifiers().contains((Object)Modifier.NATIVE) || !name.equals(executableElement2.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    protected final String jniMethodName(ExecutableElement executableElement, String string, boolean bl) throws TypeSignature.SignatureException {
        String string2 = "Java_" + string + "_" + executableElement.getSimpleName();
        if (bl) {
            TypeMirror typeMirror = this.types.erasure(executableElement.getReturnType());
            List<? extends VariableElement> list = executableElement.getParameters();
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
            for (VariableElement annotatedConstruct : list) {
                arrayList.add(this.types.erasure(annotatedConstruct.asType()));
            }
            string2 = string2 + "__";
            for (TypeMirror typeMirror2 : arrayList) {
                String string3 = typeMirror2.toString();
                TypeSignature typeSignature = new TypeSignature(this.elems);
                String string4 = typeSignature.getTypeSignature(string3);
                string2 = string2 + this.nameToIdentifier(string4);
            }
        }
        return string2;
    }

    protected final String jniType(TypeMirror typeMirror) throws Util.Exit {
        TypeElement typeElement = this.elems.getTypeElement("java.lang.Throwable");
        TypeElement typeElement2 = this.elems.getTypeElement("java.lang.Class");
        TypeElement typeElement3 = this.elems.getTypeElement("java.lang.String");
        Element element = this.types.asElement(typeMirror);
        switch (typeMirror.getKind()) {
            case ARRAY: {
                TypeMirror typeMirror2 = ((ArrayType)typeMirror).getComponentType();
                switch (typeMirror2.getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                    case ARRAY: 
                    case DECLARED: {
                        return "jobjectArray";
                    }
                }
                throw new Error(typeMirror2.toString());
            }
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "jboolean";
            }
            case BYTE: {
                return "jbyte";
            }
            case CHAR: {
                return "jchar";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case DECLARED: {
                if (element.equals(typeElement3)) {
                    return "jstring";
                }
                if (this.types.isAssignable(typeMirror, typeElement.asType())) {
                    return "jthrowable";
                }
                if (this.types.isAssignable(typeMirror, typeElement2.asType())) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        this.util.bug("jni.unknown.type");
        return null;
    }

    protected String llniType(TypeMirror typeMirror, boolean bl, boolean bl2) {
        String string = null;
        switch (typeMirror.getKind()) {
            case ARRAY: {
                TypeMirror typeMirror2 = ((ArrayType)typeMirror).getComponentType();
                switch (typeMirror2.getKind()) {
                    case BOOLEAN: {
                        string = "IArrayOfBoolean";
                        break;
                    }
                    case BYTE: {
                        string = "IArrayOfByte";
                        break;
                    }
                    case CHAR: {
                        string = "IArrayOfChar";
                        break;
                    }
                    case SHORT: {
                        string = "IArrayOfShort";
                        break;
                    }
                    case INT: {
                        string = "IArrayOfInt";
                        break;
                    }
                    case LONG: {
                        string = "IArrayOfLong";
                        break;
                    }
                    case FLOAT: {
                        string = "IArrayOfFloat";
                        break;
                    }
                    case DOUBLE: {
                        string = "IArrayOfDouble";
                        break;
                    }
                    case ARRAY: 
                    case DECLARED: {
                        string = "IArrayOfRef";
                        break;
                    }
                    default: {
                        throw new Error((Object)((Object)typeMirror2.getKind()) + " " + typeMirror2);
                    }
                }
                if (bl) break;
                string = "DEREFERENCED_" + string;
                break;
            }
            case VOID: {
                string = "void";
                break;
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                string = "java_int";
                break;
            }
            case LONG: {
                string = bl2 ? "java_long" : "val32 /* java_long */";
                break;
            }
            case FLOAT: {
                string = "java_float";
                break;
            }
            case DOUBLE: {
                string = bl2 ? "java_double" : "val32 /* java_double */";
                break;
            }
            case DECLARED: {
                TypeElement typeElement = (TypeElement)this.types.asElement(typeMirror);
                string = "I" + this.mangleClassName(typeElement.getQualifiedName().toString());
                if (bl) break;
                string = "DEREFERENCED_" + string;
                break;
            }
            default: {
                throw new Error((Object)((Object)typeMirror.getKind()) + " " + typeMirror);
            }
        }
        return string;
    }

    protected final String cRcvrDecl(Element element, String string) {
        return element.getModifiers().contains((Object)Modifier.STATIC) ? "jclass" : "jobject";
    }

    protected String maskName(String string) {
        return "LLNI_mask(" + string + ")";
    }

    protected String llniFieldName(VariableElement variableElement) {
        return this.maskName(variableElement.getSimpleName().toString());
    }

    protected final boolean isLongOrDouble(TypeMirror typeMirror) {
        SimpleTypeVisitor9<Boolean, Void> simpleTypeVisitor9 = new SimpleTypeVisitor9<Boolean, Void>(){

            @Override
            public Boolean defaultAction(TypeMirror typeMirror, Void void_) {
                return false;
            }

            @Override
            public Boolean visitArray(ArrayType arrayType, Void void_) {
                return (Boolean)this.visit(arrayType.getComponentType(), void_);
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType primitiveType, Void void_) {
                TypeKind typeKind = primitiveType.getKind();
                return typeKind == TypeKind.LONG || typeKind == TypeKind.DOUBLE;
            }
        };
        return (Boolean)simpleTypeVisitor9.visit(typeMirror, null);
    }

    protected final String nameToIdentifier(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (this.isASCIILetterOrDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (c == '/') {
                stringBuilder.append('_');
                continue;
            }
            if (c == '.') {
                stringBuilder.append('_');
                continue;
            }
            if (c == '_') {
                stringBuilder.append("_1");
                continue;
            }
            if (c == ';') {
                stringBuilder.append("_2");
                continue;
            }
            if (c == '[') {
                stringBuilder.append("_3");
                continue;
            }
            stringBuilder.append("_0" + c);
        }
        return new String(stringBuilder);
    }

    protected final boolean isASCIILetterOrDigit(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private static class FieldDefsRes {
        public String className;
        public FieldDefsRes parent;
        public String s;
        public int byteSize;
        public boolean bottomMost;
        public boolean printedOne = false;

        FieldDefsRes(TypeElement typeElement, FieldDefsRes fieldDefsRes, boolean bl) {
            this.className = typeElement.getQualifiedName().toString();
            this.parent = fieldDefsRes;
            this.bottomMost = bl;
            boolean bl2 = false;
            this.s = fieldDefsRes == null ? "" : fieldDefsRes.s;
        }
    }
}

