/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javah;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.openjdk.javax.annotation.processing.AbstractProcessor;
import org.openjdk.javax.annotation.processing.Messager;
import org.openjdk.javax.annotation.processing.ProcessingEnvironment;
import org.openjdk.javax.annotation.processing.RoundEnvironment;
import org.openjdk.javax.annotation.processing.SupportedAnnotationTypes;
import org.openjdk.javax.lang.model.SourceVersion;
import org.openjdk.javax.lang.model.element.ExecutableElement;
import org.openjdk.javax.lang.model.element.TypeElement;
import org.openjdk.javax.lang.model.element.VariableElement;
import org.openjdk.javax.lang.model.type.ArrayType;
import org.openjdk.javax.lang.model.type.DeclaredType;
import org.openjdk.javax.lang.model.type.TypeMirror;
import org.openjdk.javax.lang.model.type.TypeVisitor;
import org.openjdk.javax.lang.model.util.ElementFilter;
import org.openjdk.javax.lang.model.util.SimpleTypeVisitor9;
import org.openjdk.javax.lang.model.util.Types;
import org.openjdk.javax.tools.Diagnostic;
import org.openjdk.javax.tools.DiagnosticListener;
import org.openjdk.javax.tools.JavaCompiler;
import org.openjdk.javax.tools.JavaFileManager;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.javax.tools.StandardJavaFileManager;
import org.openjdk.javax.tools.StandardLocation;
import org.openjdk.javax.tools.ToolProvider;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.main.CommandLine;
import org.openjdk.tools.javah.Gen;
import org.openjdk.tools.javah.InternalError;
import org.openjdk.tools.javah.JNI;
import org.openjdk.tools.javah.JavahFileManager;
import org.openjdk.tools.javah.LLNI;
import org.openjdk.tools.javah.NativeHeaderTool;
import org.openjdk.tools.javah.Util;

public class JavahTask
implements NativeHeaderTool.NativeHeaderTask {
    static final Option[] recognizedOptions = new Option[]{new Option(true, new String[]{"-o"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.ofile = new File(string2);
        }
    }, new Option(true, new String[]{"-d"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.odir = new File(string2);
        }
    }, new HiddenOption(true, new String[]{"-td"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
        }
    }, new Option(false, new String[]{"-v", "-verbose"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.verbose = true;
        }
    }, new Option(false, new String[]{"-h", "-help", "--help", "-?"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.help = true;
        }
    }, new HiddenOption(false, new String[]{"-trace"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.trace = true;
        }
    }, new Option(false, new String[]{"-version"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.version = true;
        }
    }, new HiddenOption(false, new String[]{"-fullversion"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.fullVersion = true;
        }
    }, new Option(false, new String[]{"-jni"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.jni = true;
        }
    }, new Option(false, new String[]{"-force"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.force = true;
        }
    }, new HiddenOption(false, new String[]{"-Xnew"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
        }
    }, new HiddenOption(false, new String[]{"-llni", "-Xllni"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.llni = true;
        }
    }, new HiddenOption(false, new String[]{"-llnidouble"}){

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.llni = true;
            javahTask.doubleAlign = true;
        }
    }, new HiddenOption(false, new String[0]){

        @Override
        boolean matches(String string) {
            return string.startsWith("-XD");
        }

        @Override
        void process(JavahTask javahTask, String string, String string2) {
            javahTask.javac_extras.add(string);
        }
    }};
    private static final String versionRBName = "org.openjdk.tools.javah.resources.version";
    private static ResourceBundle versionRB;
    File ofile;
    File odir;
    String bootcp;
    String usercp;
    List<String> classes;
    boolean verbose;
    boolean noArgs;
    boolean help;
    boolean trace;
    boolean version;
    boolean fullVersion;
    boolean jni;
    boolean llni;
    boolean doubleAlign;
    boolean force;
    Set<String> javac_extras = new LinkedHashSet<String>();
    PrintWriter log;
    JavaFileManager fileManager;
    DiagnosticListener<? super JavaFileObject> diagnosticListener;
    Locale task_locale;
    Map<Locale, ResourceBundle> bundles;
    private static final String progname = "javah";

    JavahTask() {
    }

    JavahTask(Writer writer, JavaFileManager javaFileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> iterable, Iterable<String> iterable2) {
        this();
        this.log = JavahTask.getPrintWriterForWriter(writer);
        this.fileManager = javaFileManager;
        this.diagnosticListener = diagnosticListener;
        try {
            this.handleOptions(iterable, false);
        }
        catch (BadArgs badArgs) {
            throw new IllegalArgumentException(badArgs.getMessage());
        }
        this.classes = new ArrayList<String>();
        if (iterable2 != null) {
            for (String string : iterable2) {
                Objects.requireNonNull(string);
                this.classes.add(string);
            }
        }
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.task_locale = locale;
    }

    public void setLog(PrintWriter printWriter) {
        this.log = printWriter;
    }

    public void setLog(OutputStream outputStream) {
        this.setLog(JavahTask.getPrintWriterForStream(outputStream));
    }

    static PrintWriter getPrintWriterForStream(OutputStream outputStream) {
        return new PrintWriter(outputStream, true);
    }

    static PrintWriter getPrintWriterForWriter(Writer writer) {
        if (writer == null) {
            return JavahTask.getPrintWriterForStream(null);
        }
        if (writer instanceof PrintWriter) {
            return (PrintWriter)writer;
        }
        return new PrintWriter(writer, true);
    }

    public void setDiagnosticListener(DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        this.diagnosticListener = diagnosticListener;
    }

    public void setDiagnosticListener(OutputStream outputStream) {
        this.setDiagnosticListener(this.getDiagnosticListenerForStream(outputStream));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForStream(OutputStream outputStream) {
        return this.getDiagnosticListenerForWriter(JavahTask.getPrintWriterForStream(outputStream));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForWriter(Writer writer) {
        PrintWriter printWriter = JavahTask.getPrintWriterForWriter(writer);
        return diagnostic -> {
            if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                printWriter.print(this.getMessage("err.prefix", new Object[0]));
                printWriter.print(" ");
            }
            printWriter.println(diagnostic.getMessage(null));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] stringArray) {
        try {
            this.handleOptions(stringArray);
            boolean bl = this.run();
            int n = bl ? 0 : 1;
            return n;
        }
        catch (BadArgs badArgs) {
            this.diagnosticListener.report(this.createDiagnostic(badArgs.key, badArgs.args));
            int n = 1;
            return n;
        }
        catch (InternalError internalError) {
            this.diagnosticListener.report(this.createDiagnostic("err.internal.error", internalError.getMessage()));
            int n = 1;
            return n;
        }
        catch (Util.Exit exit) {
            int n = exit.exitValue;
            return n;
        }
        finally {
            this.log.flush();
        }
    }

    public void handleOptions(String[] stringArray) throws BadArgs {
        this.handleOptions(Arrays.asList(stringArray), true);
    }

    private void handleOptions(Iterable<String> iterable, boolean bl) throws BadArgs {
        Iterator<String> iterator2;
        if (this.log == null) {
            this.log = JavahTask.getPrintWriterForStream(System.out);
            if (this.diagnosticListener == null) {
                this.diagnosticListener = this.getDiagnosticListenerForStream(System.err);
            }
        } else if (this.diagnosticListener == null) {
            this.diagnosticListener = this.getDiagnosticListenerForWriter(this.log);
        }
        if (this.fileManager == null) {
            this.fileManager = JavahTask.getDefaultFileManager(this.diagnosticListener, this.log);
        }
        boolean bl2 = this.noArgs = !(iterator2 = this.expandAtArgs(iterable).iterator()).hasNext();
        while (iterator2.hasNext()) {
            String string = iterator2.next();
            if (string.startsWith("-")) {
                this.handleOption(string, iterator2);
                continue;
            }
            if (bl) {
                if (this.classes == null) {
                    this.classes = new ArrayList<String>();
                }
                this.classes.add(string);
                while (iterator2.hasNext()) {
                    this.classes.add(iterator2.next());
                }
                continue;
            }
            throw new BadArgs("err.unknown.option", string).showUsage(true);
        }
        if (!(this.classes != null && this.classes.size() != 0 || this.noArgs || this.help || this.version || this.fullVersion)) {
            throw new BadArgs("err.no.classes.specified", new Object[0]);
        }
        if (this.jni && this.llni) {
            throw new BadArgs("jni.llni.mixed", new Object[0]);
        }
        if (this.odir != null && this.ofile != null) {
            throw new BadArgs("dir.file.mixed", new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOption(String string, Iterator<String> iterator2) throws BadArgs {
        for (Option option : recognizedOptions) {
            if (!option.matches(string)) continue;
            if (option.hasArg) {
                if (!iterator2.hasNext()) throw new BadArgs("err.missing.arg", string).showUsage(true);
                option.process(this, string, iterator2.next());
            } else {
                option.process(this, string, null);
            }
            if (!option.ignoreRest()) return;
            while (iterator2.hasNext()) {
                iterator2.next();
            }
            return;
        }
        if (!this.fileManager.handleOption(string, iterator2)) throw new BadArgs("err.unknown.option", string).showUsage(true);
    }

    private Iterable<String> expandAtArgs(Iterable<String> iterable) throws BadArgs {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : iterable) {
                arrayList.add(string);
            }
            return Arrays.asList(CommandLine.parse(arrayList.toArray(new String[arrayList.size()])));
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            throw new BadArgs("at.args.file.not.found", iOException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new BadArgs("at.args.io.exception", iOException.getLocalizedMessage());
        }
    }

    @Override
    public Boolean call() {
        return this.run();
    }

    public boolean run() throws Util.Exit {
        JavaCompiler.CompilationTask compilationTask;
        Object object;
        Object object2;
        if (!this.javac_extras.contains("-XDsuppress-tool-removal-message")) {
            this.log.println(this.getMessage("javah.misc.Deprecation", new Object[0]));
        }
        Util util = new Util(this.log, this.diagnosticListener);
        if (this.noArgs || this.help) {
            this.showHelp();
            return this.help;
        }
        if (this.version || this.fullVersion) {
            this.showVersion(this.fullVersion);
            return true;
        }
        util.verbose = this.verbose;
        Gen gen = this.llni ? new LLNI(this.doubleAlign, util) : new JNI(util);
        if (this.ofile != null) {
            if (!(this.fileManager instanceof StandardJavaFileManager)) {
                this.diagnosticListener.report(this.createDiagnostic("err.cant.use.option.for.fm", "-o"));
                return false;
            }
            object2 = ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(Collections.singleton(this.ofile));
            object = object2.iterator().next();
            gen.setOutFile((JavaFileObject)object);
        } else {
            if (this.odir != null) {
                if (!(this.fileManager instanceof StandardJavaFileManager)) {
                    this.diagnosticListener.report(this.createDiagnostic("err.cant.use.option.for.fm", "-d"));
                    return false;
                }
                if (!this.odir.exists() && !this.odir.mkdirs()) {
                    util.error("cant.create.dir", this.odir.toString());
                }
                try {
                    ((StandardJavaFileManager)this.fileManager).setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(this.odir));
                }
                catch (IOException iOException) {
                    Object object3 = iOException.getLocalizedMessage();
                    if (object3 == null) {
                        object3 = iOException;
                    }
                    this.diagnosticListener.report(this.createDiagnostic("err.ioerror", this.odir, object3));
                    return false;
                }
            }
            gen.setFileManager(this.fileManager);
        }
        gen.setForce(this.force);
        if (this.fileManager instanceof JavahFileManager) {
            ((JavahFileManager)this.fileManager).setSymbolFileEnabled(false);
        }
        object2 = ToolProvider.getSystemJavaCompiler();
        object = new ArrayList();
        object.add("-proc:only");
        object.addAll(this.javac_extras);
        try {
            compilationTask = object2.getTask(this.log, this.fileManager, this.diagnosticListener, (Iterable<String>)object, this.classes, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            util.error("bad.arg", illegalArgumentException.getMessage());
            return false;
        }
        JavahProcessor javahProcessor = new JavahProcessor(gen);
        compilationTask.setProcessors(Collections.singleton(javahProcessor));
        boolean bl = compilationTask.call();
        if (javahProcessor.exit != null) {
            throw new Util.Exit(javahProcessor.exit);
        }
        return bl;
    }

    static StandardJavaFileManager getDefaultFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, PrintWriter printWriter) {
        return JavahFileManager.create(diagnosticListener, printWriter);
    }

    private void showHelp() {
        this.log.println(this.getMessage("main.usage", progname));
        Object[] objectArray = recognizedOptions;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Option option = objectArray[i];
            if (option.isHidden()) continue;
            Object object = option.aliases[0].substring(1);
            this.log.println(this.getMessage("main.opt." + (String)object, new Object[0]));
        }
        for (Object object : objectArray = new String[]{"--module-path", "--system", "--class-path", "-classpath", "-cp", "-bootclasspath"}) {
            if (this.fileManager.isSupportedOption((String)object) == -1) continue;
            String string = ((String)object).replaceAll("^-+", "").replaceAll("-+", "_");
            this.log.println(this.getMessage("main.opt." + string, new Object[0]));
        }
        this.log.println(this.getMessage("main.usage.foot", new Object[0]));
    }

    private void showVersion(boolean bl) {
        this.log.println(this.version(bl));
    }

    private String version(boolean bl) {
        String string;
        String string2 = bl ? "javah.fullVersion" : "javah.version";
        String string3 = string = bl ? "full" : "release";
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException missingResourceException) {
                return this.getMessage("version.resource.missing", System.getProperty("java.version"));
            }
        }
        try {
            return this.getMessage(string2, progname, versionRB.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return this.getMessage("version.unknown", System.getProperty("java.version"));
        }
    }

    private Diagnostic<JavaFileObject> createDiagnostic(final String string, final Object ... objectArray) {
        return new Diagnostic<JavaFileObject>(){

            @Override
            public Diagnostic.Kind getKind() {
                return Diagnostic.Kind.ERROR;
            }

            @Override
            public JavaFileObject getSource() {
                return null;
            }

            @Override
            public long getPosition() {
                return -1L;
            }

            @Override
            public long getStartPosition() {
                return -1L;
            }

            @Override
            public long getEndPosition() {
                return -1L;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public String getCode() {
                return string;
            }

            @Override
            public String getMessage(Locale locale) {
                return JavahTask.this.getMessage(locale, string, objectArray);
            }
        };
    }

    private String getMessage(String string, Object ... objectArray) {
        return this.getMessage(this.task_locale, string, objectArray);
    }

    private String getMessage(Locale locale, String string, Object ... objectArray) {
        ResourceBundle resourceBundle;
        if (this.bundles == null) {
            this.bundles = new HashMap<Locale, ResourceBundle>();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((resourceBundle = this.bundles.get(locale)) == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("org.openjdk.tools.javah.resources.l10n", locale);
                this.bundles.put(locale, resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {
                throw new InternalError("Cannot find javah resource bundle for locale " + locale, missingResourceException);
            }
        }
        try {
            return MessageFormat.format(resourceBundle.getString(string), objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    @SupportedAnnotationTypes(value={"*"})
    class JavahProcessor
    extends AbstractProcessor {
        private Messager messager;
        private TypeVisitor<Void, Types> checkMethodParametersVisitor = new SimpleTypeVisitor9<Void, Types>(){

            @Override
            public Void visitArray(ArrayType arrayType, Types types) {
                this.visit(arrayType.getComponentType(), types);
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType declaredType, Types types) {
                declaredType.asElement().getKind();
                for (TypeMirror typeMirror : types.directSupertypes(declaredType)) {
                    this.visit(typeMirror, types);
                }
                return null;
            }
        };
        private Gen g;
        private Util.Exit exit;

        JavahProcessor(Gen gen) {
            this.g = gen;
        }

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return SourceVersion.latest();
        }

        @Override
        public void init(ProcessingEnvironment processingEnvironment) {
            super.init(processingEnvironment);
            this.messager = this.processingEnv.getMessager();
        }

        @Override
        public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
            try {
                Set<TypeElement> set2 = this.getAllClasses(ElementFilter.typesIn(roundEnvironment.getRootElements()));
                if (set2.size() > 0) {
                    this.checkMethodParameters(set2);
                    this.g.setProcessingEnvironment(this.processingEnv);
                    this.g.setClasses(set2);
                    this.g.run();
                }
            }
            catch (Symbol.CompletionFailure completionFailure) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, JavahTask.this.getMessage("class.not.found", new Object[]{completionFailure.sym.getQualifiedName().toString()}));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, JavahTask.this.getMessage("class.not.found", new Object[]{classNotFoundException.getMessage()}));
            }
            catch (IOException iOException) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, JavahTask.this.getMessage("io.exception", new Object[]{iOException.getMessage()}));
            }
            catch (Util.Exit exit) {
                this.exit = exit;
            }
            return true;
        }

        private Set<TypeElement> getAllClasses(Set<? extends TypeElement> set) {
            LinkedHashSet<TypeElement> linkedHashSet = new LinkedHashSet<TypeElement>();
            this.getAllClasses0(set, linkedHashSet);
            return linkedHashSet;
        }

        private void getAllClasses0(Iterable<? extends TypeElement> iterable, Set<TypeElement> set) {
            for (TypeElement typeElement : iterable) {
                set.add(typeElement);
                this.getAllClasses0(ElementFilter.typesIn(typeElement.getEnclosedElements()), set);
            }
        }

        private void checkMethodParameters(Set<TypeElement> set) {
            Types types = this.processingEnv.getTypeUtils();
            for (TypeElement typeElement : set) {
                for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                    for (VariableElement variableElement : executableElement.getParameters()) {
                        TypeMirror typeMirror = variableElement.asType();
                        this.checkMethodParametersVisitor.visit(typeMirror, types);
                    }
                }
            }
        }
    }

    static abstract class HiddenOption
    extends Option {
        HiddenOption(boolean bl, String ... stringArray) {
            super(bl, stringArray);
        }

        @Override
        boolean isHidden() {
            return true;
        }
    }

    static abstract class Option {
        final boolean hasArg;
        final String[] aliases;

        Option(boolean bl, String ... stringArray) {
            this.hasArg = bl;
            this.aliases = stringArray;
        }

        boolean isHidden() {
            return false;
        }

        boolean matches(String string) {
            for (String string2 : this.aliases) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        boolean ignoreRest() {
            return false;
        }

        abstract void process(JavahTask var1, String var2, String var3) throws BadArgs;
    }

    public class BadArgs
    extends Exception {
        private static final long serialVersionUID = 1479361270874789045L;
        final String key;
        final Object[] args;
        boolean showUsage;

        BadArgs(String string, Object ... objectArray) {
            super(JavahTask.this.getMessage(string, objectArray));
            this.key = string;
            this.args = objectArray;
        }

        BadArgs showUsage(boolean bl) {
            this.showUsage = bl;
            return this;
        }
    }
}

