/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ConcreteReference;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.ReferenceWildcard;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@AutoValue
public abstract class ConcreteReference
implements Reference {
    private static final String EXTENDS = "extends";
    private static final String COMMA = ", ";
    private static final String DOT = ".";
    private static final String SPACE = " ";
    private static final String LEFT_ANGLE = "<";
    private static final String RIGHT_ANGLE = ">";
    private static final String QUESTION_MARK = "?";
    private static final Class<?> WILDCARD_CLAZZ = ReferenceWildcard.class;

    abstract Class<?> clazz();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Nullable
    public abstract Reference wildcardUpperBound();

    @Override
    public abstract ImmutableList<Reference> generics();

    @Override
    public abstract boolean isStaticImport();

    @Override
    public String name() {
        StringBuilder sb = new StringBuilder();
        if (this.isWildcard()) {
            sb.append(QUESTION_MARK);
            if (this.wildcardUpperBound() != null) {
                sb.append(SPACE);
                sb.append(EXTENDS);
                sb.append(SPACE);
                sb.append(this.wildcardUpperBound().name());
            }
        } else {
            if (this.hasEnclosingClass() && !this.isStaticImport()) {
                sb.append(this.clazz().getEnclosingClass().getSimpleName());
                sb.append(DOT);
            }
            sb.append(this.clazz().getSimpleName());
        }
        if (!this.generics().isEmpty()) {
            sb.append(LEFT_ANGLE);
            for (int i = 0; i < this.generics().size(); ++i) {
                Reference r = (Reference)this.generics().get(i);
                sb.append(r.name());
                if (i >= this.generics().size() - 1) continue;
                sb.append(COMMA);
            }
            sb.append(RIGHT_ANGLE);
        }
        return sb.toString();
    }

    @Override
    public String simpleName() {
        return this.clazz().getSimpleName();
    }

    @Override
    public String pakkage() {
        return this.clazz().getPackage().getName();
    }

    @Override
    public abstract boolean useFullName();

    @Override
    public ImmutableList<String> enclosingClassNames() {
        if (!this.hasEnclosingClass()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        Class<?> currentClz = this.clazz();
        while (currentClz.getEnclosingClass() != null) {
            listBuilder.add(currentClz.getEnclosingClass().getSimpleName());
            currentClz = currentClz.getEnclosingClass();
        }
        return listBuilder.build();
    }

    @Override
    public String fullName() {
        return this.clazz().getCanonicalName();
    }

    @Override
    public boolean hasEnclosingClass() {
        return this.clazz().getEnclosingClass() != null;
    }

    @Override
    public boolean isFromPackage(String pkg) {
        return this.clazz().getPackage().getName().equals(pkg);
    }

    @Override
    public boolean isSupertypeOrEquals(Reference other) {
        if (!this.isAssignableFrom(other)) {
            return false;
        }
        if (this.generics().size() == other.generics().size()) {
            for (int i = 0; i < this.generics().size(); ++i) {
                Reference otherGeneric;
                Reference thisGeneric = (Reference)this.generics().get(i);
                if (thisGeneric.isSupertypeOrEquals(otherGeneric = (Reference)other.generics().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isAssignableFrom(Reference other) {
        if (other instanceof VaporReference && ((VaporReference)other).supertypeReference() != null) {
            return this.isAssignableFrom(((VaporReference)other).supertypeReference());
        }
        if (!(other instanceof ConcreteReference)) {
            return false;
        }
        if (this.generics().size() == other.generics().size()) {
            for (int i = 0; i < this.generics().size(); ++i) {
                if (((Reference)this.generics().get(i)).isSupertypeOrEquals((Reference)other.generics().get(i))) continue;
                return false;
            }
        }
        return this.clazz().isAssignableFrom(((ConcreteReference)other).clazz());
    }

    @Override
    public boolean isWildcard() {
        return this.clazz().equals(WILDCARD_CLAZZ);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConcreteReference)) {
            return false;
        }
        ConcreteReference ref = (ConcreteReference)o;
        return this.clazz().equals(ref.clazz()) && this.generics().equals(ref.generics()) && Objects.equals(this.wildcardUpperBound(), ref.wildcardUpperBound());
    }

    public int hashCode() {
        int wildcardUpperBoundHash = this.wildcardUpperBound() == null ? 0 : 11 * this.wildcardUpperBound().hashCode();
        return 17 * this.clazz().hashCode() + 31 * this.generics().hashCode() + wildcardUpperBoundHash;
    }

    @Override
    public Reference copyAndSetGenerics(List<Reference> generics) {
        return this.toBuilder().setGenerics(generics).build();
    }

    public static ConcreteReference withClazz(Class<?> clazz) {
        return ConcreteReference.builder().setClazz(clazz).build();
    }

    public static ConcreteReference wildcard() {
        return ConcreteReference.withClazz(ReferenceWildcard.class);
    }

    public static ConcreteReference wildcardWithUpperBound(Reference upperBoundReference) {
        return ConcreteReference.builder().setClazz(WILDCARD_CLAZZ).setWildcardUpperBound(upperBoundReference).build();
    }

    public static Builder builder() {
        return new AutoValue_ConcreteReference.Builder().setUseFullName(false).setGenerics(ImmutableList.of()).setIsStaticImport(false);
    }

    abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setClazz(Class<?> var1);

        public abstract Builder setUseFullName(boolean var1);

        public abstract Builder setWildcardUpperBound(Reference var1);

        public Builder setGenerics(Reference ... references) {
            return this.setGenerics(Arrays.asList(references));
        }

        public abstract Builder setGenerics(List<Reference> var1);

        public abstract Builder setIsStaticImport(boolean var1);

        public abstract ConcreteReference autoBuild();

        abstract Class<?> clazz();

        abstract ImmutableList<Reference> generics();

        abstract boolean isStaticImport();

        public ConcreteReference build() {
            NodeValidator.checkNoNullElements(this.generics(), "generics", String.format("concrete reference %s", this.clazz().getSimpleName()));
            this.setIsStaticImport(this.clazz().getEnclosingClass() != null && this.isStaticImport());
            return this.autoBuild();
        }
    }
}

