/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Any;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.InternalLogId;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.MessagePrinter;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsResourceType;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryResponse;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class AbstractXdsClient {
    private final SynchronizationContext syncContext;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final Bootstrapper.ServerInfo serverInfo;
    private final ManagedChannel channel;
    private final XdsClient.XdsResponseHandler xdsResponseHandler;
    private final XdsClient.ResourceStore resourceStore;
    private final Context context;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Stopwatch stopwatch;
    private final EnvoyProtoData.Node bootstrapNode;
    private final Map<XdsResourceType<?>, String> versions = new HashMap();
    private boolean shutdown;
    @Nullable
    private AbstractAdsStream adsStream;
    @Nullable
    private BackoffPolicy retryBackoffPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle rpcRetryTimer;

    AbstractXdsClient(XdsClientImpl.XdsChannelFactory xdsChannelFactory, Bootstrapper.ServerInfo serverInfo, EnvoyProtoData.Node bootstrapNode, XdsClient.XdsResponseHandler xdsResponseHandler, XdsClient.ResourceStore resourceStore, Context context, ScheduledExecutorService timeService, SynchronizationContext syncContext, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.serverInfo = Preconditions.checkNotNull(serverInfo, "serverInfo");
        this.channel = Preconditions.checkNotNull(xdsChannelFactory, "xdsChannelFactory").create(serverInfo);
        this.xdsResponseHandler = Preconditions.checkNotNull(xdsResponseHandler, "xdsResponseHandler");
        this.resourceStore = Preconditions.checkNotNull(resourceStore, "resourcesSubscriber");
        this.bootstrapNode = Preconditions.checkNotNull(bootstrapNode, "bootstrapNode");
        this.context = Preconditions.checkNotNull(context, "context");
        this.timeService = Preconditions.checkNotNull(timeService, "timeService");
        this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.stopwatch = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier").get();
        this.logId = InternalLogId.allocate("xds-client", serverInfo.target());
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    Channel channel() {
        return this.channel;
    }

    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                AbstractXdsClient.this.shutdown = true;
                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutting down");
                if (AbstractXdsClient.this.adsStream != null) {
                    AbstractXdsClient.this.adsStream.close(Status.CANCELLED.withDescription("shutdown").asException());
                }
                if (AbstractXdsClient.this.rpcRetryTimer != null && AbstractXdsClient.this.rpcRetryTimer.isPending()) {
                    AbstractXdsClient.this.rpcRetryTimer.cancel();
                }
                AbstractXdsClient.this.channel.shutdown();
            }
        });
    }

    public String toString() {
        return this.logId.toString();
    }

    void adjustResourceSubscription(XdsResourceType<?> resourceType) {
        Collection<String> resources;
        if (this.isInBackoff()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
        }
        if ((resources = this.resourceStore.getSubscribedResources(this.serverInfo, resourceType)) != null) {
            this.adsStream.sendDiscoveryRequest(resourceType, resources);
        }
    }

    void ackResponse(XdsResourceType<?> type, String versionInfo, String nonce) {
        this.versions.put(type, versionInfo);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending ACK for {0} update, nonce: {1}, current version: {2}", type.typeName(), nonce, versionInfo);
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, null);
    }

    void nackResponse(XdsResourceType<?> type, String nonce, String errorDetail) {
        String versionInfo = this.versions.getOrDefault(type, "");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending NACK for {0} update, nonce: {1}, current version: {2}", type.typeName(), nonce, versionInfo);
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, errorDetail);
    }

    boolean isInBackoff() {
        return this.rpcRetryTimer != null && this.rpcRetryTimer.isPending();
    }

    private void startRpcStream() {
        Preconditions.checkState(this.adsStream == null, "Previous adsStream has not been cleared yet");
        this.adsStream = this.serverInfo.useProtocolV3() ? new AdsStreamV3() : new AdsStreamV2();
        Context prevContext = this.context.attach();
        try {
            this.adsStream.start();
        }
        finally {
            this.context.detach(prevContext);
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "ADS stream started");
        this.stopwatch.reset().start();
    }

    @Nullable
    @VisibleForTesting
    XdsResourceType<?> fromTypeUrl(String typeUrl) {
        return this.resourceStore.getSubscribedResourceTypesWithTypeUrl().get(typeUrl);
    }

    private final class AdsStreamV3
    extends AbstractAdsStream {
        private StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest> requestWriter;

        private AdsStreamV3() {
        }

        @Override
        void start() {
            AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stub = io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc.newStub(AbstractXdsClient.this.channel);
            StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse> responseReader = new StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse>(){

                @Override
                public void onNext(final io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse response) {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            XdsResourceType<?> type = AbstractXdsClient.this.fromTypeUrl(response.getTypeUrl());
                            if (AbstractXdsClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", type, MessagePrinter.print(response));
                            }
                            AdsStreamV3.this.handleRpcResponse(type, response.getVersionInfo(), response.getResourcesList(), response.getNonce());
                        }
                    });
                }

                @Override
                public void onError(final Throwable t) {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV3.this.handleRpcError(t);
                        }
                    });
                }

                @Override
                public void onCompleted() {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV3.this.handleRpcCompleted();
                        }
                    });
                }
            };
            this.requestWriter = ((AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub)stub.withWaitForReady()).streamAggregatedResources(responseReader);
        }

        @Override
        void sendDiscoveryRequest(XdsResourceType<?> type, String versionInfo, Collection<String> resources, String nonce, @Nullable String errorDetail) {
            Preconditions.checkState(this.requestWriter != null, "ADS stream has not been started");
            DiscoveryRequest.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest.newBuilder().setVersionInfo(versionInfo).setNode(AbstractXdsClient.this.bootstrapNode.toEnvoyProtoNode()).addAllResourceNames(resources).setTypeUrl(type.typeUrl()).setResponseNonce(nonce);
            if (errorDetail != null) {
                com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(errorDetail).build();
                builder.setErrorDetail(error);
            }
            io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest request = builder.build();
            this.requestWriter.onNext(request);
            if (AbstractXdsClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", MessagePrinter.print(request));
            }
        }

        @Override
        void sendError(Exception error) {
            this.requestWriter.onError(error);
        }
    }

    private final class AdsStreamV2
    extends AbstractAdsStream {
        private StreamObserver<DiscoveryRequest> requestWriter;

        private AdsStreamV2() {
        }

        @Override
        void start() {
            AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stub = AggregatedDiscoveryServiceGrpc.newStub(AbstractXdsClient.this.channel);
            StreamObserver<DiscoveryResponse> responseReaderV2 = new StreamObserver<DiscoveryResponse>(){

                @Override
                public void onNext(final DiscoveryResponse response) {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            XdsResourceType<?> type = AbstractXdsClient.this.fromTypeUrl(response.getTypeUrl());
                            if (AbstractXdsClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", type, MessagePrinter.print(response));
                            }
                            AdsStreamV2.this.handleRpcResponse(type, response.getVersionInfo(), response.getResourcesList(), response.getNonce());
                        }
                    });
                }

                @Override
                public void onError(final Throwable t) {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV2.this.handleRpcError(t);
                        }
                    });
                }

                @Override
                public void onCompleted() {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV2.this.handleRpcCompleted();
                        }
                    });
                }
            };
            this.requestWriter = ((AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub)stub.withWaitForReady()).streamAggregatedResources(responseReaderV2);
        }

        @Override
        void sendDiscoveryRequest(XdsResourceType<?> type, String versionInfo, Collection<String> resources, String nonce, @Nullable String errorDetail) {
            Preconditions.checkState(this.requestWriter != null, "ADS stream has not been started");
            DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setVersionInfo(versionInfo).setNode(AbstractXdsClient.this.bootstrapNode.toEnvoyProtoNodeV2()).addAllResourceNames(resources).setTypeUrl(type.typeUrlV2()).setResponseNonce(nonce);
            if (errorDetail != null) {
                com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(errorDetail).build();
                builder.setErrorDetail(error);
            }
            DiscoveryRequest request = builder.build();
            this.requestWriter.onNext(request);
            if (AbstractXdsClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", MessagePrinter.print(request));
            }
        }

        @Override
        void sendError(Exception error) {
            this.requestWriter.onError(error);
        }
    }

    private abstract class AbstractAdsStream {
        private boolean responseReceived;
        private boolean closed;
        private final Map<XdsResourceType<?>, String> respNonces = new HashMap();

        private AbstractAdsStream() {
        }

        abstract void start();

        abstract void sendError(Exception var1);

        abstract void sendDiscoveryRequest(XdsResourceType<?> var1, String var2, Collection<String> var3, String var4, @Nullable String var5);

        final void sendDiscoveryRequest(XdsResourceType<?> type, Collection<String> resources) {
            AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending {0} request for resources: {1}", type, resources);
            this.sendDiscoveryRequest(type, AbstractXdsClient.this.versions.getOrDefault(type, ""), resources, this.respNonces.getOrDefault(type, ""), null);
        }

        final void handleRpcResponse(XdsResourceType<?> type, String versionInfo, List<Any> resources, String nonce) {
            if (this.closed) {
                return;
            }
            this.responseReceived = true;
            if (type != null) {
                this.respNonces.put(type, nonce);
            }
            AbstractXdsClient.this.xdsResponseHandler.handleResourceResponse(type, AbstractXdsClient.this.serverInfo, versionInfo, resources, nonce);
        }

        final void handleRpcError(Throwable t) {
            this.handleRpcStreamClosed(Status.fromThrowable(t));
        }

        final void handleRpcCompleted() {
            this.handleRpcStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
        }

        private void handleRpcStreamClosed(Status error) {
            Preconditions.checkArgument(!error.isOk(), "unexpected OK status");
            if (this.closed) {
                return;
            }
            AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "ADS stream closed with status {0}: {1}. Cause: {2}", new Object[]{error.getCode(), error.getDescription(), error.getCause()});
            this.closed = true;
            AbstractXdsClient.this.xdsResponseHandler.handleStreamClosed(error);
            this.cleanUp();
            if (this.responseReceived || AbstractXdsClient.this.retryBackoffPolicy == null) {
                AbstractXdsClient.this.retryBackoffPolicy = AbstractXdsClient.this.backoffPolicyProvider.get();
            }
            long delayNanos = Math.max(0L, AbstractXdsClient.this.retryBackoffPolicy.nextBackoffNanos() - AbstractXdsClient.this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
            AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry ADS stream in {0} ns", delayNanos);
            AbstractXdsClient.this.rpcRetryTimer = AbstractXdsClient.this.syncContext.schedule(new RpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, AbstractXdsClient.this.timeService);
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.sendError(error);
        }

        private void cleanUp() {
            if (AbstractXdsClient.this.adsStream == this) {
                AbstractXdsClient.this.adsStream = null;
            }
        }
    }

    @VisibleForTesting
    final class RpcRetryTask
    implements Runnable {
        RpcRetryTask() {
        }

        @Override
        public void run() {
            if (AbstractXdsClient.this.shutdown) {
                return;
            }
            AbstractXdsClient.this.startRpcStream();
            HashSet subscribedResourceTypes = new HashSet(AbstractXdsClient.this.resourceStore.getSubscribedResourceTypesWithTypeUrl().values());
            for (XdsResourceType xdsResourceType : subscribedResourceTypes) {
                Collection<String> resources = AbstractXdsClient.this.resourceStore.getSubscribedResources(AbstractXdsClient.this.serverInfo, xdsResourceType);
                if (resources == null) continue;
                AbstractXdsClient.this.adsStream.sendDiscoveryRequest(xdsResourceType, resources);
            }
            AbstractXdsClient.this.xdsResponseHandler.handleStreamRestarted(AbstractXdsClient.this.serverInfo);
        }
    }
}

