/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.LoadBalancerRegistry;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class XdsResourceType<T extends XdsClient.ResourceUpdate> {
    static final String TYPE_URL_RESOURCE_V2 = "type.googleapis.com/envoy.api.v2.Resource";
    static final String TYPE_URL_RESOURCE_V3 = "type.googleapis.com/envoy.service.discovery.v3.Resource";
    static final String TRANSPORT_SOCKET_NAME_TLS = "envoy.transport_sockets.tls";
    @VisibleForTesting
    static final String AGGREGATE_CLUSTER_TYPE_NAME = "envoy.clusters.aggregate";
    @VisibleForTesting
    static final String HASH_POLICY_FILTER_STATE_KEY = "io.grpc.channel_id";
    @VisibleForTesting
    static boolean enableFaultInjection = XdsResourceType.getFlag("GRPC_XDS_EXPERIMENTAL_FAULT_INJECTION", true);
    @VisibleForTesting
    static boolean enableRetry = XdsResourceType.getFlag("GRPC_XDS_EXPERIMENTAL_ENABLE_RETRY", true);
    @VisibleForTesting
    static boolean enableRbac = XdsResourceType.getFlag("GRPC_XDS_EXPERIMENTAL_RBAC", true);
    @VisibleForTesting
    static boolean enableRouteLookup = XdsResourceType.getFlag("GRPC_EXPERIMENTAL_XDS_RLS_LB", false);
    @VisibleForTesting
    static boolean enableLeastRequest = !Strings.isNullOrEmpty(System.getenv("GRPC_EXPERIMENTAL_ENABLE_LEAST_REQUEST")) ? Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_ENABLE_LEAST_REQUEST")) : Boolean.parseBoolean(System.getProperty("io.grpc.xds.experimentalEnableLeastRequest"));
    @VisibleForTesting
    static boolean enableCustomLbConfig = XdsResourceType.getFlag("GRPC_EXPERIMENTAL_XDS_CUSTOM_LB_CONFIG", true);
    @VisibleForTesting
    static boolean enableOutlierDetection = XdsResourceType.getFlag("GRPC_EXPERIMENTAL_ENABLE_OUTLIER_DETECTION", true);
    static final String TYPE_URL_CLUSTER_CONFIG_V2 = "type.googleapis.com/envoy.config.cluster.aggregate.v2alpha.ClusterConfig";
    static final String TYPE_URL_CLUSTER_CONFIG = "type.googleapis.com/envoy.extensions.clusters.aggregate.v3.ClusterConfig";
    static final String TYPE_URL_TYPED_STRUCT_UDPA = "type.googleapis.com/udpa.type.v1.TypedStruct";
    static final String TYPE_URL_TYPED_STRUCT = "type.googleapis.com/xds.type.v3.TypedStruct";

    XdsResourceType() {
    }

    @Nullable
    abstract String extractResourceName(Message var1);

    abstract Class<? extends Message> unpackedClassName();

    abstract String typeName();

    abstract String typeUrl();

    abstract String typeUrlV2();

    @Nullable
    abstract XdsResourceType<?> dependentResource();

    ValidatedResourceUpdate<T> parse(Args args2, List<Any> resources) {
        HashMap parsedResources = new HashMap(resources.size());
        HashSet<String> unpackedResources = new HashSet<String>(resources.size());
        HashSet<String> invalidResources = new HashSet<String>();
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<String> retainedResources = new HashSet<String>();
        for (int i = 0; i < resources.size(); ++i) {
            T resourceUpdate;
            Message unpackedMessage;
            boolean isResourceV3;
            Any resource = resources.get(i);
            try {
                resource = this.maybeUnwrapResources(resource);
                isResourceV3 = resource.getTypeUrl().equals(this.typeUrl());
                unpackedMessage = XdsResourceType.unpackCompatibleType(resource, this.unpackedClassName(), this.typeUrl(), this.typeUrlV2());
            }
            catch (InvalidProtocolBufferException e) {
                errors.add(String.format("%s response Resource index %d - can't decode %s: %s", this.typeName(), i, this.unpackedClassName().getSimpleName(), e.getMessage()));
                continue;
            }
            String name = this.extractResourceName(unpackedMessage);
            if (name == null || !XdsClient.isResourceNameValid(name, resource.getTypeUrl())) {
                errors.add("Unsupported resource name: " + name + " for type: " + this.typeName());
                continue;
            }
            String cname = XdsClient.canonifyResourceName(name);
            if (args2.subscribedResources != null && !args2.subscribedResources.contains(name)) continue;
            unpackedResources.add(cname);
            try {
                resourceUpdate = this.doParse(args2, unpackedMessage, retainedResources, isResourceV3);
            }
            catch (XdsClientImpl.ResourceInvalidException e) {
                errors.add(String.format("%s response %s '%s' validation error: %s", this.typeName(), this.unpackedClassName().getSimpleName(), cname, e.getMessage()));
                invalidResources.add(cname);
                continue;
            }
            parsedResources.put(cname, new ParsedResource<T>(resourceUpdate, resource));
        }
        return new ValidatedResourceUpdate(parsedResources, unpackedResources, invalidResources, errors, retainedResources);
    }

    abstract T doParse(Args var1, Message var2, Set<String> var3, boolean var4) throws XdsClientImpl.ResourceInvalidException;

    static <T extends Message> T unpackCompatibleType(Any any, Class<T> clazz, String typeUrl, String compatibleTypeUrl) throws InvalidProtocolBufferException {
        if (any.getTypeUrl().equals(compatibleTypeUrl)) {
            any = any.toBuilder().setTypeUrl(typeUrl).build();
        }
        return any.unpack(clazz);
    }

    private Any maybeUnwrapResources(Any resource) throws InvalidProtocolBufferException {
        if (resource.getTypeUrl().equals(TYPE_URL_RESOURCE_V2) || resource.getTypeUrl().equals(TYPE_URL_RESOURCE_V3)) {
            return XdsResourceType.unpackCompatibleType(resource, Resource.class, TYPE_URL_RESOURCE_V3, TYPE_URL_RESOURCE_V2).getResource();
        }
        return resource;
    }

    private static boolean getFlag(String envVarName, boolean enableByDefault) {
        String envVar = System.getenv(envVarName);
        if (enableByDefault) {
            return Strings.isNullOrEmpty(envVar) || Boolean.parseBoolean(envVar);
        }
        return !Strings.isNullOrEmpty(envVar) && Boolean.parseBoolean(envVar);
    }

    @VisibleForTesting
    static final class StructOrError<T> {
        private final String errorDetail;
        private final T struct;

        static <T> StructOrError<T> fromStruct(T struct) {
            return new StructOrError<T>(struct);
        }

        static <T> StructOrError<T> fromError(String errorDetail) {
            return new StructOrError<T>(errorDetail);
        }

        private StructOrError(T struct) {
            this.struct = Preconditions.checkNotNull(struct, "struct");
            this.errorDetail = null;
        }

        private StructOrError(String errorDetail) {
            this.struct = null;
            this.errorDetail = Preconditions.checkNotNull(errorDetail, "errorDetail");
        }

        @Nullable
        @VisibleForTesting
        T getStruct() {
            return this.struct;
        }

        @Nullable
        @VisibleForTesting
        String getErrorDetail() {
            return this.errorDetail;
        }
    }

    static final class ValidatedResourceUpdate<T extends XdsClient.ResourceUpdate> {
        Map<String, ParsedResource<T>> parsedResources;
        Set<String> unpackedResources;
        Set<String> invalidResources;
        List<String> errors;
        Set<String> retainedResources;

        public ValidatedResourceUpdate(Map<String, ParsedResource<T>> parsedResources, Set<String> unpackedResources, Set<String> invalidResources, List<String> errors, Set<String> retainedResources) {
            this.parsedResources = parsedResources;
            this.unpackedResources = unpackedResources;
            this.invalidResources = invalidResources;
            this.errors = errors;
            this.retainedResources = retainedResources;
        }
    }

    static final class ParsedResource<T extends XdsClient.ResourceUpdate> {
        private final T resourceUpdate;
        private final Any rawResource;

        public ParsedResource(T resourceUpdate, Any rawResource) {
            this.resourceUpdate = (XdsClient.ResourceUpdate)Preconditions.checkNotNull(resourceUpdate, "resourceUpdate");
            this.rawResource = Preconditions.checkNotNull(rawResource, "rawResource");
        }

        T getResourceUpdate() {
            return this.resourceUpdate;
        }

        Any getRawResource() {
            return this.rawResource;
        }
    }

    static class Args {
        final Bootstrapper.ServerInfo serverInfo;
        final String versionInfo;
        final String nonce;
        final Bootstrapper.BootstrapInfo bootstrapInfo;
        final FilterRegistry filterRegistry;
        final LoadBalancerRegistry loadBalancerRegistry;
        final TlsContextManager tlsContextManager;
        @Nullable
        final Set<String> subscribedResources;

        public Args(Bootstrapper.ServerInfo serverInfo, String versionInfo, String nonce, Bootstrapper.BootstrapInfo bootstrapInfo, FilterRegistry filterRegistry, LoadBalancerRegistry loadBalancerRegistry, TlsContextManager tlsContextManager, @Nullable Set<String> subscribedResources) {
            this.serverInfo = serverInfo;
            this.versionInfo = versionInfo;
            this.nonce = nonce;
            this.bootstrapInfo = bootstrapInfo;
            this.filterRegistry = filterRegistry;
            this.loadBalancerRegistry = loadBalancerRegistry;
            this.tlsContextManager = tlsContextManager;
            this.subscribedResources = subscribedResources;
        }
    }
}

