/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.options;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.tools.sjavac.CopyFile;
import org.openjdk.tools.sjavac.Transformer;
import org.openjdk.tools.sjavac.options.ArgumentIterator;
import org.openjdk.tools.sjavac.options.OptionHelper;

public enum Option {
    SRC("-src", "Location of source files to be compiled"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            List<Path> list = this.getFileListArg(argumentIterator, optionHelper);
            if (list != null) {
                optionHelper.sourceRoots(list);
            }
        }
    }
    ,
    SOURCE_PATH("--source-path", "Specify search path for sources."){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            List<Path> list = this.getFileListArg(argumentIterator, optionHelper);
            if (list != null) {
                optionHelper.sourcepath(list);
            }
        }
    }
    ,
    SOURCEPATH("-sourcepath", "An alias for -sourcepath"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            SOURCE_PATH.processMatching(argumentIterator, optionHelper);
        }
    }
    ,
    MODULE_PATH("--module-path", "Specify search path for modules."){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            List<Path> list = this.getFileListArg(argumentIterator, optionHelper);
            if (list != null) {
                optionHelper.modulepath(list);
            }
        }
    }
    ,
    P("-p", "An alias for --module-path"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            MODULE_PATH.processMatching(argumentIterator, optionHelper);
        }
    }
    ,
    CLASS_PATH("--class-path", "Specify search path for classes."){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            List<Path> list = this.getFileListArg(argumentIterator, optionHelper);
            if (list != null) {
                optionHelper.classpath(list);
            }
        }
    }
    ,
    CLASSPATH("-classpath", "An alias for -classpath."){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            CLASS_PATH.processMatching(argumentIterator, optionHelper);
        }
    }
    ,
    CP("-cp", "An alias for -classpath"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            CLASS_PATH.processMatching(argumentIterator, optionHelper);
        }
    }
    ,
    X("-x", "Exclude files matching the given pattern"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            String string = this.getFilePatternArg(argumentIterator, optionHelper);
            if (string != null) {
                optionHelper.exclude(string);
            }
        }
    }
    ,
    I("-i", "Include only files matching the given pattern"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            String string = this.getFilePatternArg(argumentIterator, optionHelper);
            if (string != null) {
                optionHelper.include(string);
            }
        }
    }
    ,
    TR("-tr", "Translate resources"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            if (!argumentIterator.hasNext()) {
                optionHelper.reportError(this.arg + " must be followed by a translation rule");
                return;
            }
            String string = argumentIterator.next();
            String string2 = "[a-zA-Z_][a-zA-Z0-9_]*";
            Pattern pattern = Pattern.compile("(?<suffix>\\." + string2 + ")=(?<class>" + string2 + "(\\." + string2 + ")*)(?<extra>,.*)?");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) {
                optionHelper.reportError("The string \"" + string + "\" is not a valid translate pattern");
                return;
            }
            String string3 = matcher.group("suffix");
            String string4 = matcher.group("class");
            String string5 = matcher.group("extra");
            if (string3.matches("\\.(class|java)")) {
                optionHelper.reportError("You cannot have a translator for " + string3 + " files!");
                return;
            }
            try {
                Class<?> clazz = Class.forName(string4);
                Transformer transformer = (Transformer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                transformer.setExtra(string5);
                optionHelper.addTransformer(string3, transformer);
            }
            catch (Exception exception) {
                optionHelper.reportError("Cannot use " + string4 + " as a translator: " + exception.getMessage());
            }
        }
    }
    ,
    COPY("-copy", "Copy resources"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            if (!argumentIterator.hasNext()) {
                optionHelper.reportError(this.arg + " must be followed by a resource type");
                return;
            }
            String string = argumentIterator.next();
            if (!string.matches("\\.[a-zA-Z_][a-zA-Z0-9_]*")) {
                optionHelper.reportError("The string \"" + string + "\" is not a valid resource type.");
                return;
            }
            optionHelper.addTransformer(string, new CopyFile());
        }
    }
    ,
    J("-j", "Number of cores"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            if (!argumentIterator.hasNext() || !argumentIterator.peek().matches("\\d+")) {
                optionHelper.reportError(this.arg + " must be followed by an integer");
                return;
            }
            optionHelper.numCores(Integer.parseInt(argumentIterator.next()));
        }
    }
    ,
    SERVER("--server:", "Specify server configuration file of running server"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            optionHelper.serverConf(argumentIterator.current().substring(this.arg.length()));
        }
    }
    ,
    STARTSERVER("--startserver:", "Start server and use the given configuration file"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            optionHelper.startServerConf(argumentIterator.current().substring(this.arg.length()));
        }
    }
    ,
    IMPLICIT("-implicit:", "Specify how to treat implicitly referenced source code"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            optionHelper.implicit(argumentIterator.current().substring(this.arg.length()));
        }
    }
    ,
    LOG("--log=", "Specify logging level"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            optionHelper.logLevel(argumentIterator.current().substring(this.arg.length()));
        }
    }
    ,
    VERBOSE("-verbose", "Set verbosity level to \"info\""){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            optionHelper.logLevel("info");
        }
    }
    ,
    PERMIT_ARTIFACT("--permit-artifact=", "Allow this artifact in destination directory"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            String string = argumentIterator.current().substring(this.arg.length());
            optionHelper.permitArtifact(Paths.get(string, new String[0]).toFile().getAbsolutePath());
        }
    }
    ,
    PERMIT_UNIDENTIFIED_ARTIFACTS("--permit-unidentified-artifacts", "Allow unidentified artifacts in destination directory"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            optionHelper.permitUnidentifiedArtifacts();
        }
    }
    ,
    PERMIT_SOURCES_WITHOUT_PACKAGE("--permit-sources-without-package", "Permit sources in the default package"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            optionHelper.permitDefaultPackage();
        }
    }
    ,
    COMPARE_FOUND_SOURCES("--compare-found-sources", "Compare found sources with given sources"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            Path path = this.getFileArg(argumentIterator, optionHelper, true, false);
            if (path != null) {
                optionHelper.compareFoundSources(path);
            }
        }
    }
    ,
    D("-d", "Output destination directory"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            Path path = this.getFileArg(argumentIterator, optionHelper, false, true);
            if (path != null) {
                optionHelper.destDir(path);
            }
        }
    }
    ,
    S("-s", "Directory for generated sources"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            Path path = this.getFileArg(argumentIterator, optionHelper, false, true);
            if (path != null) {
                optionHelper.generatedSourcesDir(path);
            }
        }
    }
    ,
    H("-h", "Directory for header files"){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            Path path = this.getFileArg(argumentIterator, optionHelper, false, true);
            if (path != null) {
                optionHelper.headerDir(path);
            }
        }
    }
    ,
    STATE_DIR("--state-dir=", "Directory used to store sjavac state and log files."){

        @Override
        protected void processMatching(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
            String string = argumentIterator.current().substring(this.arg.length());
            optionHelper.stateDir(Paths.get(string, new String[0]));
        }
    };

    public final String arg;
    final String description;

    private Option(String string2, String string3) {
        this.arg = string2;
        this.description = string3;
    }

    List<Path> getFileListArg(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
        if (!argumentIterator.hasNext()) {
            optionHelper.reportError(this.arg + " must be followed by a list of files separated by " + File.pathSeparator);
            return null;
        }
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (String string : argumentIterator.next().split(File.pathSeparator)) {
            arrayList.add(Paths.get(string, new String[0]));
        }
        return arrayList;
    }

    Path getFileArg(ArgumentIterator argumentIterator, OptionHelper optionHelper, boolean bl, boolean bl2) {
        if (!argumentIterator.hasNext()) {
            String string = this.arg + " must be followed by ";
            if (bl && bl2) {
                string = string + "a file or directory.";
            } else if (bl) {
                string = string + "a file.";
            } else if (bl2) {
                string = string + "a directory.";
            } else {
                throw new IllegalArgumentException("File or directory must be acceptable.");
            }
            optionHelper.reportError(string);
            return null;
        }
        return Paths.get(argumentIterator.next(), new String[0]);
    }

    String getFilePatternArg(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
        if (!argumentIterator.hasNext()) {
            optionHelper.reportError(this.arg + " must be followed by a glob pattern.");
            return null;
        }
        return argumentIterator.next();
    }

    public boolean hasOption() {
        return this.arg.endsWith(":") || this.arg.endsWith("=");
    }

    public final boolean processCurrent(ArgumentIterator argumentIterator, OptionHelper optionHelper) {
        String string = argumentIterator.current();
        if (this.hasOption() ? string.startsWith(this.arg) : string.equals(this.arg)) {
            this.processMatching(argumentIterator, optionHelper);
            return true;
        }
        return false;
    }

    protected abstract void processMatching(ArgumentIterator var1, OptionHelper var2);
}

