/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer;

import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.gapic.composer.ClientLibraryPackageInfoComposer;
import com.google.api.generator.gapic.composer.comment.CommentComposer;
import com.google.api.generator.gapic.composer.grpc.GrpcServiceCallableFactoryClassComposer;
import com.google.api.generator.gapic.composer.grpc.GrpcServiceStubClassComposer;
import com.google.api.generator.gapic.composer.grpc.MockServiceClassComposer;
import com.google.api.generator.gapic.composer.grpc.MockServiceImplClassComposer;
import com.google.api.generator.gapic.composer.grpc.ServiceClientClassComposer;
import com.google.api.generator.gapic.composer.grpc.ServiceSettingsClassComposer;
import com.google.api.generator.gapic.composer.grpc.ServiceStubClassComposer;
import com.google.api.generator.gapic.composer.grpc.ServiceStubSettingsClassComposer;
import com.google.api.generator.gapic.composer.grpcrest.HttpJsonServiceClientTestClassComposer;
import com.google.api.generator.gapic.composer.resourcename.ResourceNameHelperClassComposer;
import com.google.api.generator.gapic.composer.rest.HttpJsonServiceCallableFactoryClassComposer;
import com.google.api.generator.gapic.composer.rest.HttpJsonServiceStubClassComposer;
import com.google.api.generator.gapic.composer.rest.ServiceClientTestClassComposer;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicPackageInfo;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Sample;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.model.Transport;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Composer {
    public static List<GapicClass> composeServiceClasses(GapicContext context) {
        ArrayList<GapicClass> clazzes = new ArrayList<GapicClass>();
        clazzes.addAll(Composer.generateServiceClasses(context));
        clazzes.addAll(Composer.generateMockClasses(context, context.mixinServices()));
        clazzes.addAll(Composer.generateResourceNameHelperClasses(context));
        return Composer.addApacheLicense(Composer.prepareExecutableSamples(clazzes));
    }

    public static GapicPackageInfo composePackageInfo(GapicContext context) {
        return Composer.addApacheLicense(ClientLibraryPackageInfoComposer.generatePackageInfo(context));
    }

    public static List<GapicClass> generateServiceClasses(GapicContext context) {
        ArrayList<GapicClass> clazzes = new ArrayList<GapicClass>();
        clazzes.addAll(Composer.generateStubClasses(context));
        clazzes.addAll(Composer.generateClientSettingsClasses(context));
        clazzes.addAll(Composer.generateMockClasses(context, context.services()));
        clazzes.addAll(Composer.generateTestClasses(context));
        return clazzes;
    }

    public static List<GapicClass> generateResourceNameHelperClasses(GapicContext context) {
        return context.helperResourceNames().values().stream().distinct().filter(r -> !r.isOnlyWildcard()).map(r -> ResourceNameHelperClassComposer.instance().generate((ResourceName)r, context)).collect(Collectors.toList());
    }

    public static List<GapicClass> generateStubClasses(GapicContext context) {
        ArrayList<GapicClass> clazzes = new ArrayList<GapicClass>();
        context.services().forEach(s2 -> {
            if (context.transport() == Transport.REST) {
                clazzes.add(com.google.api.generator.gapic.composer.rest.ServiceStubClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(com.google.api.generator.gapic.composer.rest.ServiceStubSettingsClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(HttpJsonServiceCallableFactoryClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(HttpJsonServiceStubClassComposer.instance().generate(context, (Service)s2));
            } else if (context.transport() == Transport.GRPC) {
                clazzes.add(ServiceStubClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(ServiceStubSettingsClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(GrpcServiceCallableFactoryClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(GrpcServiceStubClassComposer.instance().generate(context, (Service)s2));
            } else if (context.transport() == Transport.GRPC_REST) {
                clazzes.add(com.google.api.generator.gapic.composer.grpcrest.ServiceStubClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(com.google.api.generator.gapic.composer.grpcrest.ServiceStubSettingsClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(GrpcServiceCallableFactoryClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(GrpcServiceStubClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(HttpJsonServiceCallableFactoryClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(com.google.api.generator.gapic.composer.grpcrest.HttpJsonServiceStubClassComposer.instance().generate(context, (Service)s2));
            }
        });
        return clazzes;
    }

    public static List<GapicClass> generateClientSettingsClasses(GapicContext context) {
        ArrayList<GapicClass> clazzes = new ArrayList<GapicClass>();
        context.services().forEach(s2 -> {
            if (context.transport() == Transport.REST) {
                clazzes.add(com.google.api.generator.gapic.composer.rest.ServiceClientClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(com.google.api.generator.gapic.composer.rest.ServiceSettingsClassComposer.instance().generate(context, (Service)s2));
            } else if (context.transport() == Transport.GRPC) {
                clazzes.add(ServiceClientClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(ServiceSettingsClassComposer.instance().generate(context, (Service)s2));
            } else if (context.transport() == Transport.GRPC_REST) {
                clazzes.add(com.google.api.generator.gapic.composer.grpcrest.ServiceClientClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(com.google.api.generator.gapic.composer.grpcrest.ServiceSettingsClassComposer.instance().generate(context, (Service)s2));
            }
        });
        return clazzes;
    }

    public static List<GapicClass> generateMockClasses(GapicContext context, List<Service> services) {
        ArrayList<GapicClass> clazzes = new ArrayList<GapicClass>();
        services.forEach(s2 -> {
            if (context.transport() != Transport.REST) {
                if (context.transport() == Transport.GRPC) {
                    clazzes.add(MockServiceClassComposer.instance().generate(context, (Service)s2));
                    clazzes.add(MockServiceImplClassComposer.instance().generate(context, (Service)s2));
                } else if (context.transport() == Transport.GRPC_REST) {
                    clazzes.add(MockServiceClassComposer.instance().generate(context, (Service)s2));
                    clazzes.add(MockServiceImplClassComposer.instance().generate(context, (Service)s2));
                }
            }
        });
        return clazzes;
    }

    public static List<GapicClass> generateTestClasses(GapicContext context) {
        ArrayList<GapicClass> clazzes = new ArrayList<GapicClass>();
        context.services().forEach(s2 -> {
            if (context.transport() == Transport.REST) {
                clazzes.add(ServiceClientTestClassComposer.instance().generate(context, (Service)s2));
            } else if (context.transport() == Transport.GRPC) {
                clazzes.add(com.google.api.generator.gapic.composer.grpc.ServiceClientTestClassComposer.instance().generate(context, (Service)s2));
            } else if (context.transport() == Transport.GRPC_REST) {
                clazzes.add(com.google.api.generator.gapic.composer.grpc.ServiceClientTestClassComposer.instance().generate(context, (Service)s2));
                clazzes.add(HttpJsonServiceClientTestClassComposer.instance().generate(context, (Service)s2));
            }
        });
        return clazzes;
    }

    @VisibleForTesting
    static List<GapicClass> prepareExecutableSamples(List<GapicClass> clazzes) {
        ArrayList<GapicClass> clazzesWithSamples = new ArrayList<GapicClass>();
        clazzes.forEach(gapicClass -> {
            ArrayList<Sample> samples = new ArrayList<Sample>();
            gapicClass.samples().forEach(sample -> samples.add(Composer.addRegionTagAndHeaderToSample(sample, gapicClass.apiShortName(), gapicClass.apiVersion())));
            clazzesWithSamples.add(gapicClass.withSamples(samples));
        });
        return clazzesWithSamples;
    }

    @VisibleForTesting
    protected static Sample addRegionTagAndHeaderToSample(Sample sample, String apiShortName, String apiVersion) {
        List<CommentStatement> header = Arrays.asList(CommentComposer.APACHE_LICENSE_COMMENT);
        return sample.withHeader(header).withRegionTag(sample.regionTag().withApiVersion(apiVersion).withApiShortName(apiShortName));
    }

    @VisibleForTesting
    protected static List<GapicClass> addApacheLicense(List<GapicClass> gapicClassList) {
        return gapicClassList.stream().map(gapicClass -> {
            ClassDefinition classWithHeader = gapicClass.classDefinition().toBuilder().setFileHeader(CommentComposer.APACHE_LICENSE_COMMENT).build();
            return GapicClass.create(gapicClass.kind(), classWithHeader, gapicClass.samples());
        }).collect(Collectors.toList());
    }

    private static GapicPackageInfo addApacheLicense(GapicPackageInfo gapicPackageInfo) {
        return GapicPackageInfo.with(gapicPackageInfo.packageInfo().toBuilder().setFileHeader(CommentComposer.APACHE_LICENSE_COMMENT).build());
    }
}

