/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpContent;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.Strings;
import com.google.api.client.util.Types;
import com.google.api.client.util.escape.CharEscapers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public final class UrlEncodedContent
implements HttpContent {
    public String contentType = "application/x-www-form-urlencoded";
    public Object data;
    private byte[] content;

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        return this.computeContent().length;
    }

    public String getType() {
        return this.contentType;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.computeContent());
    }

    private byte[] computeContent() {
        if (this.content == null) {
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, Object> nameValueEntry : Data.mapOf(this.data).entrySet()) {
                Object value = nameValueEntry.getValue();
                if (value == null) continue;
                String name = CharEscapers.escapeUri(nameValueEntry.getKey());
                Class<?> valueClass = value.getClass();
                if (value instanceof Iterable || valueClass.isArray()) {
                    for (Object repeatedValue : Types.iterableOf(value)) {
                        first = UrlEncodedContent.appendParam(first, buf, name, repeatedValue);
                    }
                    continue;
                }
                first = UrlEncodedContent.appendParam(first, buf, name, value);
            }
            this.content = Strings.toBytesUtf8(buf.toString());
        }
        return this.content;
    }

    private static boolean appendParam(boolean first, StringBuilder buf, String name, Object value) {
        if (value == null || Data.isNull(value)) {
            return first;
        }
        if (first) {
            first = false;
        } else {
            buf.append('&');
        }
        buf.append(name);
        String stringValue = CharEscapers.escapeUri(value instanceof Enum ? FieldInfo.of((Enum)value).getName() : value.toString());
        if (stringValue.length() != 0) {
            buf.append('=').append(stringValue);
        }
        return first;
    }

    public boolean retrySupported() {
        return true;
    }
}

