/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.Key;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo {
    private static final ThreadLocal<WeakHashMap<Field, FieldInfo>> CACHE = new ThreadLocal<WeakHashMap<Field, FieldInfo>>(){

        @Override
        protected WeakHashMap<Field, FieldInfo> initialValue() {
            return new WeakHashMap<Field, FieldInfo>();
        }
    };
    public final boolean isFinal;
    public final boolean isPrimitive;
    public final Class<?> type;
    public final Field field;
    public final String name;

    public static FieldInfo of(Field field) {
        if (field == null) {
            return null;
        }
        WeakHashMap<Field, FieldInfo> cache = CACHE.get();
        FieldInfo fieldInfo = cache.get(field);
        if (fieldInfo == null && !Modifier.isStatic(field.getModifiers())) {
            Key key = field.getAnnotation(Key.class);
            if (key == null) {
                return null;
            }
            String fieldName = key.value();
            if ("##default".equals(fieldName)) {
                fieldName = field.getName();
            }
            fieldInfo = new FieldInfo(field, fieldName);
            cache.put(field, fieldInfo);
            field.setAccessible(true);
        }
        return fieldInfo;
    }

    FieldInfo(Field field, String name) {
        this.field = field;
        this.name = name.intern();
        this.isFinal = Modifier.isFinal(field.getModifiers());
        this.type = field.getType();
        Class<?> type = this.type;
        this.isPrimitive = FieldInfo.isPrimitive(type);
    }

    public Object getValue(Object obj) {
        return FieldInfo.getFieldValue(this.field, obj);
    }

    public void setValue(Object obj, Object value) {
        FieldInfo.setFieldValue(this.field, obj, value);
    }

    public ClassInfo getClassInfo() {
        return ClassInfo.of(this.field.getDeclaringClass());
    }

    public static boolean isPrimitive(Class<?> fieldClass) {
        return fieldClass.isPrimitive() || fieldClass == Character.class || fieldClass == String.class || fieldClass == Integer.class || fieldClass == Long.class || fieldClass == Short.class || fieldClass == Byte.class || fieldClass == Float.class || fieldClass == Double.class || fieldClass == BigInteger.class || fieldClass == BigDecimal.class || fieldClass == DateTime.class || fieldClass == Boolean.class;
    }

    public static boolean isPrimitive(Object fieldValue) {
        return fieldValue == null || FieldInfo.isPrimitive(fieldValue.getClass());
    }

    public static Object getFieldValue(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setFieldValue(Field field, Object obj, Object value) {
        if (Modifier.isFinal(field.getModifiers())) {
            Object finalValue = FieldInfo.getFieldValue(field, obj);
            if (value == null ? finalValue != null : !value.equals(finalValue)) {
                throw new IllegalArgumentException("expected final value <" + finalValue + "> but was <" + value + "> on " + field.getName() + " field in " + obj.getClass().getName());
            }
        } else {
            try {
                field.set(obj, value);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static Object parsePrimitiveValue(Class<?> primitiveClass, String stringValue) {
        if (stringValue == null || primitiveClass == null || primitiveClass == String.class) {
            return stringValue;
        }
        if (primitiveClass == Character.class || primitiveClass == Character.TYPE) {
            if (stringValue.length() != 1) {
                throw new IllegalArgumentException("expected type Character/char but got " + primitiveClass);
            }
            return Character.valueOf(stringValue.charAt(0));
        }
        if (primitiveClass == Boolean.class || primitiveClass == Boolean.TYPE) {
            return Boolean.valueOf(stringValue);
        }
        if (primitiveClass == Byte.class || primitiveClass == Byte.TYPE) {
            return Byte.valueOf(stringValue);
        }
        if (primitiveClass == Short.class || primitiveClass == Short.TYPE) {
            return Short.valueOf(stringValue);
        }
        if (primitiveClass == Integer.class || primitiveClass == Integer.TYPE) {
            return Integer.valueOf(stringValue);
        }
        if (primitiveClass == Long.class || primitiveClass == Long.TYPE) {
            return Long.valueOf(stringValue);
        }
        if (primitiveClass == Float.class || primitiveClass == Float.TYPE) {
            return Float.valueOf(stringValue);
        }
        if (primitiveClass == Double.class || primitiveClass == Double.TYPE) {
            return Double.valueOf(stringValue);
        }
        if (primitiveClass == DateTime.class) {
            return DateTime.parseRfc3339(stringValue);
        }
        if (primitiveClass == BigInteger.class) {
            return new BigInteger(stringValue);
        }
        if (primitiveClass == BigDecimal.class) {
            return new BigDecimal(stringValue);
        }
        throw new IllegalArgumentException("expected primitive class, but got: " + primitiveClass);
    }
}

