/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.storage;

import com.google.api.client.auth.HmacSha;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

@Deprecated
public final class GoogleStorageAuthentication
implements HttpExecuteInterceptor,
HttpRequestInitializer {
    static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private final String accessKey;
    private final String secret;
    private static final String HOST = "commondatastorage.googleapis.com";

    public GoogleStorageAuthentication(String accessKey, String secret) {
        this.accessKey = accessKey;
        this.secret = secret;
    }

    public void initialize(HttpRequest request) {
        request.interceptor = this;
    }

    public void intercept(HttpRequest request) throws IOException {
        String bucket;
        String contentType;
        HttpHeaders headers = request.headers;
        StringBuilder messageBuf = new StringBuilder();
        messageBuf.append(request.method).append('\n');
        String contentMD5 = headers.contentMD5;
        if (contentMD5 != null) {
            messageBuf.append(contentMD5);
        }
        messageBuf.append('\n');
        HttpContent content = request.content;
        if (content != null && (contentType = content.getType()) != null) {
            messageBuf.append(contentType);
        }
        messageBuf.append('\n');
        String date = headers.date;
        if (date != null) {
            messageBuf.append(headers.date);
        }
        messageBuf.append('\n');
        TreeMap<String, String> extensions = new TreeMap<String, String>();
        for (Map.Entry entry : headers.entrySet()) {
            String name = ((String)entry.getKey()).toLowerCase();
            Object value = entry.getValue();
            if (value == null || !name.startsWith("x-goog-")) continue;
            if (value instanceof Collection) {
                Collection collectionValue = (Collection)value;
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                for (Object repeatedValue : collectionValue) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(',');
                    }
                    buf.append(WHITESPACE_PATTERN.matcher(repeatedValue.toString()).replaceAll(" "));
                }
                extensions.put(name, buf.toString());
                continue;
            }
            extensions.put(name, WHITESPACE_PATTERN.matcher(value.toString()).replaceAll(" "));
        }
        for (Map.Entry entry : extensions.entrySet()) {
            messageBuf.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append('\n');
        }
        GenericUrl url = request.url;
        String string = url.host;
        if (!string.endsWith(HOST)) {
            throw new IllegalArgumentException("missing host commondatastorage.googleapis.com");
        }
        int bucketNameLength = string.length() - HOST.length() - 1;
        if (bucketNameLength > 0 && !(bucket = string.substring(0, bucketNameLength)).equals("c")) {
            messageBuf.append('/').append(bucket);
        }
        if (url.pathParts != null) {
            messageBuf.append(url.getRawPath());
        }
        if (url.get((Object)"acl") != null) {
            messageBuf.append("?acl");
        } else if (url.get((Object)"location") != null) {
            messageBuf.append("?location");
        } else if (url.get((Object)"logging") != null) {
            messageBuf.append("?logging");
        } else if (url.get((Object)"requestPayment") != null) {
            messageBuf.append("?requestPayment");
        } else if (url.get((Object)"torrent") != null) {
            messageBuf.append("?torrent");
        }
        try {
            request.headers.authorization = "GOOG1 " + this.accessKey + ":" + HmacSha.sign((String)this.secret, (String)messageBuf.toString());
        }
        catch (GeneralSecurityException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
    }
}

