/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import junit.framework.TestCase;

public class GoogleIdTokenTest
extends TestCase {
    private static final String USER_ID = "1234567890";
    private static final String ANOTHER_USER_ID = "2345678901";
    private static final String CLIENT_ID = "myClientId";
    private static final String ANOTHER_CLIENT_ID = "anotherClientId";
    private static final String EMAIL_VERIFIED_KEY = "email_verified";

    private static GoogleIdToken.Payload newPayload(String userId, String clientId) {
        GoogleIdToken.Payload payload = new GoogleIdToken.Payload();
        payload.setIssuer("accounts.google.com");
        payload.setAudience((Object)clientId);
        payload.setAuthorizedParty(clientId);
        payload.setSubject(userId);
        payload.setExpirationTimeSeconds(Long.valueOf(100L));
        payload.setIssuedAtTimeSeconds(Long.valueOf(0L));
        return payload;
    }

    public void testDeprecatedMethods() {
        GoogleIdToken.Payload payload = GoogleIdTokenTest.newPayload(USER_ID, CLIENT_ID);
        GoogleIdTokenTest.assertEquals((String)USER_ID, (String)payload.getUserId());
        GoogleIdTokenTest.assertEquals((String)CLIENT_ID, (String)payload.getIssuee());
        payload.setUserId(ANOTHER_USER_ID);
        payload.setIssuee(ANOTHER_CLIENT_ID);
        GoogleIdTokenTest.assertEquals((String)ANOTHER_USER_ID, (String)payload.getUserId());
        GoogleIdTokenTest.assertEquals((String)ANOTHER_CLIENT_ID, (String)payload.getIssuee());
        GoogleIdTokenTest.assertEquals((String)ANOTHER_USER_ID, (String)payload.getSubject());
        GoogleIdTokenTest.assertEquals((String)ANOTHER_CLIENT_ID, (String)payload.getAuthorizedParty());
    }

    public void testEmailVerified() {
        GoogleIdToken.Payload payload = GoogleIdTokenTest.newPayload(USER_ID, CLIENT_ID);
        GoogleIdTokenTest.assertNull((Object)payload.getEmailVerified());
        payload.setEmailVerified(Boolean.valueOf(true));
        GoogleIdTokenTest.assertTrue((boolean)payload.getEmailVerified());
        payload.setEmailVerified(Boolean.valueOf(false));
        GoogleIdTokenTest.assertFalse((boolean)payload.getEmailVerified());
        payload.setEmailVerified(null);
        GoogleIdTokenTest.assertNull((Object)payload.getEmailVerified());
        payload.set(EMAIL_VERIFIED_KEY, (Object)"true");
        GoogleIdTokenTest.assertTrue((boolean)payload.getEmailVerified());
        payload.set(EMAIL_VERIFIED_KEY, (Object)true);
        GoogleIdTokenTest.assertTrue((boolean)payload.getEmailVerified());
        payload.set(EMAIL_VERIFIED_KEY, (Object)"false");
        GoogleIdTokenTest.assertFalse((boolean)payload.getEmailVerified());
        payload.set(EMAIL_VERIFIED_KEY, (Object)false);
        GoogleIdTokenTest.assertFalse((boolean)payload.getEmailVerified());
        payload.set(EMAIL_VERIFIED_KEY, (Object)"RandomString");
        GoogleIdTokenTest.assertFalse((boolean)payload.getEmailVerified());
        payload.set(EMAIL_VERIFIED_KEY, (Object)"");
        GoogleIdTokenTest.assertFalse((boolean)payload.getEmailVerified());
        payload.set(EMAIL_VERIFIED_KEY, null);
        GoogleIdTokenTest.assertNull((Object)payload.getEmailVerified());
        payload.set(EMAIL_VERIFIED_KEY, (Object)new Integer(5));
        try {
            payload.getEmailVerified();
            GoogleIdTokenTest.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

