/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.servlet.subscriptions;

import com.google.api.client.googleapis.subscriptions.StoredSubscription;
import com.google.api.client.googleapis.subscriptions.SubscriptionStore;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Lists;
import com.google.api.client.util.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Beta
public final class JdoSubscriptionStore
implements SubscriptionStore {
    private final PersistenceManagerFactory persistenceManagerFactory;

    public JdoSubscriptionStore(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = persistenceManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSubscription(StoredSubscription subscription) {
        Preconditions.checkNotNull((Object)subscription);
        JdoStoredSubscription dbEntry = this.getStoredSubscription(subscription.getId());
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            if (dbEntry != null) {
                dbEntry.setSubscription(subscription);
            } else {
                dbEntry = new JdoStoredSubscription(subscription);
                persistenceManager.makePersistent((Object)dbEntry);
            }
        }
        finally {
            persistenceManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(StoredSubscription subscription) {
        JdoStoredSubscription dbEntry = this.getStoredSubscription(subscription.getId());
        if (dbEntry != null) {
            PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
            try {
                persistenceManager.deletePersistent((Object)dbEntry);
            }
            finally {
                persistenceManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoredSubscription> listSubscriptions() {
        ArrayList list = Lists.newArrayList();
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            Query listQuery = persistenceManager.newQuery(JdoStoredSubscription.class);
            Iterable resultList = (Iterable)listQuery.execute();
            for (JdoStoredSubscription dbEntry : resultList) {
                list.add(dbEntry.getSubscription());
            }
        }
        finally {
            persistenceManager.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdoStoredSubscription getStoredSubscription(String subscriptionID) {
        Iterable results = null;
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        try {
            Query getByIDQuery = persistenceManager.newQuery(JdoStoredSubscription.class);
            getByIDQuery.setFilter("subscriptionId == idParam");
            getByIDQuery.declareParameters("String idParam");
            getByIDQuery.setRange(0L, 1L);
            results = (Iterable)getByIDQuery.execute((Object)subscriptionID);
            Iterator i$ = results.iterator();
            if (i$.hasNext()) {
                JdoStoredSubscription dbEntry;
                JdoStoredSubscription jdoStoredSubscription = dbEntry = (JdoStoredSubscription)i$.next();
                return jdoStoredSubscription;
            }
            JdoStoredSubscription jdoStoredSubscription = null;
            return jdoStoredSubscription;
        }
        finally {
            persistenceManager.close();
        }
    }

    public StoredSubscription getSubscription(String subscriptionID) {
        JdoStoredSubscription dbEntry = this.getStoredSubscription(subscriptionID);
        return dbEntry == null ? null : dbEntry.getSubscription();
    }

    @javax.jdo.annotations.PersistenceCapable
    @Beta
    private static final class JdoStoredSubscription
    implements PersistenceCapable {
        @Persistent(serialized="true")
        private StoredSubscription subscription;
        @Persistent
        @PrimaryKey
        private String subscriptionId;
        protected transient StateManager jdoStateManager;
        protected transient byte jdoFlags;
        private static final byte[] jdoFieldFlags;
        private static final Class jdoPersistenceCapableSuperclass;
        private static final Class[] jdoFieldTypes;
        private static final String[] jdoFieldNames;
        private static final int jdoInheritedFieldCount;

        JdoStoredSubscription() {
        }

        public JdoStoredSubscription(StoredSubscription s) {
            this.setSubscription(s);
        }

        public StoredSubscription getSubscription() {
            return JdoStoredSubscription.jdoGetsubscription(this);
        }

        public String getSubscriptionId() {
            return JdoStoredSubscription.jdoGetsubscriptionId(this);
        }

        public void setSubscription(StoredSubscription subscription) {
            JdoStoredSubscription.jdoSetsubscription(this, subscription);
            JdoStoredSubscription.jdoSetsubscriptionId(this, subscription.getId());
        }

        static {
            jdoFieldNames = JdoStoredSubscription.__jdoFieldNamesInit();
            jdoFieldTypes = JdoStoredSubscription.__jdoFieldTypesInit();
            jdoFieldFlags = JdoStoredSubscription.__jdoFieldFlagsInit();
            jdoInheritedFieldCount = JdoStoredSubscription.__jdoGetInheritedFieldCount();
            jdoPersistenceCapableSuperclass = JdoStoredSubscription.__jdoPersistenceCapableSuperclassInit();
            JDOImplHelper.registerClass((Class)JdoStoredSubscription.___jdo$loadClass("com.google.api.client.googleapis.extensions.servlet.subscriptions.JdoSubscriptionStore$JdoStoredSubscription"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new JdoStoredSubscription());
        }

        public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
            if (fc == null) {
                throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
            }
            if (!(oid instanceof StringIdentity)) {
                throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
            }
            StringIdentity o = (StringIdentity)oid;
            fc.storeStringField(1, o.getKey());
        }

        protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
            if (!(oid instanceof StringIdentity)) {
                throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
            }
            StringIdentity o = (StringIdentity)oid;
            this.subscriptionId = o.getKey();
        }

        public final void jdoCopyKeyFieldsToObjectId(Object oid) {
            throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
        }

        public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
            throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
        }

        public final Object jdoGetObjectId() {
            if (this.jdoStateManager != null) {
                return this.jdoStateManager.getObjectId((PersistenceCapable)this);
            }
            return null;
        }

        public final Object jdoGetVersion() {
            if (this.jdoStateManager != null) {
                return this.jdoStateManager.getVersion((PersistenceCapable)this);
            }
            return null;
        }

        protected final void jdoPreSerialize() {
            if (this.jdoStateManager != null) {
                this.jdoStateManager.preSerialize((PersistenceCapable)this);
            }
        }

        public final PersistenceManager jdoGetPersistenceManager() {
            return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
        }

        public final Object jdoGetTransactionalObjectId() {
            return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
        }

        public final boolean jdoIsDeleted() {
            return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
        }

        public final boolean jdoIsDirty() {
            if (this.jdoStateManager != null) {
                return this.jdoStateManager.isDirty((PersistenceCapable)this);
            }
            return false;
        }

        public final boolean jdoIsNew() {
            return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
        }

        public final boolean jdoIsPersistent() {
            return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
        }

        public final boolean jdoIsTransactional() {
            return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
        }

        public void jdoMakeDirty(String fieldName) {
            if (this.jdoStateManager != null) {
                this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
            }
        }

        public final Object jdoNewObjectIdInstance() {
            return new StringIdentity(this.getClass(), this.subscriptionId);
        }

        public final Object jdoNewObjectIdInstance(Object key) {
            if (key == null) {
                throw new IllegalArgumentException("key is null");
            }
            if (!(key instanceof String)) {
                return new StringIdentity(this.getClass(), (String)key);
            }
            return new StringIdentity(this.getClass(), (String)key);
        }

        public final void jdoProvideFields(int[] indices) {
            if (indices == null) {
                throw new IllegalArgumentException("argment is null");
            }
            int i = indices.length - 1;
            if (i >= 0) {
                do {
                    this.jdoProvideField(indices[i]);
                } while (--i >= 0);
            }
        }

        public final void jdoReplaceFields(int[] indices) {
            if (indices == null) {
                throw new IllegalArgumentException("argument is null");
            }
            int i = indices.length;
            if (i > 0) {
                int j = 0;
                do {
                    this.jdoReplaceField(indices[j]);
                } while (++j < i);
            }
        }

        public final void jdoReplaceFlags() {
            if (this.jdoStateManager != null) {
                this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
            }
        }

        public final synchronized void jdoReplaceStateManager(StateManager sm) {
            if (this.jdoStateManager != null) {
                this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
            } else {
                JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
                this.jdoStateManager = sm;
                this.jdoFlags = 1;
            }
        }

        public boolean jdoIsDetached() {
            return false;
        }

        public PersistenceCapable jdoNewInstance(StateManager sm) {
            JdoStoredSubscription result = new JdoStoredSubscription();
            result.jdoFlags = 1;
            result.jdoStateManager = sm;
            return result;
        }

        public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
            JdoStoredSubscription result = new JdoStoredSubscription();
            result.jdoFlags = 1;
            result.jdoStateManager = sm;
            result.jdoCopyKeyFieldsFromObjectId(obj);
            return result;
        }

        public void jdoReplaceField(int index) {
            if (this.jdoStateManager == null) {
                throw new IllegalStateException("state manager is null");
            }
            switch (index) {
                case 0: {
                    this.subscription = (StoredSubscription)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                    break;
                }
                case 1: {
                    this.subscriptionId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
                }
            }
        }

        public void jdoProvideField(int index) {
            if (this.jdoStateManager == null) {
                throw new IllegalStateException("state manager is null");
            }
            switch (index) {
                case 0: {
                    this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.subscription);
                    break;
                }
                case 1: {
                    this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.subscriptionId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
                }
            }
        }

        protected final void jdoCopyField(JdoStoredSubscription obj, int index) {
            switch (index) {
                case 0: {
                    this.subscription = obj.subscription;
                    break;
                }
                case 1: {
                    this.subscriptionId = obj.subscriptionId;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
                }
            }
        }

        public void jdoCopyFields(Object obj, int[] indices) {
            if (this.jdoStateManager == null) {
                throw new IllegalStateException("state manager is null");
            }
            if (indices == null) {
                throw new IllegalStateException("fieldNumbers is null");
            }
            if (!(obj instanceof JdoStoredSubscription)) {
                throw new IllegalArgumentException("object is not an object of type com.google.api.client.googleapis.extensions.servlet.subscriptions.JdoSubscriptionStore$JdoStoredSubscription");
            }
            JdoStoredSubscription other = (JdoStoredSubscription)obj;
            if (this.jdoStateManager != other.jdoStateManager) {
                throw new IllegalArgumentException("state managers do not match");
            }
            int i = indices.length - 1;
            if (i >= 0) {
                do {
                    this.jdoCopyField(other, indices[i]);
                } while (--i >= 0);
            }
        }

        private static final String[] __jdoFieldNamesInit() {
            return new String[]{"subscription", "subscriptionId"};
        }

        private static final Class[] __jdoFieldTypesInit() {
            return new Class[]{JdoStoredSubscription.___jdo$loadClass("com.google.api.client.googleapis.subscriptions.StoredSubscription"), JdoStoredSubscription.___jdo$loadClass("java.lang.String")};
        }

        private static final byte[] __jdoFieldFlagsInit() {
            return new byte[]{26, 24};
        }

        protected static int __jdoGetInheritedFieldCount() {
            return 0;
        }

        protected static int jdoGetManagedFieldCount() {
            return 2;
        }

        private static Class __jdoPersistenceCapableSuperclassInit() {
            return null;
        }

        public static Class ___jdo$loadClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
        }

        private Object jdoSuperClone() throws CloneNotSupportedException {
            JdoStoredSubscription o = (JdoStoredSubscription)super.clone();
            o.jdoFlags = 0;
            o.jdoStateManager = null;
            return o;
        }

        private static StoredSubscription jdoGetsubscription(JdoStoredSubscription objPC) {
            if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
                return (StoredSubscription)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.subscription);
            }
            return objPC.subscription;
        }

        private static void jdoSetsubscription(JdoStoredSubscription objPC, StoredSubscription val) {
            if (objPC.jdoStateManager == null) {
                objPC.subscription = val;
            } else {
                objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.subscription, (Object)val);
            }
        }

        private static String jdoGetsubscriptionId(JdoStoredSubscription objPC) {
            return objPC.subscriptionId;
        }

        private static void jdoSetsubscriptionId(JdoStoredSubscription objPC, String val) {
            if (objPC.jdoStateManager == null) {
                objPC.subscriptionId = val;
            } else {
                objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.subscriptionId, val);
            }
        }
    }
}

