/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.appengine.auth.oauth2;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppIdentityCredential
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final AppIdentityService appIdentityService;
    private final Collection<String> scopes;

    public AppIdentityCredential(Collection<String> scopes) {
        this(new Builder(scopes));
    }

    protected AppIdentityCredential(Builder builder) {
        this.appIdentityService = builder.appIdentityService == null ? AppIdentityServiceFactory.getAppIdentityService() : builder.appIdentityService;
        this.scopes = builder.scopes;
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor((HttpExecuteInterceptor)this);
    }

    public void intercept(HttpRequest request) throws IOException {
        String accessToken = this.appIdentityService.getAccessToken(this.scopes).getAccessToken();
        BearerToken.authorizationHeaderAccessMethod().intercept(request, accessToken);
    }

    public final AppIdentityService getAppIdentityService() {
        return this.appIdentityService;
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        AppIdentityService appIdentityService;
        final Collection<String> scopes;

        public Builder(Collection<String> scopes) {
            this.scopes = Collections.unmodifiableCollection(scopes);
        }

        public final AppIdentityService getAppIdentityService() {
            return this.appIdentityService;
        }

        public Builder setAppIdentityService(AppIdentityService appIdentityService) {
            this.appIdentityService = appIdentityService;
            return this;
        }

        public AppIdentityCredential build() {
            return new AppIdentityCredential(this);
        }

        public final Collection<String> getScopes() {
            return this.scopes;
        }
    }
}

