/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.extensions.appengine.subscriptions;

import com.google.api.client.googleapis.extensions.appengine.subscriptions.AppEngineSubscriptionStore;
import com.google.api.client.googleapis.subscriptions.Subscription;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import java.io.IOException;

public final class CachedAppEngineSubscriptionStore
extends AppEngineSubscriptionStore {
    private static final int EXPIRATION_TIME = 3600;
    private MemcacheService memCache = MemcacheServiceFactory.getMemcacheService((String)CachedAppEngineSubscriptionStore.class.getCanonicalName());

    public void removeSubscription(Subscription subscription) throws IOException {
        super.removeSubscription(subscription);
        this.memCache.delete((Object)subscription.getSubscriptionId());
    }

    public void storeSubscription(Subscription subscription) throws IOException {
        super.storeSubscription(subscription);
        this.memCache.put((Object)subscription.getSubscriptionId(), (Object)subscription);
    }

    public Subscription getSubscription(String subscriptionId) throws IOException {
        if (this.memCache.contains((Object)subscriptionId)) {
            return (Subscription)this.memCache.get((Object)subscriptionId);
        }
        Subscription subscription = super.getSubscription(subscriptionId);
        this.memCache.put((Object)subscriptionId, (Object)subscription, Expiration.byDeltaSeconds((int)3600));
        return subscription;
    }
}

