/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.admanager.axis;

import com.google.api.ads.admanager.lib.client.AdManagerServiceDescriptor;
import com.google.api.ads.admanager.lib.client.AdManagerSession;
import com.google.api.ads.admanager.lib.conf.AdManagerApiConfiguration;
import com.google.api.ads.admanager.lib.soap.AdManagerHttpHeaderHandler;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.HeaderHandler;
import com.google.api.ads.common.lib.conf.AdsLibConfiguration;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.soap.AuthorizationHeaderHandler;
import com.google.api.ads.common.lib.soap.axis.AxisHandler;
import com.google.api.ads.common.lib.useragent.UserAgentCombiner;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.axis.client.Stub;
import org.apache.commons.beanutils.BeanUtils;

public class AdManagerAxisHeaderHandler
implements HeaderHandler<AdManagerSession, AdManagerServiceDescriptor> {
    private final AxisHandler soapClientHandler;
    private final AdManagerApiConfiguration adManagerApiConfiguration;
    private final AuthorizationHeaderHandler authorizationHeaderHandler;
    private final AdManagerHttpHeaderHandler adManagerHttpHeaderHandler;
    private final UserAgentCombiner userAgentCombiner;
    private final AdsLibConfiguration adsLibConfiguration;

    @Inject
    public AdManagerAxisHeaderHandler(AxisHandler soapClientHandler, AdManagerApiConfiguration adManagerApiConfiguration, AdsLibConfiguration adsLibConfiguration, AuthorizationHeaderHandler authorizationHeaderHandler, AdManagerHttpHeaderHandler adManagerHttpHeaderHandler, UserAgentCombiner userAgentCombiner) {
        this.soapClientHandler = soapClientHandler;
        this.adManagerApiConfiguration = adManagerApiConfiguration;
        this.adsLibConfiguration = adsLibConfiguration;
        this.authorizationHeaderHandler = authorizationHeaderHandler;
        this.adManagerHttpHeaderHandler = adManagerHttpHeaderHandler;
        this.userAgentCombiner = userAgentCombiner;
    }

    public void setHeaders(Object soapClient, AdManagerSession adManagerSession, AdManagerServiceDescriptor adManagerServiceDescriptor) throws AuthenticationException, ServiceException {
        try {
            Preconditions.checkArgument((boolean)(soapClient instanceof Stub), (String)"soapClient must be Stub but was: %s", (Object)soapClient);
            Stub stub = (Stub)soapClient;
            this.adManagerHttpHeaderHandler.setHttpHeaders(soapClient, adManagerSession);
            Object soapHeader = this.createSoapHeader(adManagerServiceDescriptor);
            BeanUtils.setProperty((Object)soapHeader, (String)"applicationName", (Object)this.userAgentCombiner.getUserAgent(adManagerSession.getApplicationName()));
            if (adManagerSession.getNetworkCode() != null) {
                BeanUtils.setProperty((Object)soapHeader, (String)"networkCode", (Object)adManagerSession.getNetworkCode());
            }
            this.setAuthenticationHeaders(soapClient, adManagerSession);
            String namespace = this.adManagerApiConfiguration.getNamespacePrefix() + "/" + adManagerServiceDescriptor.getVersion();
            this.soapClientHandler.setHeader(stub, namespace, "RequestHeader", soapHeader);
            this.soapClientHandler.setCompression(stub, this.adsLibConfiguration.isCompressionEnabled());
            this.soapClientHandler.setRequestTimeout(stub, this.adsLibConfiguration.getSoapRequestTimeout());
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceException("Unexpected exception.", (Throwable)e);
        }
    }

    private void setAuthenticationHeaders(Object soapClient, AdManagerSession adManagerSession) throws AuthenticationException {
        this.authorizationHeaderHandler.setAuthorization(soapClient, (AdsSession)adManagerSession);
    }

    private Object createSoapHeader(AdManagerServiceDescriptor adsServiceDescriptor) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(adsServiceDescriptor.getInterfaceClass().getPackage().getName() + ".SoapRequestHeader").newInstance();
    }
}

